/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.launcher;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.launcher.BLauncherException;
import io.ballerina.cli.launcher.util.BalToolsUtil;
import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.BalToolsToml;
import io.ballerina.projects.internal.BalToolsManifestBuilder;
import io.ballerina.runtime.api.values.BError;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

public final class LauncherUtils {
    private LauncherUtils() {
    }

    public static Path getSourceRootPath(String sourceRoot) {
        Path sourceRootPath;
        if (sourceRoot == null || sourceRoot.isEmpty()) {
            sourceRootPath = Path.of(System.getProperty("user.dir"), new String[0]);
        } else {
            try {
                sourceRootPath = Path.of(sourceRoot, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS);
            }
            catch (IOException e) {
                throw new RuntimeException("error reading from directory: " + sourceRoot + " reason: " + e.getMessage(), e);
            }
            if (!Files.isDirectory(sourceRootPath, LinkOption.NOFOLLOW_LINKS)) {
                throw new RuntimeException("source root must be a directory");
            }
        }
        return sourceRootPath;
    }

    public static BLauncherException createUsageExceptionWithHelp(String errorMsg) {
        BLauncherException launcherException = new BLauncherException();
        launcherException.addMessage("ballerina: " + errorMsg);
        launcherException.addMessage("Run 'bal help' for usage.");
        return launcherException;
    }

    public static BLauncherException createLauncherException(String errorMsg) {
        BLauncherException launcherException = new BLauncherException();
        launcherException.addMessage("error: " + errorMsg);
        return launcherException;
    }

    public static BLauncherException createLauncherException(String errorPrefix, Throwable cause) {
        String message;
        if (cause instanceof BError) {
            BError bError = (BError)cause;
            message = bError.getPrintableStackTrace();
        } else {
            StringWriter sw = new StringWriter();
            cause.printStackTrace(new PrintWriter(sw));
            message = sw.toString();
        }
        BLauncherException launcherException = new BLauncherException();
        launcherException.addMessage("error: " + errorPrefix + message);
        return launcherException;
    }

    public static String prepareCompilerErrorMessage(String message) {
        return "error: " + LauncherUtils.makeFirstLetterLowerCase(message);
    }

    public static void printLauncherException(BLauncherException e, PrintStream outStream) {
        List<String> errorMessages = e.getMessages();
        errorMessages.forEach(outStream::println);
    }

    static String makeFirstLetterLowerCase(String s) {
        if (s == null) {
            return null;
        }
        char[] c = s.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    static String generateGeneralHelp(Map<String, CommandLine> subCommands) {
        StringBuilder helpBuilder = new StringBuilder();
        helpBuilder.append(BLauncherCmd.getCommandUsageInfo("help"));
        Path balToolsTomlPath = RepoUtils.createAndGetHomeReposPath().resolve(".config").resolve("bal-tools.toml");
        BalToolsToml balToolsToml = BalToolsToml.from((Path)balToolsTomlPath);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        HashMap activeToolsVsRepos = new HashMap();
        List<String> toolNames = subCommands.keySet().stream().filter(BalToolsUtil::isNonBuiltInToolCommand).sorted().toList();
        if (!toolNames.isEmpty()) {
            toolNames.forEach(toolName -> balToolsManifest.getActiveTool(toolName).ifPresent(tool -> activeToolsVsRepos.put(toolName, tool.repository() == null ? "" : "[" + tool.repository().toUpperCase() + "] ")));
            helpBuilder.append("\n\n   Tool Commands:");
            toolNames.forEach(key -> LauncherUtils.generateCommandDescription((CommandLine)subCommands.get(key), helpBuilder, (String)activeToolsVsRepos.get(key)));
        }
        return helpBuilder.toString();
    }

    static String generateCommandHelp(String commandName, Map<String, CommandLine> subCommands) {
        if (!BalToolsUtil.isNonBuiltInToolCommand(commandName)) {
            return BLauncherCmd.getCommandUsageInfo(commandName);
        }
        StringBuilder commandUsageInfo = new StringBuilder();
        BLauncherCmd cmd = (BLauncherCmd)subCommands.get(commandName).getCommand();
        cmd.printLongDesc(commandUsageInfo);
        return commandUsageInfo.toString();
    }

    private static void generateCommandDescription(CommandLine command, StringBuilder stringBuilder, String repository) {
        String[] descValues;
        String commandName = command.getCommandName();
        BLauncherCmd bLauncherCmd = (BLauncherCmd)command.getCommandSpec().userObject();
        CommandLine.Command annotation = bLauncherCmd.getClass().getAnnotation(CommandLine.Command.class);
        String commandDescription = "";
        if (annotation != null && (descValues = annotation.description()) != null && descValues.length > 0) {
            commandDescription = LauncherUtils.wrapString(descValues[0], 64, 24);
        }
        stringBuilder.append("\n").append("        ").append(String.format("%-15s %s", commandName, repository + commandDescription));
    }

    static String wrapString(String str, int wrapLength, int indent) {
        StringBuilder wrappedStr = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            int lastWhitespace;
            int lineEnd;
            if (Character.isWhitespace(str.charAt(i))) {
                ++i;
                continue;
            }
            if (i > 0) {
                wrappedStr.append("\n");
                wrappedStr.append(" ".repeat(indent));
            }
            if ((lineEnd = Math.min(i + wrapLength, str.length())) < str.length() && !Character.isWhitespace(str.charAt(lineEnd)) && (lastWhitespace = str.lastIndexOf(32, lineEnd)) > i) {
                lineEnd = lastWhitespace;
            }
            wrappedStr.append(str, i, lineEnd);
            for (i = lineEnd; i < str.length() && Character.isWhitespace(str.charAt(i)); ++i) {
            }
        }
        return wrappedStr.toString();
    }
}

