/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.launcher.util;

import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.cmd.ToolCommand;
import io.ballerina.cli.launcher.CustomToolClassLoader;
import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.BalToolsToml;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.internal.BalToolsManifestBuilder;
import io.ballerina.projects.internal.BalaFiles;
import io.ballerina.projects.internal.model.PackageJson;
import io.ballerina.projects.util.ProjectUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.RepoUtils;

public final class BalToolsUtil {
    private static final String TOOL = "tool";
    private static final String LIBS = "libs";
    private static final List<String> options = Arrays.asList("--version", "-v", "--help", "-h", "--debug");
    private static final List<String> coreCommands = Arrays.asList("build", "run", "test", "doc", "pack");
    private static final List<String> packageCommands = Arrays.asList("new", "add", "pull", "push", "search", "semver", "graph", "deprecate");
    private static final List<String> otherCommands = Arrays.asList("clean", "format", "bindgen", "shell", "version", "openapi", "graphql", "asyncapi", "grpc", "persist", "profile");
    private static final List<String> hiddenCommands = Arrays.asList("init", "tool", "dist", "update", "start-language-server", "language-server-spec", "start-debugger-adapter", "help", "home", "gencache");
    private static final List<String> builtInToolCommands = List.of();
    private static final Path balaCacheDirPath = ProjectUtils.createAndGetHomeReposPath().resolve("repositories").resolve("central.ballerina.io").resolve("bala");

    private BalToolsUtil() {
    }

    public static boolean isNonBuiltInToolCommand(String commandName) {
        return BalToolsUtil.isToolCommand(commandName) && !builtInToolCommands.contains(commandName);
    }

    public static boolean isToolCommand(String commandName) {
        return Stream.of(options, coreCommands, packageCommands, otherCommands, hiddenCommands).flatMap(Collection::stream).noneMatch(commandName::equals);
    }

    public static CustomToolClassLoader getCustomToolClassLoader(String commandName) {
        List<File> toolJars = BalToolsUtil.getToolCommandJarAndDependencyJars(commandName);
        URL[] urls = (URL[])toolJars.stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw LauncherUtils.createUsageExceptionWithHelp("invalid tool jar: " + file.getAbsolutePath());
            }
        }).toArray(URL[]::new);
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        return new CustomToolClassLoader(urls, systemClassLoader);
    }

    public static void addToolIfCommandIsABuiltInTool(String commandName) {
        if (!builtInToolCommands.contains(commandName)) {
            return;
        }
        BalToolsToml balToolsToml = BalToolsToml.from((Path)ProjectUtils.BAL_TOOLS_TOML_PATH);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        if (balToolsManifest.getActiveTool(commandName).isPresent()) {
            return;
        }
        ToolCommand toolCommand = new ToolCommand();
        toolCommand.pullToolAndUpdateBalToolsToml(commandName, Names.EMPTY.getValue());
    }

    private static List<File> getToolCommandJarAndDependencyJars(String commandName) {
        Path userHomeDirPath = RepoUtils.createAndGetHomeReposPath();
        Path balToolsTomlPath = userHomeDirPath.resolve(Path.of(".config", "bal-tools.toml"));
        Path centralBalaDirPath = userHomeDirPath.resolve(Path.of("repositories", "central.ballerina.io", "bala"));
        Path localBalaDirPath = userHomeDirPath.resolve(Path.of("repositories", "local", "bala"));
        BalToolsToml balToolsToml = BalToolsToml.from((Path)balToolsTomlPath);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        if ("help".equals(commandName)) {
            return balToolsManifest.tools().values().stream().flatMap(map -> map.values().stream()).flatMap(map -> map.values().stream()).filter(BalToolsManifest.Tool::active).map(tool1 -> BalToolsUtil.findJarFiles(CommandUtil.getPlatformSpecificBalaPath(tool1.org(), tool1.name(), tool1.version(), "local".equals(tool1.repository()) ? localBalaDirPath : centralBalaDirPath).resolve(TOOL).resolve(LIBS).toFile())).flatMap(Collection::stream).toList();
        }
        Optional toolOpt = balToolsManifest.getActiveTool(commandName);
        if (toolOpt.isPresent()) {
            BalToolsManifest.Tool tool = (BalToolsManifest.Tool)toolOpt.get();
            if (!BalToolsUtil.isToolDistCompatibilityWithCurrentDist(tool)) {
                String errMsg = "tool '" + tool.id() + ":" + tool.version() + "' is not compatible with the current Ballerina distribution '" + RepoUtils.getBallerinaShortVersion() + "'. Use 'bal tool search' to select a version compatible with the current Ballerina distribution.";
                throw LauncherUtils.createLauncherException(errMsg);
            }
            Path platformPath = CommandUtil.getPlatformSpecificBalaPath(tool.org(), tool.name(), tool.version(), "local".equals(tool.repository()) ? localBalaDirPath : centralBalaDirPath);
            File libsDir = platformPath.resolve(Path.of(TOOL, LIBS)).toFile();
            return BalToolsUtil.findJarFiles(libsDir);
        }
        throw LauncherUtils.createUsageExceptionWithHelp("unknown command '" + commandName + "'");
    }

    private static boolean isToolDistCompatibilityWithCurrentDist(BalToolsManifest.Tool tool) {
        SemanticVersion currentDistVersion = SemanticVersion.from((String)RepoUtils.getBallerinaShortVersion());
        SemanticVersion toolDistVersion = BalToolsUtil.getToolDistVersionFromCentralCache(tool);
        return BalToolsUtil.isVersionsCompatible(currentDistVersion, toolDistVersion);
    }

    private static SemanticVersion getToolDistVersionFromCentralCache(BalToolsManifest.Tool tool) {
        Path centralBalaDirPath = ProjectUtils.createAndGetHomeReposPath().resolve(Path.of("repositories", "central.ballerina.io", "bala"));
        Path localBalaPath = ProjectUtils.createAndGetHomeReposPath().resolve(Path.of("repositories", "local", "bala"));
        Path balaPath = CommandUtil.getPlatformSpecificBalaPath(tool.org(), tool.name(), tool.version(), "local".equals(tool.repository()) ? localBalaPath : centralBalaDirPath);
        PackageJson packageJson = BalaFiles.readPackageJson((Path)balaPath);
        return SemanticVersion.from((String)packageJson.getBallerinaVersion());
    }

    private static boolean isVersionsCompatible(SemanticVersion localDistVersion, SemanticVersion toolDistVersion) {
        return localDistVersion.major() == toolDistVersion.major() && localDistVersion.minor() >= toolDistVersion.minor();
    }

    public static List<File> findJarFiles(File directory) {
        File[] files;
        ArrayList<File> jarFiles = new ArrayList<File>();
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().toLowerCase().endsWith(".jar")) continue;
                jarFiles.add(file);
            }
        }
        return jarFiles;
    }

    public static void updateOldBalToolsToml() {
        BalToolsToml balToolsToml = BalToolsToml.from((Path)ProjectUtils.BAL_TOOLS_TOML_PATH);
        BalToolsManifestBuilder balToolsManifestBuilder = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml);
        BalToolsManifest balToolsManifest = balToolsManifestBuilder.build();
        Map oldTools = balToolsManifestBuilder.getOldTools();
        if (oldTools.isEmpty()) {
            return;
        }
        oldTools.values().stream().forEach(tool -> {
            Path toolCachePath = balaCacheDirPath.resolve(Path.of(tool.org(), tool.name()));
            if (toolCachePath.toFile().isDirectory()) {
                List<String> versions = Arrays.stream(toolCachePath.toFile().listFiles((dir, name) -> {
                    try {
                        PackageVersion.from((String)name);
                        return true;
                    }
                    catch (ProjectException ignore) {
                        return false;
                    }
                })).map(File::getName).toList();
                Optional<String> latestVersion = BalToolsUtil.getLatestVersion(versions);
                versions.stream().forEach(version -> {
                    boolean isActive;
                    boolean bl = isActive = balToolsManifest.getActiveTool(tool.id()).isEmpty() && latestVersion.isPresent() && ((String)latestVersion.get()).equals(version);
                    if (balToolsManifest.getTool(tool.id(), version, null).isEmpty()) {
                        balToolsManifest.addTool(tool.id(), tool.org(), tool.name(), version, Boolean.valueOf(isActive), null);
                    }
                });
            }
        });
        balToolsToml.modify(balToolsManifest);
    }

    private static Optional<String> getLatestVersion(List<String> versions) {
        return versions.stream().map(SemanticVersion::from).max((v1, v2) -> {
            if (v1.greaterThan(v2)) {
                return 1;
            }
            if (v2.greaterThan(v1)) {
                return -1;
            }
            return 0;
        }).map(SemanticVersion::toString);
    }
}

