/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.task.Task;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.Project;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import org.ballerinalang.maven.Dependency;
import org.ballerinalang.maven.MavenResolver;
import org.ballerinalang.maven.Utils;
import org.ballerinalang.maven.exceptions.MavenResolverException;

public class ResolveMavenDependenciesTask
implements Task {
    private final transient PrintStream out;

    public ResolveMavenDependenciesTask(PrintStream out) {
        this.out = out;
    }

    @Override
    public void execute(Project project) {
        ArrayList platformLibraries = new ArrayList();
        ArrayList platformRepositories = new ArrayList();
        PackageManifest.Platform platform = null;
        for (JvmTarget jvmTarget : JvmTarget.values()) {
            platform = project.currentPackage().manifest().platform(jvmTarget.code());
            if (platform == null) continue;
            platformLibraries.addAll(platform.dependencies());
            platformRepositories.addAll(platform.repositories());
        }
        if (platformLibraries.isEmpty()) {
            return;
        }
        ArrayList<Map> mavenCustomRepos = new ArrayList<Map>();
        ArrayList<Map> mavenDependencies = new ArrayList<Map>();
        String targetRepo = project.sourceRoot().resolve("target").resolve("platform-libs").toAbsolutePath().toString();
        MavenResolver resolver = new MavenResolver(targetRepo);
        for (Map repository : platformRepositories) {
            if (repository.get("id") == null || repository.get("url") == null) {
                throw LauncherUtils.createLauncherException("custom maven repository properties are not specified for given platform repository.");
            }
            mavenCustomRepos.add(repository);
        }
        if (!mavenCustomRepos.isEmpty()) {
            for (Map repository : mavenCustomRepos) {
                if (repository.get("id") != null && repository.get("url") != null && repository.get("username") != null && repository.get("password") != null) {
                    resolver.addRepository(repository.get("id").toString(), repository.get("url").toString(), repository.get("username").toString(), repository.get("password").toString());
                    continue;
                }
                resolver.addRepository(repository.get("id").toString(), repository.get("url").toString());
            }
        }
        for (Map library : platformLibraries) {
            if (library.get("path") != null) continue;
            if (library.get("artifactId") == null || library.get("groupId") == null || library.get("version") == null) {
                throw LauncherUtils.createLauncherException("artifact-id, group-id, and version should be specified to resolve the maven dependency.");
            }
            mavenDependencies.add(library);
        }
        if (!mavenDependencies.isEmpty()) {
            this.out.println("Resolving Maven dependencies\n\tDownloading dependencies into " + targetRepo);
            for (Map library : mavenDependencies) {
                try {
                    Dependency dependency = resolver.resolve(library.get("groupId").toString(), library.get("artifactId").toString(), library.get("version").toString(), false);
                    library.put("path", Utils.getJarPath((String)targetRepo, (Dependency)dependency));
                }
                catch (MavenResolverException e) {
                    throw LauncherUtils.createLauncherException("cannot resolve " + library.get("artifactId").toString() + ": " + e.getMessage());
                }
            }
            this.out.println();
        }
    }
}

