/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.launcher.util.BalToolsUtil;
import io.ballerina.cli.task.Task;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.projects.BuildTool;
import io.ballerina.projects.BuildToolResolution;
import io.ballerina.projects.Diagnostics;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageConfig;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.Settings;
import io.ballerina.projects.buildtools.CodeGeneratorTool;
import io.ballerina.projects.buildtools.ToolContext;
import io.ballerina.projects.internal.PackageConfigCreator;
import io.ballerina.projects.internal.PackageDiagnostic;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.util.BuildToolUtils;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.toml.api.Toml;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.validator.schema.Schema;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.wso2.ballerinalang.util.RepoUtils;

public class RunBuildToolsTask
implements Task {
    public static final String DEFAULT_VERSION = "0.0.0";
    private final PrintStream outStream;
    private final boolean exitWhenFinish;
    private ClassLoader toolClassLoader = this.getClass().getClassLoader();
    ServiceLoader<CodeGeneratorTool> toolServiceLoader = ServiceLoader.load(CodeGeneratorTool.class, this.toolClassLoader);
    private final Map<PackageManifest.Tool.Field, ToolContext> toolContextMap = new HashMap<PackageManifest.Tool.Field, ToolContext>();

    public RunBuildToolsTask(PrintStream out) {
        this.outStream = out;
        this.exitWhenFinish = true;
    }

    @Override
    public void execute(Project project) {
        BuildToolResolution buildToolResolution;
        project.setToolContextMap(this.toolContextMap);
        List<Diagnostic> toolManifestDiagnostics = project.currentPackage().manifest().diagnostics().diagnostics().stream().filter(diagnostic -> diagnostic.diagnosticInfo().code().startsWith("BCE53")).toList();
        toolManifestDiagnostics.forEach(this.outStream::println);
        ArrayList<Diagnostic> toolDiagnostics = new ArrayList<Diagnostic>(toolManifestDiagnostics);
        List toolEntries = project.currentPackage().manifest().tools();
        if (toolEntries.isEmpty()) {
            return;
        }
        this.outStream.println("\nExecuting Build Tools");
        for (PackageManifest.Tool toolEntry2 : toolEntries) {
            ToolContext toolContext = ToolContext.from((PackageManifest.Tool)toolEntry2, (Package)project.currentPackage(), (PrintStream)this.outStream);
            this.toolContextMap.put(toolEntry2.id(), toolContext);
        }
        try {
            buildToolResolution = project.currentPackage().getBuildToolResolution();
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.outStream, e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        buildToolResolution.getDiagnosticList().forEach(this.outStream::println);
        toolDiagnostics.addAll(buildToolResolution.getDiagnosticList());
        List resolvedTools = buildToolResolution.getResolvedTools();
        List<BuildTool> centralDeliveredResolvedTools = resolvedTools.stream().filter(tool -> !DEFAULT_VERSION.equals(tool.version().toString())).toList();
        if (!centralDeliveredResolvedTools.isEmpty()) {
            if (!project.buildOptions().offlineBuild()) {
                this.pullLocallyUnavailableTools(centralDeliveredResolvedTools, buildToolResolution);
            }
            this.toolClassLoader = this.createToolClassLoader(centralDeliveredResolvedTools);
            this.toolServiceLoader = ServiceLoader.load(CodeGeneratorTool.class, this.toolClassLoader);
        }
        List<PackageManifest.Tool> resolvedToolEntries = toolEntries.stream().filter(toolEntry -> resolvedTools.stream().anyMatch(tool -> tool.id().value().equals(toolEntry.type().value().split("\\.")[0]))).toList();
        for (PackageManifest.Tool toolEntry3 : resolvedToolEntries) {
            String commandName = toolEntry3.type().value();
            ToolContext toolContext = this.toolContextMap.get(toolEntry3.id());
            Optional targetTool = BuildToolUtils.getTargetTool((String)commandName, this.toolServiceLoader);
            if (targetTool.isEmpty()) {
                TomlDiagnostic diagnostic2 = BuildToolUtils.getBuildToolCommandNotFoundDiagnostic((String)commandName, (TomlNodeLocation)toolEntry3.type().location());
                toolContext.reportDiagnostic((Diagnostic)diagnostic2);
                this.outStream.println(diagnostic2);
                this.printToolSkipWarning(toolEntry3);
                continue;
            }
            Optional cmdNameDiagnostic = BuildToolUtils.getDiagnosticIfInvalidCommandName((String)commandName, (TomlNodeLocation)toolEntry3.id().location());
            if (cmdNameDiagnostic.isPresent()) {
                toolContext.reportDiagnostic((Diagnostic)cmdNameDiagnostic.get());
                this.outStream.println(cmdNameDiagnostic.get());
                this.printToolSkipWarning(toolEntry3);
                continue;
            }
            boolean hasOptionErrors = false;
            try {
                hasOptionErrors = this.validateOptionsToml(toolEntry3.optionsToml(), toolEntry3.type());
                if (hasOptionErrors) {
                    DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.TOOL_OPTIONS_VALIDATION_FAILED.diagnosticId(), ProjectDiagnosticErrorCode.TOOL_OPTIONS_VALIDATION_FAILED.messageKey(), DiagnosticSeverity.ERROR);
                    TomlNodeLocation location = toolEntry3.optionsToml() == null ? toolEntry3.type().location() : toolEntry3.optionsTable().location();
                    TomlDiagnostic diagnostic3 = new TomlDiagnostic(location, diagnosticInfo, toolEntry3.type().value());
                    toolContext.reportDiagnostic((Diagnostic)diagnostic3);
                }
            }
            catch (IOException e) {
                this.outStream.printf("WARNING: Validation of tool options of '%s' for '%s' is skipped due to: %s%n", commandName, toolEntry3.id().value(), e.getMessage());
            }
            if (toolEntry3.hasErrorDiagnostic() || hasOptionErrors) {
                this.printToolSkipWarning(toolEntry3);
                continue;
            }
            try {
                this.outStream.printf("\t%s(%s)%n", toolEntry3.type().value(), toolEntry3.id().value());
                ((CodeGeneratorTool)targetTool.get()).execute(toolContext);
                toolDiagnostics.addAll(toolContext.diagnostics());
                for (Diagnostic d2 : toolContext.diagnostics()) {
                    if (d2.toString().contains("(1:1,1:1)")) {
                        this.outStream.println(new PackageDiagnostic(d2.diagnosticInfo(), toolContext.toolId()));
                        continue;
                    }
                    this.outStream.println(new PackageDiagnostic(d2.diagnosticInfo(), d2.location()));
                }
            }
            catch (Exception e) {
                throw LauncherUtils.createLauncherException(e.getMessage());
            }
        }
        boolean hasErrors = toolDiagnostics.stream().anyMatch(d -> d.diagnosticInfo().severity().equals((Object)DiagnosticSeverity.ERROR));
        if (hasErrors) {
            throw LauncherUtils.createLauncherException("build tool execution contains errors");
        }
        this.reloadProject(project);
        this.outStream.println();
    }

    private boolean validateOptionsToml(Toml optionsToml, PackageManifest.Tool.Field toolType) throws IOException {
        if (optionsToml == null) {
            return this.validateEmptyOptionsToml(toolType);
        }
        FileUtils.validateToml(optionsToml, toolType.value(), this.toolClassLoader);
        optionsToml.diagnostics().forEach(this.outStream::println);
        return !Diagnostics.filterErrors((Collection)optionsToml.diagnostics()).isEmpty();
    }

    private boolean validateEmptyOptionsToml(PackageManifest.Tool.Field toolType) throws IOException {
        Schema schema = Schema.from((String)FileUtils.readSchema(toolType.value(), this.toolClassLoader));
        List requiredFields = schema.required();
        if (!requiredFields.isEmpty()) {
            for (String field : requiredFields) {
                String message = "missing required optional field '" + field + "'";
                DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.MISSING_TOOL_PROPERTIES_IN_BALLERINA_TOML.diagnosticId(), ProjectDiagnosticErrorCode.MISSING_TOOL_PROPERTIES_IN_BALLERINA_TOML.messageKey(), DiagnosticSeverity.ERROR);
                TomlDiagnostic diagnostic = new TomlDiagnostic(toolType.location(), diagnosticInfo, message);
                this.outStream.println(diagnostic);
            }
            return true;
        }
        return false;
    }

    private void pullLocallyUnavailableTools(List<BuildTool> tools, BuildToolResolution buildToolResolution) {
        for (BuildTool tool : tools) {
            TomlDiagnostic diagnostic;
            DiagnosticInfo diagnosticInfo;
            String message;
            String toolId = tool.id().value();
            String version = tool.version().toString();
            String org = tool.org().value();
            String name = tool.name().value();
            try {
                if (this.isToolLocallyAvailable(org, name, version)) continue;
                this.pullToolFromCentral(toolId, version);
            }
            catch (CentralClientException e) {
                message = "failed to pull build tool '" + toolId + ":" + version + "' from Ballerina Central: " + e.getMessage();
                diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.BUILD_TOOL_NOT_FOUND.diagnosticId(), ProjectDiagnosticErrorCode.BUILD_TOOL_NOT_FOUND.messageKey(), DiagnosticSeverity.ERROR);
                diagnostic = new TomlDiagnostic(tool.location(), diagnosticInfo, message);
                this.outStream.println(diagnostic);
                buildToolResolution.getDiagnosticList().add(diagnostic);
                tools.remove(tool);
            }
            catch (ProjectException e) {
                message = "failed to resolve build tool '" + toolId + ":" + version + "' from the local cache: " + e.getMessage();
                diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.BUILD_TOOL_NOT_FOUND.diagnosticId(), ProjectDiagnosticErrorCode.BUILD_TOOL_NOT_FOUND.messageKey(), DiagnosticSeverity.ERROR);
                diagnostic = new TomlDiagnostic(tool.location(), diagnosticInfo, message);
                this.outStream.println(diagnostic);
                buildToolResolution.getDiagnosticList().add(diagnostic);
                tools.remove(tool);
            }
        }
    }

    private boolean isToolLocallyAvailable(String org, String name, String version) {
        Path toolCacheDir = BuildToolUtils.getCentralBalaDirPath().resolve(org).resolve(name);
        if (toolCacheDir.toFile().isDirectory()) {
            boolean bl;
            block9: {
                Stream<Path> versions = Files.list(toolCacheDir);
                try {
                    bl = versions.anyMatch(path -> path != null && path.getFileName() != null && version != null && version.equals(path.getFileName().toString()));
                    if (versions == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (versions != null) {
                            try {
                                versions.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ProjectException("Error while looking for locally available tools: " + String.valueOf(e));
                    }
                }
                versions.close();
            }
            return bl;
        }
        return false;
    }

    private void pullToolFromCentral(String toolId, String version) throws CentralClientException {
        String supportedPlatform = Arrays.stream(JvmTarget.values()).map(JvmTarget::code).collect(Collectors.joining(","));
        Path balaCacheDirPath = BuildToolUtils.getCentralBalaDirPath();
        Settings settings = RepoUtils.readSettings();
        System.setProperty("enableOutputStream", Boolean.TRUE.toString());
        CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
        String[] toolInfo = client.pullTool(toolId, version, balaCacheDirPath, supportedPlatform, RepoUtils.getBallerinaVersion(), false);
        boolean isPulled = Boolean.parseBoolean(toolInfo[0]);
        if (isPulled) {
            this.outStream.println("tool '" + toolId + ":" + version + "' pulled successfully.");
        } else {
            this.outStream.println("tool '" + toolId + ":" + version + "' is already available locally.");
        }
    }

    private ClassLoader createToolClassLoader(List<BuildTool> resolvedTools) {
        List<File> toolJars = RunBuildToolsTask.getToolCommandJarAndDependencyJars(resolvedTools);
        URL[] urls = (URL[])toolJars.stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw LauncherUtils.createUsageExceptionWithHelp("invalid tool jar: " + file.getAbsolutePath());
            }
        }).toArray(URL[]::new);
        ClassLoader systemClassLoader = this.getClass().getClassLoader();
        return new URLClassLoader(urls, systemClassLoader);
    }

    private void printToolSkipWarning(PackageManifest.Tool toolEntry) {
        this.outStream.printf("WARNING: Execution of '%s:%s' is skipped due to errors%n", toolEntry.type().value(), toolEntry.id() != null ? toolEntry.id().value() : "");
    }

    private void reloadProject(Project project) {
        PackageConfig packageConfig = PackageConfigCreator.createBuildProjectConfig((Path)project.sourceRoot(), (boolean)project.buildOptions().disableSyntaxTree());
        project.addPackage(packageConfig);
    }

    private static List<File> getToolCommandJarAndDependencyJars(List<BuildTool> resolvedTools) {
        Path centralBalaDirPath = BuildToolUtils.getCentralBalaDirPath();
        return resolvedTools.stream().map(tool -> BalToolsUtil.findJarFiles(CommandUtil.getPlatformSpecificBalaPath(tool.org().value(), tool.name().value(), tool.version().toString(), centralBalaDirPath).resolve("tool").resolve("libs").toFile())).flatMap(Collection::stream).toList();
    }
}

