/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public class BallerinaInputStream
extends InputStream {
    public static final String BAL_STREAM_CLOSE = "close";
    public static final String STREAM_VALUE = "value";
    public static final String BAL_STREAM_NEXT = "next";
    public static final String ERROR_OCCURRED_WHILE_READING_THE_STREAM = "Error occurred while reading the next element from the stream";
    public static final String UNEXPECTED_TYPE_ERROR = "Error occurred while reading the next element from the stream: unexpected value type";
    private final Environment environment;
    private final BStream ballerinaStream;
    private ByteBuffer buffer = null;
    private boolean endOfStream = false;
    private final boolean hasCloseMethod;

    public BallerinaInputStream(Environment environment, BStream ballerinaStream) {
        this.ballerinaStream = ballerinaStream;
        this.environment = environment;
        Type iteratorType = ballerinaStream.getIteratorObj().getOriginalType();
        if (iteratorType instanceof ObjectType) {
            ObjectType iteratorObjectType = (ObjectType)iteratorType;
            MethodType[] methods = iteratorObjectType.getMethods();
            this.hasCloseMethod = Arrays.stream(methods).anyMatch(method -> method.getName().equals(BAL_STREAM_CLOSE));
        } else {
            this.hasCloseMethod = false;
        }
    }

    @Override
    public int read() throws IOException {
        boolean result;
        if (this.endOfStream) {
            return -1;
        }
        if (!(!Objects.isNull(this.buffer) && this.buffer.hasRemaining() || (result = this.pollNext()))) {
            this.endOfStream = true;
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public void close() throws IOException {
        if (!this.hasCloseMethod) {
            return;
        }
        Object result = this.callBalStreamMethod(BAL_STREAM_CLOSE);
        if (result instanceof BError) {
            BError bError = (BError)((Object)result);
            throw new IOException(bError.getMessage());
        }
    }

    public Object getNext() {
        return this.callBalStreamMethod(BAL_STREAM_NEXT);
    }

    private Object callBalStreamMethod(String functionName) {
        return this.environment.getRuntime().callMethod(this.ballerinaStream.getIteratorObj(), functionName, null, new Object[0]);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        boolean result;
        if (this.endOfStream) {
            return -1;
        }
        if (!(!Objects.isNull(this.buffer) && this.buffer.hasRemaining() || (result = this.pollNext()))) {
            this.endOfStream = true;
            return -1;
        }
        int remaining = this.buffer.remaining();
        int readLength = Math.min(remaining, len);
        this.buffer.get(b, off, readLength);
        return readLength;
    }

    private boolean pollNext() throws IOException {
        Object nextBytes;
        Object nextElement = this.getNext();
        if (nextElement instanceof BError) {
            BError bError = (BError)((Object)nextElement);
            throw new IllegalStateException(bError.getMessage());
        }
        if (Objects.isNull(nextElement)) {
            return false;
        }
        if (nextElement instanceof BMap) {
            BMap nextValue = (BMap)nextElement;
            nextBytes = nextValue.get((Object)StringUtils.fromString((String)STREAM_VALUE));
            if (!(nextBytes instanceof BArray)) {
                throw new IOException(UNEXPECTED_TYPE_ERROR);
            }
        } else {
            throw new IOException(UNEXPECTED_TYPE_ERROR);
        }
        BArray nextBytesArray = (BArray)nextBytes;
        this.buffer = ByteBuffer.wrap(nextBytesArray.getBytes());
        return true;
    }
}

