/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BObject;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;

public final class PgpDecryptionGenerator {
    private final char[] passCode;
    private final PGPSecretKeyRingCollection pgpSecretKeyRingCollection;

    public PgpDecryptionGenerator(InputStream privateKeyIn, byte[] passCode) throws IOException, PGPException {
        this.passCode = new String(passCode, StandardCharsets.UTF_8).toCharArray();
        this.pgpSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)privateKeyIn), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
    }

    private Optional<PGPPrivateKey> findSecretKey(long keyID) throws PGPException {
        Optional<PGPSecretKey> pgpSecretKey = Optional.ofNullable(this.pgpSecretKeyRingCollection.getSecretKey(keyID));
        if (pgpSecretKey.isPresent()) {
            PGPPrivateKey privateKey = pgpSecretKey.get().extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(this.passCode));
            return Optional.of(privateKey);
        }
        return Optional.empty();
    }

    private void decryptStream(InputStream encryptedIn, OutputStream clearOut) throws PGPException, IOException {
        KeyEncryptedResult keyEncryptedResult = this.getKeyEncryptedResult(encryptedIn);
        PgpDecryptionGenerator.decrypt(clearOut, keyEncryptedResult.pgpPrivateKey(), keyEncryptedResult.publicKeyEncryptedData());
    }

    private KeyEncryptedResult getKeyEncryptedResult(InputStream encryptedIn) throws IOException, PGPException {
        PGPEncryptedDataList pgpEncryptedData;
        JcaPGPObjectFactory pgpObjectFactory = new JcaPGPObjectFactory(encryptedIn = PGPUtil.getDecoderStream((InputStream)encryptedIn));
        Object obj = pgpObjectFactory.nextObject();
        PGPEncryptedDataList pgpEncryptedDataList = obj instanceof PGPEncryptedDataList ? (pgpEncryptedData = (PGPEncryptedDataList)obj) : (PGPEncryptedDataList)pgpObjectFactory.nextObject();
        Optional<Object> pgpPrivateKey = Optional.empty();
        PGPPublicKeyEncryptedData publicKeyEncryptedData = null;
        Iterator encryptedDataItr = pgpEncryptedDataList.getEncryptedDataObjects();
        while (pgpPrivateKey.isEmpty() && encryptedDataItr.hasNext()) {
            publicKeyEncryptedData = (PGPPublicKeyEncryptedData)encryptedDataItr.next();
            pgpPrivateKey = this.findSecretKey(publicKeyEncryptedData.getKeyID());
        }
        if (Objects.isNull(publicKeyEncryptedData)) {
            throw new PGPException("Could not generate PGPPublicKeyEncryptedData object");
        }
        if (pgpPrivateKey.isEmpty()) {
            throw new PGPException("Could not Extract private key");
        }
        return new KeyEncryptedResult((PGPPrivateKey)pgpPrivateKey.get(), publicKeyEncryptedData);
    }

    public void decryptStream(InputStream encryptedIn, BObject iteratorObj) throws PGPException, IOException {
        KeyEncryptedResult keyEncryptedResult = this.getKeyEncryptedResult(encryptedIn);
        PgpDecryptionGenerator.decrypt(keyEncryptedResult.pgpPrivateKey, keyEncryptedResult.publicKeyEncryptedData, iteratorObj);
    }

    public Object decrypt(byte[] encryptedBytes) throws PGPException, IOException {
        try (ByteArrayInputStream encryptedIn = new ByteArrayInputStream(encryptedBytes);){
            BArray bArray;
            try (ByteArrayOutputStream clearOut = new ByteArrayOutputStream();){
                this.decryptStream((InputStream)encryptedIn, clearOut);
                bArray = ValueCreator.createArrayValue((byte[])clearOut.toByteArray());
            }
            return bArray;
        }
    }

    private static void decrypt(OutputStream clearOut, PGPPrivateKey pgpPrivateKey, PGPPublicKeyEncryptedData publicKeyEncryptedData) throws IOException, PGPException {
        block21: {
            PublicKeyDataDecryptorFactory decryptorFactory = new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pgpPrivateKey);
            try (InputStream decryptedCompressedIn = publicKeyEncryptedData.getDataStream(decryptorFactory);){
                JcaPGPObjectFactory decCompObjFac = new JcaPGPObjectFactory(decryptedCompressedIn);
                PGPCompressedData pgpCompressedData = (PGPCompressedData)decCompObjFac.nextObject();
                try (BufferedInputStream compressedDataStream = new BufferedInputStream(pgpCompressedData.getDataStream());){
                    JcaPGPObjectFactory pgpCompObjFac = new JcaPGPObjectFactory((InputStream)compressedDataStream);
                    Object message = pgpCompObjFac.nextObject();
                    if (message instanceof PGPLiteralData) {
                        PGPLiteralData pgpLiteralData = (PGPLiteralData)message;
                        try (InputStream decDataStream = pgpLiteralData.getInputStream();){
                            int bytesRead;
                            byte[] buffer = new byte[1024];
                            while ((bytesRead = decDataStream.read(buffer)) != -1) {
                                clearOut.write(buffer, 0, bytesRead);
                            }
                            break block21;
                        }
                    }
                    if (message instanceof PGPOnePassSignatureList) {
                        throw new PGPException("Encrypted message contains a signed message not literal data");
                    }
                    throw new PGPException("Unknown message type encountered during decryption");
                }
            }
        }
        if (publicKeyEncryptedData.isIntegrityProtected() && !publicKeyEncryptedData.verify()) {
            throw new PGPException("Message failed integrity check");
        }
    }

    private static void decrypt(PGPPrivateKey pgpPrivateKey, PGPPublicKeyEncryptedData publicKeyEncryptedData, BObject iteratorObj) throws IOException, PGPException {
        PublicKeyDataDecryptorFactory decryptorFactory = new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pgpPrivateKey);
        InputStream decryptedCompressedIn = publicKeyEncryptedData.getDataStream(decryptorFactory);
        JcaPGPObjectFactory decCompObjFac = new JcaPGPObjectFactory(decryptedCompressedIn);
        PGPCompressedData pgpCompressedData = (PGPCompressedData)decCompObjFac.nextObject();
        BufferedInputStream compressedDataStream = new BufferedInputStream(pgpCompressedData.getDataStream());
        JcaPGPObjectFactory pgpCompObjFac = new JcaPGPObjectFactory((InputStream)compressedDataStream);
        Object message = pgpCompObjFac.nextObject();
        if (!(message instanceof PGPLiteralData)) {
            if (message instanceof PGPOnePassSignatureList) {
                throw new PGPException("Encrypted message contains a signed message not literal data");
            }
            throw new PGPException("Unknown message type encountered during decryption");
        }
        PGPLiteralData pgpLiteralData = (PGPLiteralData)message;
        iteratorObj.addNativeData("KEY_ENCRYPTED_DATA", (Object)publicKeyEncryptedData);
        iteratorObj.addNativeData("TARGET_STREAM", (Object)pgpLiteralData.getDataStream());
        iteratorObj.addNativeData("COMPRESSED_DATA_STREAM", (Object)compressedDataStream);
        iteratorObj.addNativeData("DATA_STREAM", (Object)decryptedCompressedIn);
    }

    static {
        if (Objects.isNull(Security.getProvider("BC"))) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    private record KeyEncryptedResult(PGPPrivateKey pgpPrivateKey, PGPPublicKeyEncryptedData publicKeyEncryptedData) {
    }
}

