/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto.nativeimpl;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.crypto.BallerinaInputStream;
import io.ballerina.stdlib.crypto.CryptoUtils;
import io.ballerina.stdlib.crypto.PgpEncryptionGenerator;
import io.ballerina.stdlib.crypto.nativeimpl.ModuleUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.openpgp.PGPException;

public class Encrypt {
    private static final BString COMPRESSION_ALGORITHM = StringUtils.fromString((String)"compressionAlgorithm");
    private static final BString SYMMETRIC_KEY_ALGORITHM = StringUtils.fromString((String)"symmetricKeyAlgorithm");
    private static final BString ARMOR = StringUtils.fromString((String)"armor");
    private static final BString WITH_INTEGRITY_CHECK = StringUtils.fromString((String)"withIntegrityCheck");
    public static final String ERROR_OCCURRED_WHILE_READING_PUBLIC_KEY = "Error occurred while reading public key: ";
    public static final String ERROR_OCCURRED_WHILE_PGP_ENCRYPT = "Error occurred while PGP encrypt: ";

    private Encrypt() {
    }

    public static Object encryptAesCbc(BArray inputValue, BArray keyValue, BArray ivValue, Object padding) {
        byte[] input = inputValue.getBytes();
        byte[] key = keyValue.getBytes();
        byte[] iv = null;
        if (ivValue != null) {
            iv = ivValue.getBytes();
        }
        return CryptoUtils.aesEncryptDecrypt(CryptoUtils.CipherMode.ENCRYPT, "CBC", padding.toString(), key, input, iv, -1L);
    }

    public static Object encryptAesEcb(BArray inputValue, BArray keyValue, Object padding) {
        byte[] input = inputValue.getBytes();
        byte[] key = keyValue.getBytes();
        return CryptoUtils.aesEncryptDecrypt(CryptoUtils.CipherMode.ENCRYPT, "ECB", padding.toString(), key, input, null, -1L);
    }

    public static Object encryptAesGcm(BArray inputValue, BArray keyValue, BArray ivValue, Object padding, long tagSize) {
        byte[] input = inputValue.getBytes();
        byte[] key = keyValue.getBytes();
        byte[] iv = null;
        if (ivValue != null) {
            iv = ivValue.getBytes();
        }
        return CryptoUtils.aesEncryptDecrypt(CryptoUtils.CipherMode.ENCRYPT, "GCM", padding.toString(), key, input, iv, tagSize);
    }

    public static Object encryptRsaEcb(BArray inputValue, Object keys, Object padding) {
        Key key;
        byte[] input = inputValue.getBytes();
        BMap keyMap = (BMap)keys;
        if (keyMap.getNativeData("NATIVE_DATA_PRIVATE_KEY") != null) {
            key = (PrivateKey)keyMap.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        } else if (keyMap.getNativeData("NATIVE_DATA_PUBLIC_KEY") != null) {
            key = (PublicKey)keyMap.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        } else {
            return CryptoUtils.createError("Uninitialized private/public key.");
        }
        return CryptoUtils.rsaEncryptDecrypt(CryptoUtils.CipherMode.ENCRYPT, "ECB", padding.toString(), key, input, null, -1L);
    }

    public static Object encryptPgp(BArray plainTextValue, BString publicKeyPath, BMap options) {
        Object object;
        byte[] publicKey;
        byte[] plainText = plainTextValue.getBytes();
        try {
            publicKey = Files.readAllBytes(Path.of(publicKeyPath.toString(), new String[0]));
        }
        catch (IOException e) {
            return CryptoUtils.createError(ERROR_OCCURRED_WHILE_READING_PUBLIC_KEY + e.getMessage());
        }
        ByteArrayInputStream publicKeyStream = new ByteArrayInputStream(publicKey);
        try {
            PgpEncryptionGenerator pgpEncryptionGenerator = new PgpEncryptionGenerator(Integer.parseInt(options.get((Object)COMPRESSION_ALGORITHM).toString()), Integer.parseInt(options.get((Object)SYMMETRIC_KEY_ALGORITHM).toString()), Boolean.parseBoolean(options.get((Object)ARMOR).toString()), Boolean.parseBoolean(options.get((Object)WITH_INTEGRITY_CHECK).toString()));
            object = pgpEncryptionGenerator.encrypt(plainText, publicKeyStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)publicKeyStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | PGPException e) {
                return CryptoUtils.createError(ERROR_OCCURRED_WHILE_PGP_ENCRYPT + e.getMessage());
            }
        }
        ((InputStream)publicKeyStream).close();
        return object;
    }

    public static Object encryptStreamAsPgp(Environment environment, BStream inputBalStream, BString publicKeyPath, BMap options) {
        BStream bStream;
        byte[] publicKey;
        try {
            publicKey = Files.readAllBytes(Path.of(publicKeyPath.toString(), new String[0]));
        }
        catch (IOException e) {
            return CryptoUtils.createError(ERROR_OCCURRED_WHILE_READING_PUBLIC_KEY + e.getMessage());
        }
        ByteArrayInputStream publicKeyStream = new ByteArrayInputStream(publicKey);
        try {
            BallerinaInputStream inputStream = new BallerinaInputStream(environment, inputBalStream);
            PgpEncryptionGenerator pgpEncryptionGenerator = new PgpEncryptionGenerator(Integer.parseInt(options.get((Object)COMPRESSION_ALGORITHM).toString()), Integer.parseInt(options.get((Object)SYMMETRIC_KEY_ALGORITHM).toString()), Boolean.parseBoolean(options.get((Object)ARMOR).toString()), Boolean.parseBoolean(options.get((Object)WITH_INTEGRITY_CHECK).toString()));
            BObject iteratorObj = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"EncryptedStreamIterator", (Object[])new Object[0]);
            iteratorObj.addNativeData("END_OF_INPUT_STREAM", (Object)false);
            iteratorObj.addNativeData("INPUT_STREAM_TO_ENCRYPT", (Object)inputStream);
            pgpEncryptionGenerator.encryptStream(publicKeyStream, iteratorObj);
            ArrayType constrainedType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_BYTE);
            bStream = ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)constrainedType), (BObject)iteratorObj);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)publicKeyStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | PGPException e) {
                return CryptoUtils.createError(ERROR_OCCURRED_WHILE_PGP_ENCRYPT + e.getMessage());
            }
        }
        ((InputStream)publicKeyStream).close();
        return bStream;
    }
}

