/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto.nativeimpl;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.crypto.CryptoUtils;
import io.ballerina.stdlib.crypto.PasswordUtils;
import org.bouncycastle.crypto.generators.BCrypt;
import org.bouncycastle.util.encoders.Base64;

public class Password {
    private Password() {
    }

    public static Object hashPassword(BString password, long workFactor) {
        try {
            Object validationError = PasswordUtils.validateWorkFactor(workFactor);
            if (validationError != null) {
                return validationError;
            }
            if (password.getValue().length() == 0) {
                return CryptoUtils.createError("Password cannot be empty");
            }
            byte[] salt = PasswordUtils.generateRandomSalt();
            byte[] passwordBytes = BCrypt.passwordToByteArray((char[])password.getValue().toCharArray());
            byte[] hash = BCrypt.generate((byte[])passwordBytes, (byte[])salt, (int)((int)workFactor));
            return StringUtils.fromString((String)PasswordUtils.formatBCryptHash(workFactor, PasswordUtils.combine(salt, hash)));
        }
        catch (Exception e) {
            return CryptoUtils.createError("Error occurred while hashing password: " + e.getMessage());
        }
    }

    public static Object hashPassword(BString password) {
        return Password.hashPassword(password, 12L);
    }

    public static Object verifyPassword(BString password, BString hashedPassword) {
        try {
            String hash = hashedPassword.getValue();
            if (!hash.startsWith("$2a$")) {
                return CryptoUtils.createError("Invalid hash format");
            }
            int workFactor = Integer.parseInt(hash.substring(4, 6));
            String saltAndHashBase64 = hash.substring(7);
            byte[] saltAndHash = Base64.decode((String)saltAndHashBase64);
            byte[] salt = new byte[16];
            System.arraycopy(saltAndHash, 0, salt, 0, 16);
            byte[] passwordBytes = BCrypt.passwordToByteArray((char[])password.getValue().toCharArray());
            byte[] newHash = BCrypt.generate((byte[])passwordBytes, (byte[])salt, (int)workFactor);
            byte[] originalHash = new byte[saltAndHash.length - 16];
            System.arraycopy(saltAndHash, 16, originalHash, 0, originalHash.length);
            return PasswordUtils.constantTimeArrayEquals(newHash, originalHash);
        }
        catch (Exception e) {
            return CryptoUtils.createError("Error occurred while verifying password: " + e.getMessage());
        }
    }

    public static Object generateSalt(long workFactor) {
        try {
            Object validationError = PasswordUtils.validateWorkFactor(workFactor);
            if (validationError != null) {
                return validationError;
            }
            byte[] salt = PasswordUtils.generateRandomSalt();
            return StringUtils.fromString((String)PasswordUtils.formatBCryptHash(workFactor, salt));
        }
        catch (Exception e) {
            return CryptoUtils.createError("Error occurred while generating salt: " + e.getMessage());
        }
    }

    public static Object generateSalt() {
        return Password.generateSalt(12L);
    }
}

