/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.launcher.LauncherUtils;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import org.ballerinalang.langserver.launchers.stdio.Main;
import picocli.CommandLine;

@CommandLine.Command(name="language-server-spec", description={"Generate specifications for the LS APIs"})
public class LangServerSpecCmd
implements BLauncherCmd {
    private static final String CMD_NAME = "language-server-spec";
    private static final String FILE_NAME = "language-server-spec.json";
    private static final String BALLERINA_HOME = System.getProperty("ballerina.home");
    private final PrintStream outputStream = System.out;
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;

    public void execute() {
        try {
            System.setProperty("ballerina.home", BALLERINA_HOME);
            List output = Main.generateApiDoc();
            String jsonString = output.toString();
            Files.writeString(Paths.get(FILE_NAME, new String[0]), (CharSequence)jsonString, new OpenOption[0]);
            this.outputStream.println("LS API specifications are successfully dumped to language-server-spec.json");
        }
        catch (Throwable e) {
            throw LauncherUtils.createLauncherException((String)"Could not generate LS API specifications");
        }
    }

    public String getName() {
        return CMD_NAME;
    }

    public void printLongDesc(StringBuilder out) {
    }

    public void printUsage(StringBuilder out) {
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

