/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.observe.observers;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.observability.BallerinaObserver;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.runtime.observability.metrics.Tag;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BallerinaMetricsLogsObserver
implements BallerinaObserver {
    private static final String ORG_NAME = "ballerinax";
    private static final String MODULE_NAME = "metrics.logs";
    private static final String METRIC_LOG_FUNCTION_NAME = "printMetricsLog";
    private static final String PROPERTY_START_TIME = "_observation_start_time_";
    private static final PrintStream consoleError = System.err;
    private static Environment environment;

    public BallerinaMetricsLogsObserver(Environment environment) {
        BallerinaMetricsLogsObserver.environment = environment;
    }

    public void startServerObservation(ObserverContext observerContext) {
        this.startObservation(observerContext);
    }

    public void startClientObservation(ObserverContext observerContext) {
        this.startObservation(observerContext);
    }

    public void stopServerObservation(ObserverContext observerContext) {
        if (!observerContext.isStarted()) {
            return;
        }
        this.stopObservation(observerContext);
    }

    public void stopClientObservation(ObserverContext observerContext) {
        if (!observerContext.isStarted()) {
            return;
        }
        this.stopObservation(observerContext);
    }

    private void startObservation(ObserverContext observerContext) {
        if (observerContext.getProperty(PROPERTY_START_TIME) == null) {
            observerContext.addProperty(PROPERTY_START_TIME, (Object)System.nanoTime());
        }
    }

    private void stopObservation(ObserverContext observerContext) {
        HashSet<Tag> tags = new HashSet<Tag>();
        Map customTags = observerContext.customMetricTags;
        if (customTags != null) {
            tags.addAll(customTags.values());
        }
        tags.addAll(observerContext.getAllTags());
        Integer statusCode = (Integer)observerContext.getProperty("_http_status_code_");
        if (statusCode != null && statusCode > 0) {
            tags.add(Tag.of((String)"http.status_code_group", (String)(statusCode / 100 + "xx")));
        }
        try {
            Long startTime = (Long)observerContext.getProperty(PROPERTY_START_TIME);
            long duration = System.nanoTime() - startTime;
            Optional<String> protocolValue = Optional.empty();
            if (tags.stream().anyMatch(tag -> tag.getKey().equals("protocol"))) {
                protocolValue = tags.stream().filter(tag -> tag.getKey().equals("protocol")).map(Tag::getValue).findFirst();
            }
            String protocol = protocolValue.orElse("http");
            BMap logAttributes = ValueCreator.createMapValue();
            logAttributes.put((Object)StringUtils.fromString((String)"protocol"), (Object)StringUtils.fromString((String)protocol));
            tags.stream().filter(tag -> !tag.getKey().equals("protocol")).forEach(tag -> logAttributes.put((Object)StringUtils.fromString((String)tag.getKey()), (Object)StringUtils.fromString((String)tag.getValue())));
            logAttributes.put((Object)StringUtils.fromString((String)"response_time_seconds"), (Object)StringUtils.fromString((String)String.valueOf((double)duration / 1.0E9)));
            BallerinaMetricsLogsObserver.printMetricLog((BMap<BString, Object>)logAttributes);
        }
        catch (RuntimeException e) {
            this.handleError("multiple metrics", tags, e);
        }
    }

    private void handleError(String metricName, Set<Tag> tags, RuntimeException e) {
        consoleError.println("error: error collecting metric logs for " + metricName + " with tags " + String.valueOf(tags) + ": " + e.getMessage());
    }

    private static void printMetricLog(BMap<BString, Object> logAttributes) {
        Module metricsLogsModule = new Module(ORG_NAME, MODULE_NAME, "1");
        environment.getRuntime().callFunction(metricsLogsModule, METRIC_LOG_FUNCTION_NAME, null, new Object[]{logAttributes});
    }
}

