/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassFieldSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.flowmodelgenerator.core.CodeAnalyzer;
import io.ballerina.flowmodelgenerator.core.model.Diagram;
import io.ballerina.flowmodelgenerator.core.model.FlowNode;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.eclipse.lsp4j.Position;

public class ModelGenerator {
    private final SemanticModel semanticModel;
    private final Path filePath;
    private final Gson gson;
    private final Project project;

    public ModelGenerator(Project project, SemanticModel model, Path filePath) {
        this.semanticModel = model;
        this.filePath = filePath;
        this.project = project;
        this.gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    public JsonElement getFlowModel(Document document, LineRange lineRange, Document dataMappingDoc) {
        SyntaxTree syntaxTree = document.syntaxTree();
        ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
        TextDocument textDocument = syntaxTree.textDocument();
        int start = textDocument.textPositionFrom(lineRange.startLine());
        int end = textDocument.textPositionFrom(lineRange.endLine());
        NonTerminalNode canvasNode = modulePartNode.findNode(TextRange.from((int)start, (int)(end - start)), true);
        List<FlowNode> moduleConnections = this.semanticModel.visibleSymbols(document, canvasNode.lineRange().startLine()).stream().flatMap(symbol -> this.buildConnection((Symbol)symbol).stream()).sorted(Comparator.comparing(node -> Optional.ofNullable(node.properties().get("variable")).map(property -> property.value().toString()).orElse(""))).toList();
        HashMap<String, LineRange> dataMappings = new HashMap<String, LineRange>();
        if (dataMappingDoc != null) {
            ModulePartNode dataMappingModulePartNode = (ModulePartNode)dataMappingDoc.syntaxTree().rootNode();
            for (ModuleMemberDeclarationNode member : dataMappingModulePartNode.members()) {
                if (member.kind() != SyntaxKind.FUNCTION_DEFINITION) continue;
                FunctionDefinitionNode functionNode = (FunctionDefinitionNode)member;
                String functionName = functionNode.functionName().text();
                LineRange functionLineRange = functionNode.lineRange();
                dataMappings.put(functionName, functionLineRange);
            }
        }
        CodeAnalyzer codeAnalyzer = new CodeAnalyzer(this.project, this.semanticModel, "Local", dataMappings, textDocument, ModuleInfo.from((ModuleDescriptor)document.module().descriptor()), true);
        canvasNode.accept((NodeVisitor)codeAnalyzer);
        Diagram diagram = new Diagram(this.filePath.toString(), codeAnalyzer.getFlowNodes(), moduleConnections);
        return this.gson.toJsonTree((Object)diagram);
    }

    public JsonElement getModuleNodes() {
        List<FlowNode> connectionsList = this.semanticModel.moduleSymbols().stream().flatMap(symbol -> this.buildConnection((Symbol)symbol).stream()).sorted(Comparator.comparing(node -> Optional.ofNullable(node.properties().get("variable")).map(property -> property.value().toString()).orElse(""))).toList();
        Diagram diagram = new Diagram(this.filePath.toString(), List.of(), connectionsList);
        return this.gson.toJsonTree((Object)diagram);
    }

    public JsonElement getServiceFieldNodes(LinePosition pos) {
        for (Symbol symbol : this.semanticModel.moduleSymbols()) {
            if (symbol.kind() != SymbolKind.SERVICE_DECLARATION) continue;
            ServiceDeclarationSymbol serviceDeclarationSymbol = (ServiceDeclarationSymbol)symbol;
            if (!PositionUtil.isWithinLineRange((Position)new Position(pos.line(), pos.offset()), (LineRange)((Location)serviceDeclarationSymbol.getLocation().orElseThrow()).lineRange())) continue;
            Map fieldsMap = serviceDeclarationSymbol.fieldDescriptors();
            HashSet<CallSite> classFieldRefs = new HashSet<CallSite>();
            for (Map.Entry field : fieldsMap.entrySet()) {
                if (!this.isClassOrObject(CommonUtils.getRawType((TypeSymbol)((ClassFieldSymbol)field.getValue()).typeDescriptor()))) continue;
                classFieldRefs.add((CallSite)((Object)("self." + (String)field.getKey())));
            }
            Optional optLocation = serviceDeclarationSymbol.getLocation();
            if (optLocation.isEmpty()) continue;
            Location location = (Location)optLocation.get();
            DocumentId documentId = this.project.documentId(this.project.kind() == ProjectKind.SINGLE_FILE_PROJECT ? this.project.sourceRoot() : this.project.sourceRoot().resolve(location.lineRange().fileName()));
            Document document = this.project.currentPackage().getDefaultModule().document(documentId);
            NonTerminalNode node = CommonUtils.getNode((SyntaxTree)document.syntaxTree(), (TextRange)location.textRange());
            if (node.kind() != SyntaxKind.SERVICE_DECLARATION) continue;
            ArrayList<FlowNode> connections = new ArrayList<FlowNode>();
            ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)node;
            for (Node member : serviceDeclarationNode.members()) {
                FunctionDefinitionNode functionDefinitionNode;
                if (member.kind() != SyntaxKind.OBJECT_METHOD_DEFINITION || !(functionDefinitionNode = (FunctionDefinitionNode)member).functionName().text().equals("init")) continue;
                for (StatementNode statement : ((FunctionBodyBlockNode)functionDefinitionNode.functionBody()).statements()) {
                    if (statement.kind() != SyntaxKind.ASSIGNMENT_STATEMENT || !classFieldRefs.contains(((AssignmentStatementNode)statement).varRef().toSourceCode().trim())) continue;
                    CodeAnalyzer codeAnalyzer = new CodeAnalyzer(this.project, this.semanticModel, "Service", Map.of(), document.textDocument(), ModuleInfo.from((ModuleDescriptor)document.module().descriptor()), false);
                    statement.accept((NodeVisitor)codeAnalyzer);
                    List<FlowNode> nodes = codeAnalyzer.getFlowNodes();
                    connections.add((FlowNode)nodes.stream().findFirst().orElseThrow());
                }
            }
            Diagram diagram = new Diagram(this.filePath.toString(), List.of(), connections);
            return this.gson.toJsonTree((Object)diagram);
        }
        return null;
    }

    private Optional<FlowNode> buildConnection(Symbol symbol) {
        NonTerminalNode statementNode;
        Document document;
        String scope;
        TypeSymbol typeSymbol;
        Function<NonTerminalNode, NonTerminalNode> getStatementNode;
        switch (symbol.kind()) {
            case VARIABLE: {
                getStatementNode = node -> node.parent().parent();
                typeSymbol = ((VariableSymbol)symbol).typeDescriptor();
                scope = "Global";
                break;
            }
            case CLASS_FIELD: {
                getStatementNode = node -> node;
                typeSymbol = ((ClassFieldSymbol)symbol).typeDescriptor();
                scope = "Service";
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        try {
            TypeSymbol typeDescriptorSymbol = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor();
            if (!this.isClassOrObject(typeDescriptorSymbol)) {
                return Optional.empty();
            }
            Location location = (Location)symbol.getLocation().orElseThrow();
            DocumentId documentId = this.project.documentId(this.project.kind() == ProjectKind.SINGLE_FILE_PROJECT ? this.project.sourceRoot() : this.project.sourceRoot().resolve(location.lineRange().fileName()));
            document = this.project.currentPackage().getDefaultModule().document(documentId);
            NonTerminalNode childNode = symbol.getLocation().map(loc -> CommonUtils.getNode((SyntaxTree)document.syntaxTree(), (TextRange)loc.textRange())).orElseThrow();
            statementNode = getStatementNode.apply(childNode);
        }
        catch (RuntimeException ignored) {
            return Optional.empty();
        }
        if (statementNode == null) {
            return Optional.empty();
        }
        CodeAnalyzer codeAnalyzer = new CodeAnalyzer(this.project, this.semanticModel, scope, Map.of(), document.textDocument(), ModuleInfo.from((ModuleDescriptor)document.module().descriptor()), false);
        statementNode.accept((NodeVisitor)codeAnalyzer);
        List<FlowNode> connections = codeAnalyzer.getFlowNodes();
        return connections.stream().findFirst();
    }

    private boolean isClassOrObject(TypeSymbol typeSymbol) {
        if (typeSymbol.kind() == SymbolKind.CLASS && ((ClassSymbol)typeSymbol).qualifiers().contains(Qualifier.CLIENT)) {
            return true;
        }
        if (typeSymbol.typeKind() == TypeDescKind.OBJECT) {
            return ((ObjectTypeSymbol)typeSymbol).qualifiers().contains(Qualifier.CLIENT);
        }
        return false;
    }
}

