/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.projects.Document;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.common.utils.PositionUtil;

public class SuggestedModelGenerator {
    private final List<LineRange> errorLocations;
    private boolean foundError = false;
    private int errorIndex = 0;
    private final Gson gson;
    private final LineRange newLineRange;
    private boolean hasSuggestedNodes = false;

    public SuggestedModelGenerator(Document document, LineRange newLineRange, SemanticModel semanticModel) {
        this.newLineRange = newLineRange;
        this.gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        this.errorLocations = new ArrayList<LineRange>();
        document.syntaxTree().diagnostics().forEach(diagnostic -> this.errorLocations.add(diagnostic.location().lineRange()));
        semanticModel.diagnostics().stream().filter(diagnostic -> diagnostic.diagnosticInfo().severity() == DiagnosticSeverity.ERROR).forEach(diagnostic -> this.errorLocations.add(diagnostic.location().lineRange()));
    }

    public void markSuggestedNodes(JsonArray newNodes, int startIndex) {
        for (int i = startIndex; i < newNodes.size(); ++i) {
            JsonObject newBranch;
            int j;
            JsonArray newBranches;
            JsonObject newNode = newNodes.get(i).getAsJsonObject();
            LineRange lineRange = this.getLineRange(newNode);
            if (PositionUtil.isWithinLineRange((LineRange)lineRange, (LineRange)this.newLineRange)) {
                if (newNode.has("branches")) {
                    newBranches = newNode.getAsJsonArray("branches");
                    for (j = 0; j < newBranches.size(); ++j) {
                        newBranch = newBranches.get(j).getAsJsonObject();
                        if (PositionUtil.isWithinLineRange((LineRange)this.getLineRange(newBranch), (LineRange)this.newLineRange)) {
                            this.markSuggestedNodes(newBranch.getAsJsonArray("children"), 0);
                            continue;
                        }
                        this.setSuggestedNodes(newBranch);
                    }
                    this.setSuggestedNodes(newNode);
                    continue;
                }
                i = this.handleSuggestedNode(newNodes, i, newNode);
                continue;
            }
            if (PositionUtil.isWithinLineRange((LineRange)this.newLineRange, (LineRange)lineRange)) {
                if (newNode.has("branches")) {
                    newBranches = newNode.getAsJsonArray("branches");
                    for (j = 0; j < newBranches.size(); ++j) {
                        newBranch = newBranches.get(j).getAsJsonObject();
                        if (PositionUtil.isWithinLineRange((LineRange)this.newLineRange, (LineRange)this.getLineRange(newBranch))) {
                            this.markSuggestedNodes(newBranch.getAsJsonArray("children"), 0);
                            continue;
                        }
                        newBranch.addProperty("suggested", Boolean.valueOf(false));
                    }
                    continue;
                }
                i = this.handleSuggestedNode(newNodes, i, newNode);
                continue;
            }
            newNode.addProperty("suggested", Boolean.valueOf(false));
        }
    }

    private int handleSuggestedNode(JsonArray newNodes, int newIndex, JsonObject newNode) {
        if (this.errorLocations.isEmpty() || !this.foundError && !this.isErrorInNode(newNode) && !this.isCustomExpression(newNode)) {
            this.setSuggestedNodes(newNode);
            return newIndex;
        }
        newNodes.remove(newIndex);
        if (!this.foundError) {
            this.foundError = true;
            ++this.errorIndex;
        }
        return newIndex - 1;
    }

    private void setSuggestedNodes(JsonObject newNode) {
        newNode.addProperty("suggested", Boolean.valueOf(true));
        this.hasSuggestedNodes = true;
    }

    private boolean isErrorInNode(JsonObject newNode) {
        LineRange lineRange = (LineRange)this.gson.fromJson(newNode.get("codedata").getAsJsonObject().get("lineRange"), LineRange.class);
        return PositionUtil.isWithinLineRange((LineRange)this.errorLocations.get(this.errorIndex), (LineRange)lineRange);
    }

    private boolean isCustomExpression(JsonObject newNode) {
        return newNode != null && newNode.has("codedata") && newNode.get("codedata").isJsonObject() && newNode.get("codedata").getAsJsonObject().has("node") && NodeKind.EXPRESSION.name().equals(newNode.get("codedata").getAsJsonObject().get("node").getAsString());
    }

    private static String getSourceText(JsonObject oldNode) {
        return oldNode.getAsJsonObject("codedata").get("sourceCode").getAsString();
    }

    private LineRange getLineRange(JsonObject jsonObject) {
        return (LineRange)this.gson.fromJson(jsonObject.get("codedata").getAsJsonObject().get("lineRange"), LineRange.class);
    }

    @Deprecated
    public void markSuggestedNodes(JsonArray oldNodes, JsonArray newNodes, int startIndex) {
        int oldIndex = startIndex;
        int newIndex = startIndex;
        while (oldIndex < oldNodes.size() && newIndex < newNodes.size()) {
            JsonObject oldNode = oldNodes.get(oldIndex).getAsJsonObject();
            JsonObject newNode = newNodes.get(newIndex).getAsJsonObject();
            if (SuggestedModelGenerator.getSourceText(oldNode).equals(SuggestedModelGenerator.getSourceText(newNode))) {
                newNode.addProperty("suggested", Boolean.valueOf(false));
                ++oldIndex;
                ++newIndex;
                continue;
            }
            boolean oldNodeHasBranches = oldNode.has("branches");
            boolean newNodeHasBranches = newNode.has("branches");
            if (oldNodeHasBranches && newNodeHasBranches) {
                this.markBranches(oldNode.getAsJsonArray("branches"), newNode.getAsJsonArray("branches"));
                ++oldIndex;
                ++newIndex;
                continue;
            }
            this.handleSuggestedNode(newNodes, newIndex, newNode);
            ++newIndex;
        }
        while (newIndex < newNodes.size()) {
            this.handleSuggestedNode(newNodes, newIndex, newNodes.get(newIndex).getAsJsonObject());
            ++newIndex;
        }
    }

    private void markBranches(JsonArray oldBranches, JsonArray newBranches) {
        for (int i = 0; i < newBranches.size(); ++i) {
            JsonObject newBranch = newBranches.get(i).getAsJsonObject();
            String newLabel = newBranch.get("label").getAsString();
            boolean labelMatched = false;
            for (int j = 0; j < oldBranches.size(); ++j) {
                JsonObject oldBranch = oldBranches.get(j).getAsJsonObject();
                if (!oldBranch.get("label").getAsString().equals(newLabel)) continue;
                this.markSuggestedNodes(oldBranch.getAsJsonArray("children"), newBranch.getAsJsonArray("children"), 0);
                labelMatched = true;
                break;
            }
            if (labelMatched) continue;
            newBranch.addProperty("suggested", Boolean.valueOf(true));
        }
    }

    public boolean hasSuggestedNodes() {
        return this.hasSuggestedNodes;
    }
}

