/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.converters.utils;

import com.google.gson.JsonPrimitive;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParenthesisedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxInfo;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.flowmodelgenerator.core.converters.utils.Utils;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.projects.Package;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.SingleFileProject;
import io.ballerina.projects.util.ProjectUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.math.NumberUtils;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;

public final class JsonToRecordMapperConverterUtils {
    private static final String ARRAY_RECORD_SUFFIX = "Item";
    private static final String QUOTED_IDENTIFIER_PREFIX = "'";
    private static final String ESCAPE_NUMERIC_PATTERN = "\\b\\d.*";
    private static final List<String> KEYWORDS = SyntaxInfo.keywords();

    private JsonToRecordMapperConverterUtils() {
    }

    public static String escapeIdentifier(String identifier) {
        if (KEYWORDS.stream().anyMatch(((String)identifier)::equals)) {
            return QUOTED_IDENTIFIER_PREFIX + (String)identifier;
        }
        if (((String)identifier).startsWith(QUOTED_IDENTIFIER_PREFIX)) {
            identifier = ((String)identifier).substring(1);
        }
        identifier = Utils.unescapeUnicodeCodepoints((String)identifier);
        if (((String)(identifier = Utils.escapeSpecialCharacters((String)identifier))).matches(ESCAPE_NUMERIC_PATTERN)) {
            identifier = "\\" + (String)identifier;
        }
        return identifier;
    }

    public static List<String> getExistingTypeNames(WorkspaceManager workspaceManager, Path filePath) {
        ArrayList<String> existingTypeNames = new ArrayList<String>();
        if (filePath == null) {
            return existingTypeNames;
        }
        if (workspaceManager != null && workspaceManager.semanticModel(filePath).isPresent()) {
            List moduleSymbols = ((SemanticModel)workspaceManager.semanticModel(filePath).get()).moduleSymbols();
            moduleSymbols.forEach(symbol -> {
                if (symbol.getName().isPresent()) {
                    existingTypeNames.add((String)symbol.getName().get());
                }
            });
            return existingTypeNames;
        }
        try {
            Path projectRoot = ProjectUtils.findProjectRoot((Path)filePath);
            if (projectRoot == null) {
                SingleFileProject project = SingleFileProject.load((Path)filePath);
                Package currentPackage = project.currentPackage();
                List moduleSymbols = PackageUtil.getCompilation((Package)currentPackage).getSemanticModel(currentPackage.getDefaultModule().moduleId()).moduleSymbols();
                moduleSymbols.forEach(symbol -> {
                    if (symbol.getName().isPresent()) {
                        existingTypeNames.add((String)symbol.getName().get());
                    }
                });
            } else {
                BuildProject project = BuildProject.load((Path)projectRoot);
                Package currentPackage = project.currentPackage();
                List moduleSymbols = PackageUtil.getCompilation((Package)currentPackage).getSemanticModel(currentPackage.getDefaultModule().moduleId()).moduleSymbols();
                moduleSymbols.forEach(symbol -> {
                    if (symbol.getName().isPresent()) {
                        existingTypeNames.add((String)symbol.getName().get());
                    }
                });
            }
        }
        catch (ProjectException pe) {
            return existingTypeNames;
        }
        return existingTypeNames;
    }

    public static String getAndUpdateFieldNames(String fieldName, boolean isArrayField, List<String> existingFieldNames, Map<String, String> updatedFieldNames) {
        String updatedFieldName = JsonToRecordMapperConverterUtils.getUpdatedFieldName(fieldName, isArrayField, existingFieldNames, updatedFieldNames);
        if (!fieldName.equals(updatedFieldName)) {
            updatedFieldNames.put(fieldName, updatedFieldName);
            return updatedFieldName;
        }
        return fieldName;
    }

    public static Token getPrimitiveTypeName(JsonPrimitive value) {
        if (value.isString()) {
            return AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD);
        }
        if (value.isBoolean()) {
            return AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.BOOLEAN_KEYWORD);
        }
        if (value.isNumber()) {
            String strValue = value.getAsNumber().toString();
            if (strValue.contains(".")) {
                return AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DECIMAL_KEYWORD);
            }
            return AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.INT_KEYWORD);
        }
        return AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ANYDATA_KEYWORD);
    }

    public static List<TypeDescriptorNode> extractTypeDescriptorNodes(List<TypeDescriptorNode> typeDescNodes) {
        ArrayList<TypeDescriptorNode> extractedTypeNames = new ArrayList<TypeDescriptorNode>();
        for (TypeDescriptorNode typeDescNode : typeDescNodes) {
            TypeDescriptorNode extractedTypeDescNode = JsonToRecordMapperConverterUtils.extractParenthesisedTypeDescNode(typeDescNode);
            if (extractedTypeDescNode instanceof UnionTypeDescriptorNode) {
                UnionTypeDescriptorNode unionTypeDescriptorNode = (UnionTypeDescriptorNode)extractedTypeDescNode;
                List<TypeDescriptorNode> childTypeDescNodes = List.of(unionTypeDescriptorNode.leftTypeDesc(), unionTypeDescriptorNode.rightTypeDesc());
                JsonToRecordMapperConverterUtils.addIfNotExist(extractedTypeNames, JsonToRecordMapperConverterUtils.extractTypeDescriptorNodes(childTypeDescNodes));
                continue;
            }
            JsonToRecordMapperConverterUtils.addIfNotExist(extractedTypeNames, List.of(extractedTypeDescNode));
        }
        return extractedTypeNames;
    }

    public static List<TypeDescriptorNode> sortTypeDescriptorNodes(List<TypeDescriptorNode> typeDescriptorNodes) {
        Stream<TypeDescriptorNode> nonArrayNodes = typeDescriptorNodes.stream().filter(node -> !(node instanceof ArrayTypeDescriptorNode)).sorted(Comparator.comparing(Node::toSourceCode));
        Stream<TypeDescriptorNode> arrayNodes = typeDescriptorNodes.stream().filter(node -> node instanceof ArrayTypeDescriptorNode).sorted((node1, node2) -> {
            ArrayTypeDescriptorNode arrayNode1 = (ArrayTypeDescriptorNode)node1;
            ArrayTypeDescriptorNode arrayNode2 = (ArrayTypeDescriptorNode)node2;
            return JsonToRecordMapperConverterUtils.getNumberOfDimensions(arrayNode1).equals(JsonToRecordMapperConverterUtils.getNumberOfDimensions(arrayNode2)) ? arrayNode1.memberTypeDesc().toSourceCode().compareTo(arrayNode2.memberTypeDesc().toSourceCode()) : JsonToRecordMapperConverterUtils.getNumberOfDimensions(arrayNode1) - JsonToRecordMapperConverterUtils.getNumberOfDimensions(arrayNode2);
        });
        return Stream.concat(nonArrayNodes, arrayNodes).toList();
    }

    public static TypeDescriptorNode extractArrayTypeDescNode(TypeDescriptorNode typeDescNode) {
        if (typeDescNode.kind().equals((Object)SyntaxKind.ARRAY_TYPE_DESC)) {
            ArrayTypeDescriptorNode arrayTypeDescNode = (ArrayTypeDescriptorNode)typeDescNode;
            return JsonToRecordMapperConverterUtils.extractArrayTypeDescNode(arrayTypeDescNode.memberTypeDesc());
        }
        return typeDescNode;
    }

    public static List<TypeDescriptorNode> extractUnionTypeDescNode(TypeDescriptorNode typeDescNode) {
        ArrayList<TypeDescriptorNode> extractedTypeDescNodes = new ArrayList<TypeDescriptorNode>();
        TypeDescriptorNode extractedTypeDescNode = typeDescNode;
        if (typeDescNode.kind().equals((Object)SyntaxKind.PARENTHESISED_TYPE_DESC)) {
            extractedTypeDescNode = JsonToRecordMapperConverterUtils.extractParenthesisedTypeDescNode(typeDescNode);
        }
        if (extractedTypeDescNode.kind().equals((Object)SyntaxKind.UNION_TYPE_DESC)) {
            UnionTypeDescriptorNode unionTypeDescNode = (UnionTypeDescriptorNode)extractedTypeDescNode;
            TypeDescriptorNode leftTypeDescNode = unionTypeDescNode.leftTypeDesc();
            TypeDescriptorNode rightTypeDescNode = unionTypeDescNode.rightTypeDesc();
            extractedTypeDescNodes.addAll(JsonToRecordMapperConverterUtils.extractUnionTypeDescNode(leftTypeDescNode));
            extractedTypeDescNodes.addAll(JsonToRecordMapperConverterUtils.extractUnionTypeDescNode(rightTypeDescNode));
        } else {
            extractedTypeDescNodes.add(extractedTypeDescNode);
        }
        return extractedTypeDescNodes;
    }

    public static Integer getNumberOfDimensions(ArrayTypeDescriptorNode arrayNode) {
        int totalDimensions = arrayNode.dimensions().size();
        TypeDescriptorNode typeDescriptorNode = arrayNode.memberTypeDesc();
        if (typeDescriptorNode instanceof ArrayTypeDescriptorNode) {
            ArrayTypeDescriptorNode arrayTypeDescriptorNode = (ArrayTypeDescriptorNode)typeDescriptorNode;
            totalDimensions += JsonToRecordMapperConverterUtils.getNumberOfDimensions(arrayTypeDescriptorNode).intValue();
        }
        return totalDimensions;
    }

    private static TypeDescriptorNode extractParenthesisedTypeDescNode(TypeDescriptorNode typeDescNode) {
        if (typeDescNode instanceof ParenthesisedTypeDescriptorNode) {
            ParenthesisedTypeDescriptorNode parenthesisedTypeDescriptorNode = (ParenthesisedTypeDescriptorNode)typeDescNode;
            return JsonToRecordMapperConverterUtils.extractParenthesisedTypeDescNode(parenthesisedTypeDescriptorNode.typedesc());
        }
        return typeDescNode;
    }

    private static void addIfNotExist(List<TypeDescriptorNode> typeDescNodes, List<TypeDescriptorNode> typeDescNodesToBeInserted) {
        for (TypeDescriptorNode typeDescNodeToBeInserted : typeDescNodesToBeInserted) {
            if (!typeDescNodes.stream().noneMatch(typeDescNode -> typeDescNode.toSourceCode().equals(typeDescNodeToBeInserted.toSourceCode()))) continue;
            typeDescNodes.add(typeDescNodeToBeInserted);
        }
    }

    private static String getUpdatedFieldName(String fieldName, boolean isArrayField, List<String> existingFieldNames, Map<String, String> updatedFieldNames) {
        if (updatedFieldNames.containsKey(fieldName)) {
            return updatedFieldNames.get(fieldName);
        }
        if (!existingFieldNames.contains(fieldName) && !updatedFieldNames.containsValue(fieldName)) {
            return fieldName;
        }
        String[] fieldNameSplit = fieldName.split("_");
        String numericSuffix = fieldNameSplit[fieldNameSplit.length - 1];
        if (NumberUtils.isParsable((String)numericSuffix)) {
            return JsonToRecordMapperConverterUtils.getUpdatedFieldName(String.join((CharSequence)"_", Arrays.copyOfRange(fieldNameSplit, 0, fieldNameSplit.length - 1)) + "_" + String.format("%02d", Integer.parseInt(numericSuffix) + 1), isArrayField, existingFieldNames, updatedFieldNames);
        }
        return JsonToRecordMapperConverterUtils.getUpdatedFieldName(fieldName + "_01", isArrayField, existingFieldNames, updatedFieldNames);
    }
}

