/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.expressioneditor.services;

import io.ballerina.flowmodelgenerator.core.expressioneditor.ExpressionEditorContext;
import io.ballerina.tools.text.TextDocument;
import java.util.concurrent.Callable;

public abstract class DebouncedExpressionEditorRequest<T>
implements Callable<T> {
    private final ExpressionEditorContext context;
    private TextDocument prevDoc;
    private boolean reverted;

    public DebouncedExpressionEditorRequest(ExpressionEditorContext context) {
        this.context = context;
        this.reverted = false;
    }

    public abstract T getResponse(ExpressionEditorContext var1);

    public abstract String getKey();

    public abstract long getDelay();

    @Override
    public T call() throws Exception {
        this.prevDoc = this.context.textDocument();
        T response = this.getResponse(this.context);
        this.revertDocument();
        return response;
    }

    public final void revertDocument() {
        if (!this.reverted && this.prevDoc != null) {
            this.context.applyContent(this.prevDoc);
            this.reverted = true;
        }
    }
}

