/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.flowmodelgenerator.core.model.FacetedBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.tools.text.LineRange;

public record Codedata(NodeKind node, String org, String module, String packageName, String object, String symbol, String version, LineRange lineRange, String sourceCode, String parentSymbol, String resourcePath, Integer id, Boolean isNew, Boolean isGenerated, String inferredReturnType) {
    @Override
    public String toString() {
        String[] fields;
        StringBuilder sb = new StringBuilder(this.node.toString());
        for (String field : fields = new String[]{this.org, this.module, this.object, this.symbol}) {
            if (field == null) continue;
            sb.append(":").append(field);
        }
        return sb.toString();
    }

    public String getImportSignature() {
        return this.org + "/" + this.module;
    }

    public String getModuleId() {
        return this.org + "/" + this.module + ":" + this.version;
    }

    public String getModulePrefix() {
        return this.module.substring(this.module.lastIndexOf(46) + 1);
    }

    public static class Builder<T>
    extends FacetedBuilder<T> {
        private NodeKind node;
        private String org;
        private String module;
        private String packageName;
        private String object;
        private String symbol;
        private String version;
        private LineRange lineRange;
        private String sourceCode;
        private String parentSymbol;
        private String resourcePath;
        private Integer id;
        private Boolean isNew;
        private Boolean isGenerated;
        private String inferredReturnType;

        public Builder(T parentBuilder) {
            super(parentBuilder);
        }

        public Builder<T> node(NodeKind node) {
            this.node = node;
            return this;
        }

        public Builder<T> org(String org) {
            this.org = org;
            return this;
        }

        public Builder<T> module(String module) {
            this.module = module;
            return this;
        }

        public Builder<T> packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder<T> object(String object) {
            this.object = object;
            return this;
        }

        public Builder<T> symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public Builder<T> version(String version) {
            this.version = version;
            return this;
        }

        public Builder<T> nodeInfo(Node node) {
            this.lineRange = node.lineRange();
            this.sourceCode = node.toSourceCode().strip();
            return this;
        }

        public Builder<T> lineRange(LineRange lineRange) {
            this.lineRange = lineRange;
            return this;
        }

        public Builder<T> sourceCode(String sourceCode) {
            this.sourceCode = sourceCode;
            return this;
        }

        public Builder<T> parentSymbol(String parentSymbol) {
            this.parentSymbol = parentSymbol;
            return this;
        }

        public Builder<T> resourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        public Builder<T> id(int id) {
            this.id = id;
            return this;
        }

        public Builder<T> isNew() {
            this.isNew = true;
            return this;
        }

        public Builder<T> isGenerated(Boolean isGenerated) {
            this.isGenerated = isGenerated;
            return this;
        }

        public Builder<T> inferredReturnType(String inferredReturnType) {
            this.inferredReturnType = inferredReturnType;
            return this;
        }

        public Codedata build() {
            return new Codedata(this.node, this.org, this.module, this.packageName, this.object, this.symbol, this.version, this.lineRange, this.sourceCode, this.parentSymbol, this.resourcePath, this.id, this.isNew, this.isGenerated, this.inferredReturnType);
        }
    }
}

