/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model;

import io.ballerina.flowmodelgenerator.core.model.TypeData;
import java.util.List;
import java.util.Map;

public record Member(MemberKind kind, List<String> refs, Object type, String name, String defaultValue, boolean optional, String docs, List<TypeData.Annotation> annotations, Map<String, String> imports) {

    public static enum MemberKind {
        FIELD,
        TYPE,
        NAME;

    }

    public static class MemberBuilder {
        private MemberKind kind;
        private List<String> refs;
        private Object type;
        private String name;
        private String defaultValue;
        private boolean optional = false;
        private String docs;
        private List<TypeData.Annotation> annotations;
        private Map<String, String> imports;

        public MemberBuilder kind(MemberKind kind) {
            this.kind = kind;
            return this;
        }

        public MemberBuilder refs(List<String> refs) {
            this.refs = refs;
            return this;
        }

        public MemberBuilder type(Object type) {
            this.type = type;
            return this;
        }

        public MemberBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MemberBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public MemberBuilder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public MemberBuilder docs(String docs) {
            this.docs = docs;
            return this;
        }

        public MemberBuilder annotations(List<TypeData.Annotation> annotations) {
            this.annotations = annotations;
            return this;
        }

        public MemberBuilder imports(Map<String, String> imports) {
            this.imports = imports;
            return this;
        }

        public Member build() {
            Member member = new Member(this.kind, List.copyOf(this.refs), this.type, this.name, this.defaultValue, this.optional, this.docs, this.annotations != null ? List.copyOf(this.annotations) : null, this.imports != null ? Map.copyOf(this.imports) : null);
            this.kind = null;
            this.refs = null;
            this.type = null;
            this.name = null;
            this.defaultValue = null;
            this.optional = false;
            this.docs = null;
            this.annotations = null;
            this.imports = null;
            return member;
        }
    }
}

