/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.flowmodelgenerator.core.model.FacetedBuilder;
import io.ballerina.modelgenerator.commons.CommonUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public record Metadata(String label, String description, List<String> keywords, String icon, String functionKind, Map<String, Object> data) {

    public static class Builder<T>
    extends FacetedBuilder<T> {
        private String label;
        private String description;
        private List<String> keywords;
        private String icon;
        private String functionKind;
        private Map<String, Object> data;

        public Builder(T parentBuilder) {
            super(parentBuilder);
        }

        public Builder<T> label(String label) {
            this.label = label;
            return this;
        }

        public Builder<T> description(String description) {
            this.description = description;
            return this;
        }

        public Builder<T> description(String format, Object ... args) {
            Object[] preprocessedArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                preprocessedArgs[i] = arg instanceof Node ? CommonUtils.getVariableName((Node)((Node)arg)) : arg;
            }
            this.description = String.format(format, preprocessedArgs);
            return this;
        }

        public Builder<T> keywords(List<String> keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder<T> icon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder<T> functionKind(String functionKind) {
            this.functionKind = functionKind;
            return this;
        }

        public Builder<T> data(String key, Object value) {
            if (this.data == null) {
                this.data = new LinkedHashMap<String, Object>();
            }
            this.data.put(key, value);
            return this;
        }

        public Builder<T> data(Map<String, Object> data) {
            this.data = data;
            return this;
        }

        public Builder<T> addData(String key, Object value) {
            if (this.data == null) {
                this.data = new LinkedHashMap<String, Object>();
            }
            this.data.put(key, value);
            return this;
        }

        public Metadata build() {
            return new Metadata(this.label, this.description, this.keywords, this.icon, this.functionKind, this.data);
        }
    }
}

