/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.Branch;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.TextEdit;

public class IfBuilder
extends NodeBuilder {
    public static final String LABEL = "If";
    public static final String DESCRIPTION = "Add conditional branch to the integration flow.";
    public static final String IF_THEN_LABEL = "Then";
    public static final String IF_ELSE_LABEL = "Else";
    private static final String IF_CONDITION_DOC = "Boolean Condition";

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.IF);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        List<Branch> branches = sourceBuilder.flowNode.branches();
        Optional<Object> ifBranch = Optional.empty();
        Optional<Object> elseBranch = Optional.empty();
        ArrayList<Branch> remainingBranches = new ArrayList<Branch>();
        block8: for (Branch branch2 : branches) {
            switch (branch2.label()) {
                case "Then": {
                    ifBranch = Optional.of(branch2);
                    continue block8;
                }
                case "Else": {
                    elseBranch = Optional.of(branch2);
                    continue block8;
                }
            }
            remainingBranches.add(branch2);
        }
        if (ifBranch.isEmpty() || ((Branch)ifBranch.get()).getProperty("condition").isEmpty()) {
            throw new IllegalStateException("If node does not have a valid then branch or condition");
        }
        ((SourceBuilder)sourceBuilder.token().keyword(SyntaxKind.IF_KEYWORD).expression(((Branch)ifBranch.get()).getProperty("condition").get()).stepOut()).body(((Branch)ifBranch.get()).children());
        for (Branch branch2 : remainingBranches) {
            Optional<Property> branchCondition = branch2.getProperty("condition");
            if (branchCondition.isEmpty()) {
                throw new IllegalStateException("Else-if branch does not have a condition");
            }
            ((SourceBuilder)sourceBuilder.token().keyword(SyntaxKind.ELSE_KEYWORD).keyword(SyntaxKind.IF_KEYWORD).expression(branchCondition.get()).stepOut()).body(branch2.children());
        }
        elseBranch.ifPresent(branch -> ((SourceBuilder)sourceBuilder.token().whiteSpace().keyword(SyntaxKind.ELSE_KEYWORD).stepOut()).body(branch.children()));
        return sourceBuilder.textEdit().build();
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        Branch.Builder thenBranchBuilder = (Branch.Builder)new Branch.Builder().label(IF_THEN_LABEL).kind(Branch.BranchKind.BLOCK).repeatable(Branch.Repeatable.ONE_OR_MORE).codedata().node(NodeKind.CONDITIONAL).stepOut();
        thenBranchBuilder.properties().condition(null);
        this.branches = List.of(thenBranchBuilder.build());
    }
}

