/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.Branch;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.lsp4j.TextEdit;

public class ParallelFlowBuilder
extends NodeBuilder {
    public static final String LABEL = "Parallel Flow";
    public static final String DESCRIPTION = "Create parallel flows";

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.PARALLEL_FLOW);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        this.generateWorkers(sourceBuilder);
        return sourceBuilder.textEdit().build();
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        Set<String> names = context.getAllVisibleSymbolNames();
        Branch firstBranch = Branch.getDefaultWorkerBranch(names);
        names.add(firstBranch.label());
        this.branches = List.of(firstBranch, Branch.getDefaultWorkerBranch(names));
    }

    protected List<String> generateWorkers(SourceBuilder sourceBuilder) {
        List<Branch> branches = sourceBuilder.flowNode.branches();
        ArrayList<String> workerNames = new ArrayList<String>();
        for (Branch branch : branches) {
            Optional<Property> variableProperty = branch.getProperty("variable");
            if (variableProperty.isEmpty()) continue;
            sourceBuilder.token().keyword(SyntaxKind.WORKER_KEYWORD).name(variableProperty.get()).whiteSpace();
            workerNames.add(variableProperty.get().value().toString());
            Optional<Property> typeProperty = branch.getProperty("type");
            if (typeProperty.isPresent() && !typeProperty.get().value().toString().isEmpty()) {
                sourceBuilder.token().keyword(SyntaxKind.RETURNS_KEYWORD).name(typeProperty.get());
            }
            sourceBuilder.body(branch.children());
        }
        return workerNames;
    }
}

