/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.TextEdit;

public class ReturnBuilder
extends NodeBuilder {
    public static final String LABEL = "Return";
    public static final String DESCRIPTION = "Value of '%s'";
    public static final String RETURN_EXPRESSION_DOC = "Return value";

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL);
        this.codedata().node(NodeKind.RETURN);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        sourceBuilder.token().keyword(SyntaxKind.RETURN_KEYWORD);
        Optional<Property> property = sourceBuilder.getProperty("expression");
        property.ifPresent(value -> sourceBuilder.token().whiteSpace().expression((Property)value));
        sourceBuilder.token().endOfStatement();
        return sourceBuilder.textEdit().build();
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        this.properties().expressionOrAction(null, RETURN_EXPRESSION_DOC, false);
    }
}

