/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.Branch;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.TextEdit;

public class TransactionBuilder
extends NodeBuilder {
    public static final String LABEL = "Transaction";
    public static final String DESCRIPTION = "Handle transaction.";

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.TRANSACTION);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        Optional<Branch> body = sourceBuilder.flowNode.getBranch("Body");
        if (sourceBuilder.flowNode.properties() != null) {
            Property retryCount = sourceBuilder.flowNode.properties().get("retryCount");
            return ((SourceBuilder)sourceBuilder.token().keyword(SyntaxKind.RETRY_KEYWORD).openParen().expression(retryCount).closeParen().whiteSpace().keyword(SyntaxKind.TRANSACTION_KEYWORD).stepOut()).body(body.isPresent() ? body.get().children() : Collections.emptyList()).onFailure().textEdit().build();
        }
        return ((SourceBuilder)sourceBuilder.token().keyword(SyntaxKind.TRANSACTION_KEYWORD).stepOut()).body(body.isPresent() ? body.get().children() : Collections.emptyList()).onFailure().textEdit().build();
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        this.branches = List.of(Branch.DEFAULT_BODY_BRANCH, Branch.getDefaultOnFailBranch(true));
        this.properties().retryCount(3, true);
    }
}

