/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.utils;

import com.google.gson.Gson;
import io.ballerina.flowmodelgenerator.core.model.Function;
import io.ballerina.flowmodelgenerator.core.model.Member;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.TypeData;
import io.ballerina.modelgenerator.commons.CommonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.ballerinalang.langserver.common.utils.CommonUtil;

public class SourceCodeGenerator {
    private final Gson gson = new Gson();
    private final Map<String, String> imports = new HashMap<String, String>();
    private static final String LS = System.lineSeparator();

    public String generateCodeSnippetForType(TypeData typeData) {
        NodeKind nodeKind = typeData.codedata().node();
        return switch (nodeKind) {
            case NodeKind.SERVICE_DECLARATION, NodeKind.CLASS -> "";
            case NodeKind.ENUM -> this.generateEnumCodeSnippet(typeData);
            default -> this.generateTypeDefCodeSnippet(typeData);
        };
    }

    public String generateGraphqlClassType(TypeData typeData) {
        NodeKind nodeKind = typeData.codedata().node();
        if (nodeKind != NodeKind.CLASS) {
            return "";
        }
        StringBuilder fieldBuilder = new StringBuilder();
        for (Member member : typeData.members()) {
            fieldBuilder.append(this.generateDocs(member.docs(), "\t")).append(this.generateMember(member, true)).append(";");
        }
        StringBuilder resourceFunctions = new StringBuilder();
        if (typeData.functions() != null) {
            for (Function function : typeData.functions()) {
                resourceFunctions.append(this.generateResourceFunction(function));
            }
        }
        String string = "%nservice class %s {%s%n\tfunction init() {%n\t}%s%n}";
        return string.formatted(typeData.name(), fieldBuilder.toString(), resourceFunctions.toString());
    }

    public Map<String, String> getImports() {
        return this.imports;
    }

    private String generateEnumCodeSnippet(TypeData typeData) {
        String docs = this.generateDocs(typeData.metadata().description(), "");
        StringBuilder enumValues = new StringBuilder();
        for (int i = 0; i < typeData.members().size(); ++i) {
            Member member = typeData.members().get(i);
            enumValues.append(LS).append("\t").append(member.name());
            if (member.defaultValue() != null && !member.defaultValue().isEmpty()) {
                enumValues.append(" = ").append(member.defaultValue());
            }
            if (i >= typeData.members().size() - 1) continue;
            enumValues.append(",");
        }
        String template = "%senum %s {%s%n}%n";
        return template.formatted(docs, typeData.name(), enumValues.toString());
    }

    private String generateTypeDefCodeSnippet(TypeData typeData) {
        String docs = this.generateDocs(typeData.metadata().description(), "");
        String typeDescriptor = this.generateTypeDescriptor(typeData);
        String template = "%stype %s %s;";
        return template.formatted(docs, typeData.name(), typeDescriptor);
    }

    private String generateTypeDescriptor(Object typeDescriptor) {
        if (typeDescriptor instanceof String) {
            return (String)typeDescriptor;
        }
        TypeData typeData = this.toTypeData(typeDescriptor);
        return switch (typeData.codedata().node()) {
            case NodeKind.RECORD -> this.generateRecordTypeDescriptor(typeData);
            case NodeKind.ARRAY -> this.generateArrayTypeDescriptor(typeData);
            case NodeKind.MAP -> this.generateMapTypeDescriptor(typeData);
            case NodeKind.STREAM -> this.generateStreamTypeDescriptor(typeData);
            case NodeKind.FUTURE -> this.generateFutureTypeDescriptor(typeData);
            case NodeKind.TYPEDESC -> this.generateTypedescTypeDescriptor(typeData);
            case NodeKind.ERROR -> this.generateErrorTypeDescriptor(typeData);
            case NodeKind.UNION -> this.generateUnionTypeDescriptor(typeData);
            case NodeKind.INTERSECTION -> this.generateIntersectionTypeDescriptor(typeData);
            case NodeKind.OBJECT -> this.generateObjectTypeDescriptor(typeData);
            case NodeKind.TABLE -> this.generateTableTypeDescriptor(typeData);
            case NodeKind.TUPLE -> this.generateTupleTypeDescriptor(typeData);
            default -> throw new UnsupportedOperationException("Unsupported type descriptor: " + String.valueOf(typeDescriptor));
        };
    }

    private String generateObjectTypeDescriptor(TypeData typeData) {
        StringBuilder fieldsBuilder = new StringBuilder();
        for (Member member : typeData.members()) {
            fieldsBuilder.append(this.generateFieldMember(member, false));
        }
        String objectTemplate = "object {%s%n}";
        return objectTemplate.formatted(fieldsBuilder.toString());
    }

    private String generateRecordTypeDescriptor(TypeData typeData) {
        StringBuilder inclusionsBuilder = new StringBuilder();
        typeData.includes().forEach(include -> inclusionsBuilder.append(LS).append("\t*").append((String)include).append(";"));
        StringBuilder fieldsBuilder = new StringBuilder();
        for (Member member : typeData.members()) {
            fieldsBuilder.append(this.generateFieldMember(member, true));
        }
        String restField = "";
        String template = "record {|%s%s%s%n|}";
        if (typeData.allowAdditionalFields()) {
            template = "record {%s%s%s%n}";
        }
        return template.formatted(inclusionsBuilder.toString(), fieldsBuilder.toString(), restField);
    }

    private String generateFieldMember(Member member, boolean withDefaultValue) {
        StringBuilder stringBuilder = new StringBuilder();
        String docs = this.generateDocs(member.docs(), "\t");
        stringBuilder.append(docs).append("\t").append(this.generateMember(member, withDefaultValue)).append(";");
        return stringBuilder.toString();
    }

    private String generateTableTypeDescriptor(TypeData typeData) {
        if (typeData.members().isEmpty()) {
            return "table";
        }
        String rowType = this.generateTypeFromMember(typeData.members().getFirst());
        Object keyInformation = "";
        if (typeData.members().size() > 1) {
            keyInformation = " key<" + this.generateTypeDescriptor(typeData.members().get(1).type()) + ">";
        }
        String template = "table<%s>%s";
        return template.formatted(rowType, keyInformation);
    }

    private String generateIntersectionTypeDescriptor(TypeData typeData) {
        StringBuilder stringBuilder = new StringBuilder();
        if (typeData.members().size() <= 1) {
            return "";
        }
        for (int i = 0; i < typeData.members().size(); ++i) {
            Member member = typeData.members().get(i);
            if (member.type() instanceof TypeData) {
                if (((TypeData)member.type()).codedata().node() == NodeKind.INTERSECTION) {
                    stringBuilder.append("(").append(this.generateTypeFromMember(member)).append(")");
                } else {
                    stringBuilder.append(this.generateTypeFromMember(member));
                }
            } else {
                stringBuilder.append(this.generateTypeFromMember(member));
            }
            if (i >= typeData.members().size() - 1) continue;
            stringBuilder.append(" & ");
        }
        return stringBuilder.toString();
    }

    private String generateTupleTypeDescriptor(TypeData typeData) {
        StringBuilder stringBuilder = new StringBuilder();
        if (typeData.members().isEmpty()) {
            stringBuilder.append("[]");
            return "";
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (Member member : typeData.members()) {
            joiner.add(this.generateTypeFromMember(member));
        }
        String template = "[%s]";
        stringBuilder.append(template.formatted(joiner.toString()));
        return stringBuilder.toString();
    }

    private String generateUnionTypeDescriptor(TypeData typeData) {
        StringBuilder stringBuilder = new StringBuilder();
        if (typeData.members().size() <= 1) {
            return "";
        }
        for (int i = 0; i < typeData.members().size(); ++i) {
            Member member = typeData.members().get(i);
            if (member.type() instanceof TypeData) {
                if (((TypeData)member.type()).codedata().node() == NodeKind.UNION) {
                    stringBuilder.append("(").append(this.generateTypeFromMember(member)).append(")");
                } else {
                    stringBuilder.append(this.generateTypeFromMember(member));
                }
            } else {
                stringBuilder.append(this.generateTypeFromMember(member));
            }
            if (i >= typeData.members().size() - 1) continue;
            stringBuilder.append("|");
        }
        return stringBuilder.toString();
    }

    private String generateErrorTypeDescriptor(TypeData typeData) {
        if (typeData.members().size() == 1) {
            return "error<" + this.generateTypeFromMember(typeData.members().getFirst()) + ">";
        }
        return "error";
    }

    private String generateTypedescTypeDescriptor(TypeData typeData) {
        if (typeData.members().size() == 1) {
            return "typedesc<" + this.generateTypeFromMember(typeData.members().getFirst()) + ">";
        }
        return "typedesc<>";
    }

    private String generateFutureTypeDescriptor(TypeData typeData) {
        if (typeData.members().size() == 1) {
            return "future<" + this.generateTypeFromMember(typeData.members().getFirst()) + ">";
        }
        return "future<>";
    }

    private String generateStreamTypeDescriptor(TypeData typeData) {
        if (typeData.members().size() == 1) {
            return "stream<" + this.generateTypeFromMember(typeData.members().getFirst()) + ">";
        }
        return "stream<>";
    }

    private String generateMapTypeDescriptor(TypeData typeData) {
        if (typeData.members().size() == 1) {
            return "map<" + this.generateTypeFromMember(typeData.members().getFirst()) + ">";
        }
        return "map<>";
    }

    private String generateArrayTypeDescriptor(TypeData typeData) {
        NodeKind nodeKind;
        Property arraySizeProperty = typeData.properties().get("arraySize");
        String arraySize = "";
        if (arraySizeProperty != null) {
            arraySize = arraySizeProperty.value().toString();
        }
        if (typeData.members().size() != 1) {
            return "[" + arraySize + "]";
        }
        Member typeMember = typeData.members().getFirst();
        Object type = typeMember.type();
        Object transformed = this.generateTypeFromMember(typeMember);
        if (!(type instanceof String || (nodeKind = this.toTypeData(type).codedata().node()) != NodeKind.UNION && nodeKind != NodeKind.INTERSECTION)) {
            transformed = "(" + (String)transformed + ")";
        }
        return (String)transformed + "[" + arraySize + "]";
    }

    private String generateTypeFromMember(Member member) {
        if (Objects.nonNull(member.imports())) {
            member.imports().forEach(this.imports::putIfAbsent);
        }
        return this.generateTypeDescriptor(member.type());
    }

    private String generateDocs(String docs, String indent) {
        return docs != null && !docs.isEmpty() ? LS + indent + CommonUtils.convertToBalDocs((String)docs) : LS;
    }

    private String generateMember(Member member, boolean withDefaultValue) {
        String typeDescriptor = this.generateTypeFromMember(member);
        String template = "%s %s%s";
        Object fieldName = CommonUtil.escapeReservedKeyword((String)member.name());
        if (member.optional()) {
            fieldName = (String)fieldName + "?";
        }
        return template.formatted(typeDescriptor, fieldName, withDefaultValue && member.defaultValue() != null && !member.defaultValue().isEmpty() ? " = " + member.defaultValue() : "");
    }

    private String generateResourceFunction(Function function) {
        if (Objects.nonNull(function.imports())) {
            function.imports().forEach(this.imports::putIfAbsent);
        }
        String docs = this.generateDocs(function.description(), "\t");
        StringJoiner paramJoiner = new StringJoiner(", ");
        for (Member param : function.parameters()) {
            String genParam = this.generateMember(param, true);
            paramJoiner.add(genParam);
        }
        String template = "%s\tresource function %s %s(%s) returns %s {%n\t\tdo {%n\t\t\tpanic error(\"Unimplemented function\");%n\t\t} on fail error err {%n\t\t\t//handle error%n\t\t\tpanic error(\"Unhandled error\");%n\t\t}%n\t}";
        return template.formatted(docs, function.accessor(), function.name(), paramJoiner.toString(), this.generateTypeDescriptor(function.returnType()), function.name());
    }

    private TypeData toTypeData(Object typeDescAsObject) {
        TypeData typeData;
        if (typeDescAsObject instanceof Map) {
            String json = this.gson.toJson(typeDescAsObject);
            typeData = (TypeData)this.gson.fromJson(json, TypeData.class);
        } else {
            typeData = (TypeData)typeDescAsObject;
        }
        return typeData;
    }
}

