/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.servicemodelgenerator.extension.model;

import io.ballerina.servicemodelgenerator.extension.ServiceModelGeneratorConstants;
import io.ballerina.servicemodelgenerator.extension.model.MetaData;
import io.ballerina.servicemodelgenerator.extension.model.Value;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;

public class Parameter {
    private MetaData metadata;
    private String kind;
    private Value type;
    private Value name;
    private Value defaultValue;
    private boolean enabled;
    private boolean editable;
    private boolean optional;
    private boolean advanced;
    private String httpParamType;

    public Parameter(MetaData metadata, String kind, Value type, Value name, Value defaultValue, boolean enabled, boolean editable, boolean optional, boolean advanced, String httpParamType) {
        this.metadata = metadata;
        this.kind = kind;
        this.type = type;
        this.name = name;
        this.defaultValue = defaultValue;
        this.enabled = enabled;
        this.editable = editable;
        this.optional = optional;
        this.advanced = advanced;
        this.httpParamType = httpParamType;
    }

    public Parameter(Parameter parameter) {
        this.metadata = parameter.metadata;
        this.kind = parameter.kind;
        this.type = parameter.type;
        this.name = parameter.name;
        this.defaultValue = parameter.defaultValue;
        this.enabled = parameter.enabled;
        this.editable = parameter.editable;
        this.optional = parameter.optional;
        this.advanced = parameter.advanced;
        this.httpParamType = parameter.httpParamType;
    }

    public MetaData getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetaData metadata) {
        this.metadata = metadata;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public Value getType() {
        return this.type;
    }

    public void setType(Value type) {
        this.type = type;
    }

    public Value getName() {
        return this.name;
    }

    public void setName(Value name) {
        this.name = name;
    }

    public Value getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Value defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
    }

    public String getHttpParamType() {
        if (Objects.isNull(this.httpParamType)) {
            return null;
        }
        return this.httpParamType.charAt(0) + this.httpParamType.substring(1).toLowerCase(Locale.ROOT);
    }

    public void setHttpParamType(String httpParamType) {
        this.httpParamType = httpParamType;
    }

    private static Value name(MetaData metadata) {
        return new Value.ValueBuilder().setMetadata(metadata).valueType("IDENTIFIER").enabled(true).editable(true).build();
    }

    private static Value type(MetaData metadata) {
        return new Value.ValueBuilder().setMetadata(metadata).valueType("TYPE").isType(true).enabled(true).editable(true).build();
    }

    private static Value defaultValue(MetaData metadata) {
        return new Value.ValueBuilder().setMetadata(metadata).valueType("EXPRESSION").enabled(true).editable(true).optional(true).build();
    }

    public static Parameter getNewField() {
        return new Builder().type(Parameter.type(ServiceModelGeneratorConstants.FIELD_TYPE_METADATA)).name(Parameter.name(ServiceModelGeneratorConstants.FIELD_NAME_METADATA)).defaultValue(Parameter.defaultValue(ServiceModelGeneratorConstants.FIELD_DEFAULT_VALUE_METADATA)).build();
    }

    public static Parameter graphQLParamSchema() {
        return new Builder().type(Parameter.type(ServiceModelGeneratorConstants.ARGUMENT_TYPE_METADATA)).name(Parameter.name(ServiceModelGeneratorConstants.ARGUMENT_NAME_METADATA)).defaultValue(Parameter.defaultValue(ServiceModelGeneratorConstants.ARGUMENT_DEFAULT_VALUE_METADATA)).enabled(true).editable(true).build();
    }

    public static Parameter functionParamSchema() {
        return new Builder().type(Parameter.type(ServiceModelGeneratorConstants.PARAMETER_TYPE_METADATA)).name(Parameter.name(ServiceModelGeneratorConstants.PARAMETER_NAME_METADATA)).defaultValue(Parameter.defaultValue(ServiceModelGeneratorConstants.PARAMETER_DEFAULT_VALUE_METADATA)).enabled(true).editable(true).build();
    }

    public static Parameter getNewParameter(boolean isGraphQL) {
        return isGraphQL ? Parameter.graphQLParamSchema() : Parameter.functionParamSchema();
    }

    public static class Builder {
        private MetaData metadata;
        private String kind;
        private Value type;
        private Value name;
        private Value defaultValue;
        private boolean enabled;
        private boolean editable;
        private boolean optional;
        private boolean advanced;
        private String httpParamType;

        public Builder metadata(MetaData metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public Builder type(Value type) {
            this.type = type;
            return this;
        }

        public Builder name(Value name) {
            this.name = name;
            return this;
        }

        public Builder defaultValue(Value defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder editable(boolean editable) {
            this.editable = editable;
            return this;
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder advanced(boolean advanced) {
            this.advanced = advanced;
            return this;
        }

        public Builder httpParamType(String httpParamType) {
            this.httpParamType = httpParamType;
            return this;
        }

        public Parameter build() {
            return new Parameter(this.metadata, this.kind, this.type, this.name, this.defaultValue, this.enabled, this.editable, this.optional, this.advanced, this.httpParamType);
        }
    }

    public static class RequiredParamSorter
    implements Comparator<Parameter>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Parameter param1, Parameter param2) {
            boolean isEnabled2;
            Value param1DefaultValue = param1.getDefaultValue();
            Value param2DefaultValue = param2.getDefaultValue();
            if (param1DefaultValue == null && param2DefaultValue == null) {
                return 0;
            }
            if (param1DefaultValue == null) {
                return -1;
            }
            if (param2DefaultValue == null) {
                return 1;
            }
            boolean isEnabled1 = param1DefaultValue.isEnabledWithValue();
            if (isEnabled1 == (isEnabled2 = param2DefaultValue.isEnabledWithValue())) {
                return 0;
            }
            if (isEnabled1) {
                return 1;
            }
            return -1;
        }
    }
}

