/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.servicemodelgenerator.extension.model;

import io.ballerina.servicemodelgenerator.extension.model.Codedata;
import io.ballerina.servicemodelgenerator.extension.model.DisplayAnnotation;
import io.ballerina.servicemodelgenerator.extension.model.Function;
import io.ballerina.servicemodelgenerator.extension.model.Value;
import io.ballerina.servicemodelgenerator.extension.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Service {
    private final String id;
    private final String name;
    private final String type;
    private final String displayName;
    private final String description;
    private final DisplayAnnotation displayAnnotation;
    private final String moduleName;
    private final String orgName;
    private final String version;
    private final String packageName;
    private final String listenerProtocol;
    private final String icon;
    private Map<String, Value> properties;
    private Codedata codedata;
    private List<Function> functions;

    public Service(String id, String name, String type, String displayName, String description, DisplayAnnotation displayAnnotation, String moduleName, String orgName, String version, String packageName, String listenerProtocol, String icon, Map<String, Value> properties, Codedata codedata, List<Function> functions) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.displayName = displayName;
        this.description = description;
        this.displayAnnotation = displayAnnotation;
        this.moduleName = moduleName;
        this.orgName = orgName;
        this.version = version;
        this.packageName = packageName;
        this.listenerProtocol = listenerProtocol;
        this.icon = icon;
        this.properties = properties;
        this.functions = functions;
        this.codedata = codedata;
    }

    public List<Function> getFunctions() {
        return this.functions;
    }

    public void setFunctions(List<Function> functions) {
        this.functions = functions;
    }

    public void addFunction(Function function) {
        this.functions.add(function);
    }

    public Codedata getCodedata() {
        return this.codedata;
    }

    public void setCodedata(Codedata codedata) {
        this.codedata = codedata;
    }

    public Value getListener() {
        return this.properties.get("listener");
    }

    public Value getProperty(String key) {
        return this.properties.get(key);
    }

    public void setServiceType(Value serviceType) {
        this.properties.put("serviceType", serviceType);
    }

    public Value getServiceType() {
        return this.properties.get("serviceType");
    }

    public String getServiceTypeName() {
        Value serviceType = this.properties.get("serviceType");
        if (Objects.isNull(serviceType)) {
            return null;
        }
        return this.listenerProtocol + ":" + Utils.getValueString(serviceType);
    }

    public Value getBasePath() {
        return this.properties.get("basePath");
    }

    public Value getStringLiteralProperty() {
        return this.properties.get("stringLiteral");
    }

    public void setBasePath(Value basePath) {
        this.properties.put("basePath", basePath);
    }

    public void setStringLiteral(Value basePath) {
        this.properties.put("stringLiteral", basePath);
    }

    public Value getOpenAPISpec() {
        return this.properties.get("spec");
    }

    public Value getServiceContractTypeNameValue() {
        return this.properties.get("serviceTypeName");
    }

    public String getServiceContractTypeName() {
        Value serviceContractType = this.properties.get("serviceTypeName");
        if (Objects.isNull(serviceContractType)) {
            return "Service";
        }
        return Utils.getValueString(serviceContractType);
    }

    public void setServiceContractTypeName(Value serviceContractType) {
        this.properties.put("serviceTypeName", serviceContractType);
    }

    public Value getDesignApproach() {
        return this.properties.get("designApproach");
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getListenerProtocol() {
        return this.listenerProtocol;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public DisplayAnnotation getDisplayAnnotation() {
        return this.displayAnnotation;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, Value> getProperties() {
        return this.properties;
    }

    public void addProperties(Map<String, Value> properties) {
        if (Objects.isNull(properties)) {
            return;
        }
        if (Objects.nonNull(this.properties)) {
            this.properties.putAll(properties);
        } else {
            this.properties = properties;
        }
    }

    public static Service getEmptyServiceModel() {
        return new ServiceModelBuilder().setFunctions(new ArrayList<Function>()).setProperties(new HashMap<String, Value>()).build();
    }

    public static class ServiceModelBuilder {
        private String id;
        private String name;
        private String type;
        private String displayName;
        private String description;
        private DisplayAnnotation displayAnnotation;
        private String moduleName;
        private String orgName;
        private String version;
        private String packageName;
        private String listenerProtocol;
        private String icon;
        private Map<String, Value> properties = new HashMap<String, Value>();
        private Codedata codedata;
        private List<Function> functions = new ArrayList<Function>();

        public ServiceModelBuilder setId(String id) {
            this.id = id;
            return this;
        }

        public ServiceModelBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public ServiceModelBuilder setType(String type) {
            this.type = type;
            return this;
        }

        public ServiceModelBuilder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ServiceModelBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public ServiceModelBuilder setDisplayAnnotation(DisplayAnnotation displayAnnotation) {
            this.displayAnnotation = displayAnnotation;
            return this;
        }

        public ServiceModelBuilder setModuleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public ServiceModelBuilder setOrgName(String orgName) {
            this.orgName = orgName;
            return this;
        }

        public ServiceModelBuilder setVersion(String version) {
            this.version = version;
            return this;
        }

        public ServiceModelBuilder setPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public ServiceModelBuilder setListenerProtocol(String listenerProtocol) {
            this.listenerProtocol = listenerProtocol;
            return this;
        }

        public ServiceModelBuilder setIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public ServiceModelBuilder setProperties(Map<String, Value> properties) {
            this.properties = properties;
            return this;
        }

        public ServiceModelBuilder setCodedata(Codedata codedata) {
            this.codedata = codedata;
            return this;
        }

        public ServiceModelBuilder setFunctions(List<Function> functions) {
            this.functions = functions;
            return this;
        }

        public Service build() {
            return new Service(this.id, this.name, this.type, this.displayName, this.description, this.displayAnnotation, this.moduleName, this.orgName, this.version, this.packageName, this.listenerProtocol, this.icon, this.properties, this.codedata, this.functions);
        }
    }
}

