/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.servicemodelgenerator.extension.util;

import io.ballerina.servicemodelgenerator.extension.model.Function;
import io.ballerina.servicemodelgenerator.extension.model.MetaData;

public class GraphqlUtil {
    public static void updateGraphqlFunctionMetaData(Function function) {
        switch (function.getKind()) {
            case "QUERY": {
                function.setMetadata(GraphqlUtil.graphqlQueryMetaData());
                function.getName().setMetadata(GraphqlUtil.graphqlQueryNameMetaData());
                break;
            }
            case "MUTATION": {
                function.setMetadata(GraphqlUtil.graphqlMutationMetaData());
                function.getName().setMetadata(GraphqlUtil.graphqlMutationNameMetaData());
                break;
            }
            case "SUBSCRIPTION": {
                function.setMetadata(GraphqlUtil.graphqlSubscriptionMetaData());
                function.getName().setMetadata(GraphqlUtil.graphqlSubscriptionNameMetaData());
                break;
            }
        }
    }

    private static MetaData graphqlSubscriptionNameMetaData() {
        return new MetaData("Subscription Name", "The name of the subscription");
    }

    private static MetaData graphqlQueryNameMetaData() {
        return new MetaData("Field Name", "The name of the field");
    }

    private static MetaData graphqlMutationNameMetaData() {
        return new MetaData("Mutation Name", "The name of the mutation");
    }

    private static MetaData graphqlSubscriptionMetaData() {
        return new MetaData("Graphql Subscription", "Graphql Subscription");
    }

    private static MetaData graphqlQueryMetaData() {
        return new MetaData("Graphql Query", "Graphql Query");
    }

    private static MetaData graphqlMutationMetaData() {
        return new MetaData("Graphql Mutation", "Graphql Mutation");
    }
}

