/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.servicemodelgenerator.extension.util;

import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.modelgenerator.commons.FunctionData;
import io.ballerina.modelgenerator.commons.ParameterData;
import io.ballerina.servicemodelgenerator.extension.model.Codedata;
import io.ballerina.servicemodelgenerator.extension.model.MetaData;
import io.ballerina.servicemodelgenerator.extension.model.Value;
import io.ballerina.servicemodelgenerator.extension.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import org.ballerinalang.langserver.common.utils.CommonUtil;

public class ListenerDeclAnalyzer {
    private final Map<String, Value> properties;

    public ListenerDeclAnalyzer(Map<String, Value> properties) {
        this.properties = properties;
    }

    public Map<String, Value> getProperties() {
        return this.properties;
    }

    public void analyze(SeparatedNodeList<FunctionArgumentNode> arguments, FunctionSymbol functionSymbol, FunctionData functionData) {
        HashMap<String, Node> namedArgValueMap = new HashMap<String, Node>();
        LinkedList<Node> positionalArgs = new LinkedList<Node>();
        this.calculateFunctionArgs(namedArgValueMap, positionalArgs, arguments);
        this.buildPropsFromFuncCallArgs(arguments, functionSymbol.typeDescriptor(), functionData.parameters(), positionalArgs, namedArgValueMap);
    }

    private void calculateFunctionArgs(Map<String, Node> namedArgValueMap, Queue<Node> positionalArgs, SeparatedNodeList<FunctionArgumentNode> argumentNodes) {
        if (argumentNodes != null) {
            for (FunctionArgumentNode argument : argumentNodes) {
                switch (argument.kind()) {
                    case NAMED_ARG: {
                        NamedArgumentNode namedArgument = (NamedArgumentNode)argument;
                        namedArgValueMap.put(namedArgument.argumentName().name().text(), (Node)namedArgument.expression());
                        break;
                    }
                    case POSITIONAL_ARG: {
                        positionalArgs.add((Node)((PositionalArgumentNode)argument).expression());
                        break;
                    }
                }
            }
        }
    }

    private void buildPropsFromFuncCallArgs(SeparatedNodeList<FunctionArgumentNode> argumentNodes, FunctionTypeSymbol functionTypeSymbol, Map<String, ParameterData> funcParamMap, Queue<Node> positionalArgs, Map<String, Node> namedArgValueMap) {
        if (argumentNodes == null) {
            List<ParameterData> functionParameters = funcParamMap.values().stream().toList();
            for (ParameterData paramResult : functionParameters) {
                ParameterData.Kind paramKind = paramResult.kind();
                if (paramKind.equals((Object)ParameterData.Kind.PATH_PARAM) || paramKind.equals((Object)ParameterData.Kind.PATH_REST_PARAM) || paramKind.equals((Object)ParameterData.Kind.PARAM_FOR_TYPE_INFER) || paramKind.equals((Object)ParameterData.Kind.INCLUDED_RECORD)) continue;
                String unescapedParamName = Utils.removeLeadingSingleQuote(paramResult.name());
                Codedata codedata = new Codedata("LISTENER_INIT_PARAM");
                codedata.setOriginalName(paramResult.name());
                Value.ValueBuilder valueBuilder = new Value.ValueBuilder().setMetadata(new MetaData(unescapedParamName, paramResult.description())).setCodedata(codedata).value("").valueType("EXPRESSION").setPlaceholder(paramResult.defaultValue()).setValueTypeConstraint(paramResult.type().toString()).editable(true).isType(false).enabled(true).optional(paramResult.optional()).setAdvanced(paramResult.optional()).setTypeMembers(paramResult.typeMembers());
                this.properties.put(unescapedParamName, valueBuilder.build());
            }
            return;
        }
        if (functionTypeSymbol.restParam().isPresent()) {
            ParameterSymbol restParamSymbol = (ParameterSymbol)functionTypeSymbol.restParam().get();
            Optional paramsOptional = functionTypeSymbol.params();
            if (paramsOptional.isPresent()) {
                int i;
                List paramsList = (List)paramsOptional.get();
                int paramCount = paramsList.size();
                int argCount = positionalArgs.size();
                ArrayList<String> restArgs = new ArrayList<String>();
                for (i = 0; i < paramsList.size(); ++i) {
                    ParameterSymbol parameterSymbol = (ParameterSymbol)paramsList.get(i);
                    String escapedParamName = (String)parameterSymbol.getName().get();
                    ParameterData paramResult = funcParamMap.get(escapedParamName);
                    if (paramResult == null) {
                        escapedParamName = CommonUtil.escapeReservedKeyword((String)((String)parameterSymbol.getName().get()));
                    }
                    paramResult = funcParamMap.get(escapedParamName);
                    Node paramValue = i < argCount ? positionalArgs.poll() : namedArgValueMap.get(paramResult.name());
                    funcParamMap.remove(parameterSymbol.getName().get());
                    String value = paramValue != null ? paramValue.toSourceCode() : null;
                    String unescapedParamName = Utils.removeLeadingSingleQuote(paramResult.name());
                    Codedata codedata = new Codedata("LISTENER_INIT_PARAM");
                    codedata.setOriginalName(paramResult.name());
                    Value.ValueBuilder valueBuilder = new Value.ValueBuilder();
                    valueBuilder.setMetadata(new MetaData(unescapedParamName, paramResult.description())).setCodedata(codedata).value(value).valueType("EXPRESSION").setPlaceholder(paramResult.defaultValue()).setValueTypeConstraint(paramResult.type().toString()).editable(true).isType(false).enabled(true).optional(paramResult.optional()).setAdvanced(paramResult.optional()).setTypeMembers(paramResult.typeMembers());
                    this.properties.put(unescapedParamName, valueBuilder.build());
                }
                for (i = paramCount; i < argCount; ++i) {
                    restArgs.add(Objects.requireNonNull(positionalArgs.poll()).toSourceCode());
                }
                String escapedParamName = CommonUtil.escapeReservedKeyword((String)((String)restParamSymbol.getName().get()));
                ParameterData restParamResult = funcParamMap.get(escapedParamName);
                funcParamMap.remove(restParamSymbol.getName().get());
                String unescapedParamName = Utils.removeLeadingSingleQuote(restParamResult.name());
                Codedata codedata = new Codedata("LISTENER_INIT_PARAM");
                codedata.setOriginalName(restParamResult.name());
                Value.ValueBuilder valueBuilder = new Value.ValueBuilder();
                valueBuilder.setMetadata(new MetaData(unescapedParamName, restParamResult.description())).setCodedata(codedata).value("[%s]".formatted(String.join((CharSequence)", ", restArgs))).valueType("EXPRESSION").setPlaceholder(restParamResult.defaultValue()).setValueTypeConstraint(restParamResult.type().toString()).editable(true).isType(false).enabled(true).optional(restParamResult.optional()).setAdvanced(restParamResult.optional()).setTypeMembers(restParamResult.typeMembers());
                this.properties.put(unescapedParamName, valueBuilder.build());
            }
            this.addRemainingParamsToPropertyMap(funcParamMap);
            return;
        }
        Optional paramsOptional = functionTypeSymbol.params();
        if (paramsOptional.isPresent()) {
            String value;
            ParameterData paramResult;
            String escapedParamName;
            List paramsList = (List)paramsOptional.get();
            int argCount = positionalArgs.size();
            for (int i = 0; i < paramsList.size(); ++i) {
                Value.ValueBuilder valueBuilder;
                Codedata codedata;
                Node paramValue;
                ParameterSymbol parameterSymbol = (ParameterSymbol)paramsList.get(i);
                escapedParamName = (String)parameterSymbol.getName().get();
                paramResult = funcParamMap.get(escapedParamName);
                if (paramResult == null) {
                    escapedParamName = CommonUtil.escapeReservedKeyword((String)((String)parameterSymbol.getName().get()));
                }
                paramResult = funcParamMap.get(escapedParamName);
                if (i < argCount) {
                    paramValue = positionalArgs.poll();
                } else {
                    paramValue = namedArgValueMap.get(paramResult.name());
                    namedArgValueMap.remove(paramResult.name());
                }
                if (paramResult.kind() == ParameterData.Kind.INCLUDED_RECORD) {
                    if (argumentNodes.size() > i && ((FunctionArgumentNode)argumentNodes.get(i)).kind() == SyntaxKind.NAMED_ARG) {
                        FunctionArgumentNode argNode = (FunctionArgumentNode)argumentNodes.get(i);
                        funcParamMap.remove(escapedParamName);
                        NamedArgumentNode namedArgumentNode = (NamedArgumentNode)argNode;
                        String argName = namedArgumentNode.argumentName().name().text();
                        if (argName.equals(paramResult.name())) {
                            paramResult = funcParamMap.get(escapedParamName);
                            value = paramValue != null ? paramValue.toSourceCode() : null;
                            unescapedParamName = Utils.removeLeadingSingleQuote(paramResult.name());
                            codedata = new Codedata("LISTENER_INIT_PARAM");
                            codedata.setOriginalName(paramResult.name());
                            valueBuilder = new Value.ValueBuilder();
                            valueBuilder.setMetadata(new MetaData(unescapedParamName, paramResult.description())).setCodedata(codedata).value(value).valueType("EXPRESSION").setPlaceholder(paramResult.defaultValue()).setValueTypeConstraint(paramResult.type().toString()).editable(true).isType(false).enabled(true).optional(paramResult.optional()).setAdvanced(paramResult.optional()).setTypeMembers(paramResult.typeMembers());
                            this.properties.put(unescapedParamName, valueBuilder.build());
                        } else if (funcParamMap.containsKey(argName)) {
                            paramResult = funcParamMap.get(argName);
                            funcParamMap.remove(argName);
                            if (paramValue == null) {
                                paramValue = namedArgValueMap.get(argName);
                                namedArgValueMap.remove(argName);
                            }
                            value = paramValue != null ? paramValue.toSourceCode() : "";
                            unescapedParamName = Utils.removeLeadingSingleQuote(paramResult.name());
                            codedata = new Codedata("LISTENER_INIT_PARAM");
                            codedata.setOriginalName(paramResult.name());
                            valueBuilder = new Value.ValueBuilder();
                            valueBuilder.setMetadata(new MetaData(unescapedParamName, paramResult.description())).setCodedata(codedata).value(value).valueType("EXPRESSION").setPlaceholder(paramResult.defaultValue()).setValueTypeConstraint(paramResult.type().toString()).editable(true).isType(false).enabled(true).optional(paramResult.optional()).setAdvanced(paramResult.optional()).setTypeMembers(paramResult.typeMembers());
                            this.properties.put(unescapedParamName, valueBuilder.build());
                        }
                    } else if (paramValue != null) {
                        String unescapedParamName = Utils.removeLeadingSingleQuote(paramResult.name());
                        funcParamMap.remove(escapedParamName);
                        value = paramValue.toSourceCode();
                        codedata = new Codedata("LISTENER_INIT_PARAM");
                        codedata.setOriginalName(paramResult.name());
                        valueBuilder = new Value.ValueBuilder();
                        valueBuilder.setMetadata(new MetaData(unescapedParamName, paramResult.description())).setCodedata(codedata).value(value).valueType("EXPRESSION").setPlaceholder(paramResult.defaultValue()).setValueTypeConstraint(paramResult.type().toString()).editable(true).isType(false).enabled(true).optional(paramResult.optional()).setAdvanced(paramResult.optional()).setTypeMembers(paramResult.typeMembers());
                        this.properties.put(unescapedParamName, valueBuilder.build());
                        return;
                    }
                }
                if (paramValue == null && paramResult.kind() == ParameterData.Kind.INCLUDED_RECORD) {
                    funcParamMap.remove(escapedParamName);
                    continue;
                }
                funcParamMap.remove(escapedParamName);
                String value2 = paramValue != null ? paramValue.toSourceCode() : "";
                String unescapedParamName = Utils.removeLeadingSingleQuote(paramResult.name());
                codedata = new Codedata("LISTENER_INIT_PARAM");
                codedata.setOriginalName(paramResult.name());
                valueBuilder = new Value.ValueBuilder();
                valueBuilder.setMetadata(new MetaData(unescapedParamName, paramResult.description())).setCodedata(codedata).value(value2).valueType("EXPRESSION").setPlaceholder(paramResult.defaultValue()).setValueTypeConstraint(paramResult.type().toString()).editable(true).isType(false).enabled(true).optional(paramResult.optional()).setAdvanced(paramResult.optional()).setTypeMembers(paramResult.typeMembers());
                this.properties.put(unescapedParamName, valueBuilder.build());
            }
            for (Map.Entry<String, Node> entry : namedArgValueMap.entrySet()) {
                escapedParamName = CommonUtil.escapeReservedKeyword((String)entry.getKey());
                if (!funcParamMap.containsKey(escapedParamName)) continue;
                paramResult = funcParamMap.remove(escapedParamName);
                String unescapedParamName = Utils.removeLeadingSingleQuote(paramResult.name());
                Node paramValue = entry.getValue();
                value = paramValue != null ? paramValue.toSourceCode() : "";
                Value.ValueBuilder valueBuilder = new Value.ValueBuilder();
                Codedata codedata = new Codedata("LISTENER_INIT_PARAM");
                codedata.setOriginalName(paramResult.name());
                valueBuilder.setMetadata(new MetaData(unescapedParamName, paramResult.description())).setCodedata(codedata).value(value).valueType("EXPRESSION").setPlaceholder(paramResult.defaultValue()).setValueTypeConstraint(paramResult.type().toString()).editable(true).isType(false).enabled(true).optional(paramResult.optional()).setAdvanced(paramResult.optional()).setTypeMembers(paramResult.typeMembers());
                this.properties.put(unescapedParamName, valueBuilder.build());
            }
            this.addRemainingParamsToPropertyMap(funcParamMap);
        }
    }

    private void addRemainingParamsToPropertyMap(Map<String, ParameterData> funcParamMap) {
        for (Map.Entry<String, ParameterData> entry : funcParamMap.entrySet()) {
            ParameterData paramResult = entry.getValue();
            if (paramResult.kind().equals((Object)ParameterData.Kind.PARAM_FOR_TYPE_INFER) || paramResult.kind().equals((Object)ParameterData.Kind.INCLUDED_RECORD)) continue;
            String unescapedParamName = Utils.removeLeadingSingleQuote(paramResult.name());
            Codedata codedata = new Codedata("LISTENER_INIT_PARAM");
            codedata.setOriginalName(paramResult.name());
            Value.ValueBuilder valueBuilder = new Value.ValueBuilder();
            valueBuilder.setMetadata(new MetaData(unescapedParamName, paramResult.description())).setCodedata(codedata).value("").valueType("EXPRESSION").setPlaceholder(paramResult.defaultValue()).setValueTypeConstraint(paramResult.type().toString()).editable(true).isType(false).enabled(true).optional(paramResult.optional()).setAdvanced(paramResult.optional()).setTypeMembers(paramResult.typeMembers());
            this.properties.put(unescapedParamName, valueBuilder.build());
        }
    }
}

