/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphqlmodelgenerator.core;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.graphqlmodelgenerator.core.InteractedComponentModelGenerator;
import io.ballerina.graphqlmodelgenerator.core.ServiceModelGenerator;
import io.ballerina.graphqlmodelgenerator.core.exception.GraphqlModelGenerationException;
import io.ballerina.graphqlmodelgenerator.core.model.GraphqlModel;
import io.ballerina.graphqlmodelgenerator.core.model.Service;
import io.ballerina.graphqlmodelgenerator.core.utils.CommonUtil;
import io.ballerina.graphqlmodelgenerator.core.utils.ModelGenerationUtils;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.compiler.Utils;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Path;
import org.eclipse.lsp4j.Range;

public class ModelGenerator {
    public GraphqlModel getGraphqlModel(Project project, LineRange position, SemanticModel semanticModel) throws GraphqlModelGenerationException {
        Document doc;
        Package packageName = project.currentPackage();
        if (project.kind().equals((Object)ProjectKind.BUILD_PROJECT)) {
            Path filePath = Path.of(position.fileName(), new String[0]);
            DocumentId docId = project.documentId(filePath);
            ModuleId moduleId = docId.moduleId();
            doc = project.currentPackage().module(moduleId).document(docId);
        } else {
            Module currentModule = packageName.getDefaultModule();
            DocumentId docId = (DocumentId)currentModule.documentIds().iterator().next();
            doc = currentModule.document(docId);
        }
        SyntaxTree syntaxTree = doc.syntaxTree();
        Range range = CommonUtil.toRange(position);
        NonTerminalNode node = CommonUtil.findSTNode(range, syntaxTree);
        if (node.kind() != SyntaxKind.SERVICE_DECLARATION && node.kind() != SyntaxKind.MODULE_VAR_DECL) {
            throw new GraphqlModelGenerationException("Provided ST node doesn't support Schema generation");
        }
        Schema schemaObject = Utils.getSchemaObject((Node)node, (SemanticModel)semanticModel, (Project)project);
        if (schemaObject.getTypes().isEmpty()) {
            throw new GraphqlModelGenerationException("Cannot generate complete Schema object for the provided ST node");
        }
        String serviceName = "";
        if (node.kind() == SyntaxKind.SERVICE_DECLARATION) {
            ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)node;
            serviceName = ModelGenerationUtils.getServiceBasePath(serviceDeclarationNode);
        } else if (node.kind() == SyntaxKind.MODULE_VAR_DECL) {
            ModuleVariableDeclarationNode moduleVarDclNode = (ModuleVariableDeclarationNode)node;
            serviceName = moduleVarDclNode.typedBindingPattern().bindingPattern().toSourceCode();
        }
        return this.constructGraphqlModel(schemaObject, serviceName, position, syntaxTree);
    }

    public GraphqlModel constructGraphqlModel(Schema schemaObj, String serviceName, LineRange nodeLocation, SyntaxTree syntaxTree) throws GraphqlModelGenerationException {
        try {
            ServiceModelGenerator serviceModelGenerator = new ServiceModelGenerator(schemaObj, serviceName, nodeLocation, syntaxTree);
            Service graphqlService = serviceModelGenerator.generate();
            InteractedComponentModelGenerator componentModelGenerator = new InteractedComponentModelGenerator(schemaObj, syntaxTree);
            componentModelGenerator.generate();
            return new GraphqlModel(graphqlService, componentModelGenerator.getRecords(), componentModelGenerator.getServiceClasses(), componentModelGenerator.getEnums(), componentModelGenerator.getUnions(), componentModelGenerator.getInterfaces(), componentModelGenerator.getHierarchicalResources());
        }
        catch (Exception e) {
            throw new GraphqlModelGenerationException(String.format("Issue when generating the GraphQL model from Schema : %s", e.getMessage()));
        }
    }
}

