/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphqlmodelgenerator.core.utils;

import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.stdlib.graphql.commons.types.Position;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import org.eclipse.lsp4j.Range;

public class CommonUtil {
    public static Range toRange(LineRange lineRange) {
        return new Range(CommonUtil.toPosition(lineRange.startLine()), CommonUtil.toPosition(lineRange.endLine()));
    }

    public static org.eclipse.lsp4j.Position toPosition(LinePosition linePosition) {
        return new org.eclipse.lsp4j.Position(linePosition.line(), linePosition.offset());
    }

    public static LineRange toLineRange(Position position) {
        return LineRange.from((String)position.getFilePath(), (LinePosition)LinePosition.from((int)position.getStartLine().getLine(), (int)position.getStartLine().getOffset()), (LinePosition)LinePosition.from((int)position.getEndLine().getLine(), (int)position.getEndLine().getOffset()));
    }

    public static NonTerminalNode findSTNode(Range range, SyntaxTree syntaxTree) {
        TextDocument textDocument = syntaxTree.textDocument();
        org.eclipse.lsp4j.Position rangeStart = range.getStart();
        org.eclipse.lsp4j.Position rangeEnd = range.getEnd();
        int start = textDocument.textPositionFrom(LinePosition.from((int)rangeStart.getLine(), (int)rangeStart.getCharacter()));
        int end = textDocument.textPositionFrom(LinePosition.from((int)rangeEnd.getLine(), (int)rangeEnd.getCharacter()));
        return ((ModulePartNode)syntaxTree.rootNode()).findNode(TextRange.from((int)start, (int)(end - start)), true);
    }
}

