/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli.handlers;

import io.ballerina.shell.cli.ShellExitException;
import io.ballerina.shell.cli.handlers.AbstractCommand;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CommandHandler {
    private static final String COMMAND_PREFIX = "/";
    private final Map<String, AbstractCommand> commands = new HashMap<String, AbstractCommand>();

    public void attach(String prefix, AbstractCommand command) {
        assert (prefix.startsWith(COMMAND_PREFIX));
        this.commands.put(prefix, command);
    }

    public boolean handle(String source) throws ShellExitException {
        String[] args;
        if (source.isBlank()) {
            return true;
        }
        if (source.startsWith(COMMAND_PREFIX) && this.commands.containsKey((args = source.split(" "))[0])) {
            String[] rest = Arrays.copyOfRange(args, 1, args.length);
            this.commands.get(args[0]).run(rest);
            return true;
        }
        return false;
    }
}

