/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli.jline.parser;

import io.ballerina.shell.cli.jline.parser.ParserState;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Set;

public class ParserStateMachine {
    private static final char BACKTICK = '`';
    private static final char OPEN_CURLY = '{';
    private static final char CLOSE_CURLY = '}';
    private static final char OPEN_PAREN = '(';
    private static final char CLOSE_PAREN = ')';
    private static final char OPEN_SQ_BR = '[';
    private static final char CLOSE_SQ_BR = ']';
    private static final char BACKWARD_SLASH = '\\';
    private static final char FORWARD_SLASH = '/';
    private static final char HASH = '#';
    private static final char DOLLAR = '$';
    private static final char DOUBLE_QUOTES = '\"';
    private static final char NEW_LINE = '\n';
    private static final char CARRIAGE_RETURN = '\r';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final Set<Character> CONTINUING_OPERATORS = Set.of(Character.valueOf(':'), Character.valueOf('@'), Character.valueOf('*'), Character.valueOf('%'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('<'), Character.valueOf('='), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('^'), Character.valueOf('!'), Character.valueOf(','));
    private static final Map<Character, Character> OPEN_BRACKETS = Map.of(Character.valueOf('}'), Character.valueOf('{'), Character.valueOf(')'), Character.valueOf('('), Character.valueOf(']'), Character.valueOf('['));
    private final Deque<Character> stack;
    private ParserState state = ParserState.NORMAL;

    public ParserStateMachine() {
        this.stack = new ArrayDeque<Character>();
    }

    public void feed(char character) {
        if (character == '\r') {
            return;
        }
        switch (this.state) {
            case NORMAL: 
            case AFTER_OPERATOR: {
                this.normalStateOrAfterOperator(character);
                return;
            }
            case AFTER_BACKWARD_SLASH: {
                this.afterBackwardSlashState();
                return;
            }
            case IN_DOUBLE_QUOTES: {
                this.inDoubleQuotesState(character);
                return;
            }
            case IN_DOUBLE_QUOTES_AFTER_BACKWARD_SLASH: {
                this.inDoubleQuotesAfterBackwardSlashState(character);
                return;
            }
            case IN_TEMPLATE: {
                this.inTemplateState(character);
                return;
            }
            case IN_TEMPLATE_AFTER_DOLLAR: {
                this.inTemplateAfterDollarState(character);
                return;
            }
            case AFTER_FORWARD_SLASH: {
                this.afterForwardSlashState(character);
                return;
            }
            case IN_COMMENT: {
                this.inCommentState(character);
                return;
            }
            case ERROR: {
                return;
            }
        }
        throw new IllegalStateException();
    }

    private void normalStateOrAfterOperator(char character) {
        assert (this.state == ParserState.NORMAL || this.state == ParserState.AFTER_OPERATOR);
        switch (character) {
            case '\t': 
            case '\n': 
            case ' ': {
                return;
            }
            case '(': 
            case '[': 
            case '{': {
                this.stack.push(Character.valueOf(character));
                break;
            }
            case ')': 
            case ']': 
            case '}': {
                if (!this.stack.isEmpty() && OPEN_BRACKETS.get(Character.valueOf(character)).equals(this.stack.peek())) {
                    this.stack.pop();
                    if (this.stack.isEmpty() || this.stack.peek().charValue() != '`') break;
                    this.state = ParserState.IN_TEMPLATE;
                    break;
                }
                this.state = ParserState.ERROR;
                break;
            }
            case '\\': {
                this.state = ParserState.AFTER_BACKWARD_SLASH;
                break;
            }
            case '\"': {
                this.state = ParserState.IN_DOUBLE_QUOTES;
                break;
            }
            case '`': {
                this.stack.push(Character.valueOf('`'));
                this.state = ParserState.IN_TEMPLATE;
                break;
            }
            case '/': {
                this.state = ParserState.AFTER_FORWARD_SLASH;
                break;
            }
            case '#': {
                this.state = ParserState.IN_COMMENT;
                break;
            }
        }
        if (this.state == ParserState.NORMAL || this.state == ParserState.AFTER_OPERATOR) {
            this.state = CONTINUING_OPERATORS.contains(Character.valueOf(character)) ? ParserState.AFTER_OPERATOR : ParserState.NORMAL;
        }
    }

    private void afterBackwardSlashState() {
        assert (this.state == ParserState.AFTER_BACKWARD_SLASH);
        this.state = ParserState.NORMAL;
    }

    private void inDoubleQuotesState(char character) {
        assert (this.state == ParserState.IN_DOUBLE_QUOTES);
        switch (character) {
            case '\\': {
                this.state = ParserState.IN_DOUBLE_QUOTES_AFTER_BACKWARD_SLASH;
                break;
            }
            case '\"': {
                this.state = ParserState.NORMAL;
                break;
            }
            case '\n': {
                this.state = ParserState.ERROR;
                break;
            }
        }
    }

    private void inDoubleQuotesAfterBackwardSlashState(char character) {
        assert (this.state == ParserState.IN_DOUBLE_QUOTES_AFTER_BACKWARD_SLASH);
        if (character == '\n') {
            this.state = ParserState.ERROR;
            return;
        }
        this.state = ParserState.IN_DOUBLE_QUOTES;
    }

    private void inTemplateState(char character) {
        assert (this.state == ParserState.IN_TEMPLATE);
        switch (character) {
            case '$': {
                this.state = ParserState.IN_TEMPLATE_AFTER_DOLLAR;
                break;
            }
            case '`': {
                if (!this.stack.isEmpty() && this.stack.peek().charValue() == '`') {
                    this.state = ParserState.NORMAL;
                    this.stack.pop();
                    break;
                }
                this.state = ParserState.ERROR;
                break;
            }
        }
    }

    private void inTemplateAfterDollarState(char character) {
        assert (this.state == ParserState.IN_TEMPLATE_AFTER_DOLLAR);
        if (character == '{') {
            this.stack.push(Character.valueOf('{'));
            this.state = ParserState.NORMAL;
        } else {
            this.state = ParserState.IN_TEMPLATE;
        }
    }

    private void afterForwardSlashState(char character) {
        assert (this.state == ParserState.AFTER_FORWARD_SLASH);
        this.state = character == '/' ? ParserState.IN_COMMENT : ParserState.NORMAL;
    }

    private void inCommentState(char character) {
        assert (this.state == ParserState.IN_COMMENT);
        if (character == '\n') {
            this.state = ParserState.NORMAL;
        }
    }

    public ParserState getState() {
        return this.state;
    }

    public boolean isIncomplete() {
        if (this.state == ParserState.ERROR) {
            return false;
        }
        if (this.state == ParserState.AFTER_FORWARD_SLASH || this.state == ParserState.AFTER_OPERATOR) {
            return true;
        }
        return !this.stack.isEmpty();
    }
}

