/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;

public final class FileUtils {
    private static final String SPECIAL_DELIMITER = "\\A";

    private FileUtils() {
    }

    public static String readResource(String path) {
        ClassLoader classLoader = FileUtils.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(path);
        Objects.requireNonNull(inputStream, "File does not exist: " + path);
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        Scanner scanner = new Scanner(reader).useDelimiter(SPECIAL_DELIMITER);
        return scanner.hasNext() ? scanner.next() : "";
    }

    public static List<String> readKeywords(String file) {
        String content = FileUtils.readResource(file);
        Scanner scanner = new Scanner(content).useDelimiter(",");
        ArrayList<String> keywords = new ArrayList<String>();
        while (scanner.hasNext()) {
            String keyword = scanner.next().trim();
            if (keyword.isBlank()) continue;
            keywords.add(keyword);
        }
        return keywords;
    }

    public static String readFromUrl(String link) throws IOException {
        URL url = new URL(link);
        InputStream inputStream = url.openStream();
        Scanner scanner = new Scanner(inputStream, Charset.defaultCharset()).useDelimiter(SPECIAL_DELIMITER);
        return scanner.hasNext() ? scanner.next() : "";
    }
}

