/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.cache.compiler;

import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.UnaryExpressionNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.cache.compiler.DiagnosticsCodes;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.Optional;

public class CacheConfigValidator
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    public void perform(SyntaxNodeAnalysisContext ctx) {
        block6: {
            ExpressionNode initializer;
            block7: {
                List diagnostics = ctx.semanticModel().diagnostics();
                for (Diagnostic diagnostic : diagnostics) {
                    if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
                    return;
                }
                Optional varSymOptional = ctx.semanticModel().symbol(ctx.node());
                if (!varSymOptional.isPresent()) break block6;
                TypeSymbol typeSymbol = ((VariableSymbol)varSymOptional.get()).typeDescriptor();
                if (!this.isCacheConfigVariable(typeSymbol)) {
                    return;
                }
                Optional optionalInitializer = ctx.node() instanceof VariableDeclarationNode ? ((VariableDeclarationNode)ctx.node()).initializer() : ((ModuleVariableDeclarationNode)ctx.node()).initializer();
                if (optionalInitializer.isEmpty()) {
                    return;
                }
                initializer = (ExpressionNode)optionalInitializer.get();
                if (!(initializer instanceof ImplicitNewExpressionNode)) break block7;
                Optional parenthesizedArgList = ((ImplicitNewExpressionNode)initializer).parenthesizedArgList();
                if (!parenthesizedArgList.isPresent()) break block6;
                SeparatedNodeList fields = ((ParenthesizedArgList)parenthesizedArgList.get()).arguments();
                for (FunctionArgumentNode field : fields) {
                    if (!(field instanceof NamedArgumentNode)) continue;
                    NamedArgumentNode fieldNode = (NamedArgumentNode)field;
                    this.validateConfig(fieldNode.argumentName().toSourceCode().trim(), fieldNode.expression().toSourceCode().trim(), ctx, (Location)field.location());
                }
                break block6;
            }
            if (initializer instanceof MappingConstructorExpressionNode) {
                SeparatedNodeList fields = ((MappingConstructorExpressionNode)initializer).fields();
                for (MappingFieldNode field : fields) {
                    ExpressionNode valueNode;
                    String value;
                    SpecificFieldNode fieldNode = (SpecificFieldNode)field;
                    String name = fieldNode.fieldName().toString().trim().replaceAll("\"|\\n", "");
                    Optional expressionNode = fieldNode.valueExpr();
                    if (!expressionNode.isPresent() || (value = this.getTerminalNodeValue((Node)(valueNode = (ExpressionNode)expressionNode.get()), ctx)) == null) continue;
                    this.validateConfig(name, value, ctx, (Location)valueNode.location());
                }
            }
        }
    }

    private String getTerminalNodeValue(Node valueNode, SyntaxNodeAnalysisContext ctx) {
        Object value = null;
        if (valueNode instanceof BasicLiteralNode) {
            value = ((BasicLiteralNode)valueNode).literalToken().text();
        } else if (valueNode instanceof QualifiedNameReferenceNode) {
            Object t = ctx.semanticModel().symbol(valueNode).get();
            if (t instanceof ConstantSymbol) {
                ConstantSymbol constantSymbol = (ConstantSymbol)t;
                value = constantSymbol.constValue().toString();
            } else {
                QualifiedNameReferenceNode qualifiedNameReferenceNode = (QualifiedNameReferenceNode)valueNode;
                value = qualifiedNameReferenceNode.toString();
            }
        } else if (valueNode instanceof UnaryExpressionNode) {
            UnaryExpressionNode unaryExpressionNode = (UnaryExpressionNode)valueNode;
            value = String.valueOf(unaryExpressionNode.unaryOperator()) + ((BasicLiteralNode)unaryExpressionNode.expression()).literalToken().text();
        }
        if (value != null) {
            return ((String)value).replaceAll("\"|\\n", "");
        }
        return null;
    }

    private boolean isCacheConfigVariable(TypeSymbol type) {
        if (type.typeKind() == TypeDescKind.UNION) {
            return ((UnionTypeSymbol)type).memberTypeDescriptors().stream().filter(typeDescriptor -> typeDescriptor instanceof TypeReferenceTypeSymbol).map(typeReferenceTypeSymbol -> (TypeReferenceTypeSymbol)typeReferenceTypeSymbol).anyMatch(this::isCacheConfigVariable);
        }
        if (type.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return this.isCacheConfigVariable((TypeReferenceTypeSymbol)type);
        }
        return false;
    }

    private boolean isCacheConfigVariable(TypeReferenceTypeSymbol typeSymbol) {
        TypeDescKind typeDescKind = typeSymbol.typeDescriptor().typeKind();
        Optional module = typeSymbol.getModule();
        if (module.isPresent()) {
            ModuleSymbol moduleSymbol = (ModuleSymbol)module.get();
            Optional name = moduleSymbol.getName();
            Optional typeName = typeSymbol.definition().getName();
            if (name.isPresent() && typeName.isPresent()) {
                if (typeDescKind == TypeDescKind.RECORD) {
                    return "cache".equals(name.get()) && "ballerina".equals(moduleSymbol.id().orgName()) && ((String)typeName.get()).equals("CacheConfig");
                }
                if (typeDescKind == TypeDescKind.OBJECT) {
                    return "cache".equals(name.get()) && "ballerina".equals(moduleSymbol.id().orgName()) && ((String)typeName.get()).equalsIgnoreCase("cache");
                }
                return false;
            }
        }
        return false;
    }

    private void validateConfig(String name, String value, SyntaxNodeAnalysisContext ctx, Location location) {
        try {
            switch (name) {
                case "capacity": {
                    int maxCapacity = Integer.parseInt(value);
                    if (maxCapacity > 0) break;
                    this.reportDiagnostic(ctx, location, DiagnosticsCodes.CACHE_101.getErrorCode(), DiagnosticsCodes.CACHE_101.getError(), DiagnosticsCodes.CACHE_101.getSeverity());
                    break;
                }
                case "evictionFactor": {
                    float evictionFactor = Float.parseFloat(value);
                    if (!(evictionFactor < 0.0f) && !(evictionFactor >= 1.0f)) break;
                    this.reportDiagnostic(ctx, location, DiagnosticsCodes.CACHE_102.getErrorCode(), DiagnosticsCodes.CACHE_102.getError(), DiagnosticsCodes.CACHE_102.getSeverity());
                    break;
                }
                case "defaultMaxAge": {
                    float defaultMaxAge = Float.parseFloat(value);
                    if (defaultMaxAge == -1.0f || !(defaultMaxAge < 0.0f)) break;
                    this.reportDiagnostic(ctx, location, DiagnosticsCodes.CACHE_103.getErrorCode(), DiagnosticsCodes.CACHE_103.getError(), DiagnosticsCodes.CACHE_103.getSeverity());
                    break;
                }
                case "cleanupInterval": {
                    float cleanUpInterval = Float.parseFloat(value);
                    if (!(cleanUpInterval <= 0.0f)) break;
                    this.reportDiagnostic(ctx, location, DiagnosticsCodes.CACHE_104.getErrorCode(), DiagnosticsCodes.CACHE_104.getError(), DiagnosticsCodes.CACHE_104.getSeverity());
                    break;
                }
                case "evictionPolicy": {
                    if (value.equals("cache:LRU")) break;
                    this.reportDiagnostic(ctx, location, DiagnosticsCodes.CACHE_105.getErrorCode(), DiagnosticsCodes.CACHE_105.getError(), DiagnosticsCodes.CACHE_105.getSeverity());
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void reportDiagnostic(SyntaxNodeAnalysisContext ctx, Location location, String code, String message, DiagnosticSeverity diagnosticSeverity) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(code, message, diagnosticSeverity);
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]));
    }
}

