/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.core;

import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.projects.Module;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.toml.api.Toml;
import io.ballerina.toml.validator.TomlValidator;
import io.ballerina.toml.validator.schema.Schema;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.text.LineRange;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.options.FormatSection;
import org.ballerinalang.formatter.core.options.FormattingOptions;
import org.ballerinalang.formatter.core.options.WrappingFormattingOptions;

public final class FormatterUtils {
    static final String NEWLINE_SYMBOL = System.getProperty("line.separator");
    private static final String FORMAT_FILE_FIELD = "configPath";
    private static final String FORMAT_OPTION_FILE_EXT = ".toml";
    private static final String DEFAULT_FORMAT_OPTION_FILE = "Format.toml";
    private static final String TARGET_DIR = "target";
    private static final String FORMAT = "format";
    private static final String FORMAT_TOML_SCHEMA = "format-toml-schema.json";
    private static final PrintStream errStream = System.err;
    public static final ResourceBundle DEFAULTS = ResourceBundle.getBundle("formatter", Locale.getDefault());

    private FormatterUtils() {
    }

    public static FormattingOptions buildFormattingOptions(BuildProject project) throws FormatterException {
        return FormattingOptions.builder().build(project.sourceRoot(), FormatterUtils.loadFormatSection(project.currentPackage().manifest()));
    }

    public static boolean isBuildProject(Optional<Module> module) {
        return module.isPresent() && module.get().project().kind() != ProjectKind.SINGLE_FILE_PROJECT;
    }

    public static boolean getDefaultBoolean(FormatSection section, String key) {
        return Boolean.parseBoolean(FormatterUtils.getDefaultString(section, key));
    }

    public static int getDefaultInt(FormatSection section, String key) {
        return Integer.parseInt(FormatterUtils.getDefaultString(section, key));
    }

    public static String getDefaultString(FormatSection section, String key) {
        return DEFAULTS.getString(section.getStringValue() + "." + key);
    }

    public static Object loadFormatSection(PackageManifest manifest) {
        return manifest.getValue(FORMAT);
    }

    public static Optional<String> getFormattingFilePath(Object formatSection, String root) {
        Object path;
        if (formatSection != null && (path = ((Map)formatSection).get(FORMAT_FILE_FIELD)) != null) {
            String str = path.toString();
            if (str.endsWith(FORMAT_OPTION_FILE_EXT)) {
                return Optional.of(str);
            }
            return Optional.of(Path.of(str, DEFAULT_FORMAT_OPTION_FILE).toString());
        }
        Path defaultFile = Path.of(root, DEFAULT_FORMAT_OPTION_FILE);
        return Files.exists(defaultFile, new LinkOption[0]) ? Optional.of(defaultFile.toString()) : Optional.empty();
    }

    public static Map<String, Object> getFormattingConfigurations(Path root, String configurationFilePath) throws FormatterException {
        String content;
        Optional<Path> absPath;
        Optional<Path> path = FormatterUtils.convertConfigurationPath(configurationFilePath);
        Optional<Path> optional = absPath = path.isEmpty() || path.get().isAbsolute() || !root.isAbsolute() ? path : Optional.of(root.resolve(configurationFilePath));
        if (FormatterUtils.isLocalFile(absPath)) {
            try {
                content = Files.readString(absPath.get(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new FormatterException("failed to retrieve local formatting configuration file: " + configurationFilePath);
            }
        } else {
            content = FormatterUtils.readRemoteFormatFile(root, configurationFilePath);
        }
        return FormatterUtils.parseConfigurationToml(TomlDocument.from((String)configurationFilePath, (String)content));
    }

    private static Optional<Path> convertConfigurationPath(String path) {
        try {
            return Optional.of(Path.of(path, new String[0]));
        }
        catch (InvalidPathException ex) {
            return Optional.empty();
        }
    }

    private static boolean isLocalFile(Optional<Path> path) throws InvalidPathException {
        return path.isPresent() && new File(path.get().toString()).exists();
    }

    private static String readRemoteFormatFile(Path root, String fileUrl) throws FormatterException {
        Path cachePath = root.resolve(TARGET_DIR).resolve(FORMAT).resolve(DEFAULT_FORMAT_OPTION_FILE);
        if (Files.exists(cachePath, new LinkOption[0])) {
            try {
                return Files.readString(cachePath, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new FormatterException("failed to read cached formatting configuration file");
            }
        }
        StringBuilder fileContent = new StringBuilder();
        try {
            URL url = new URL(fileUrl);
            URLConnection connection = url.openConnection();
            if (!(connection instanceof HttpURLConnection)) {
                throw new FormatterException("configuration file remote url is not an HTTP url: " + fileUrl);
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode != 200) {
                httpURLConnection.disconnect();
                throw new FormatterException("failed to retrieve remote file. HTTP response code: " + responseCode);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    fileContent.append(line).append(NEWLINE_SYMBOL);
                }
            }
            httpURLConnection.disconnect();
        }
        catch (IOException e) {
            throw new FormatterException("failed to retrieve formatting configuration file: " + fileUrl);
        }
        FormatterUtils.cacheRemoteConfigurationFile(root, fileContent.toString());
        return fileContent.toString();
    }

    private static void cacheRemoteConfigurationFile(Path root, String content) throws FormatterException {
        Path targetDir = root.resolve(TARGET_DIR);
        if (!Files.exists(targetDir, new LinkOption[0])) {
            return;
        }
        Path formatDir = targetDir.resolve(FORMAT);
        if (!Files.exists(formatDir, new LinkOption[0])) {
            try {
                Files.createDirectories(formatDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new FormatterException("failed to create format configuration cache directory");
            }
        }
        String filePath = formatDir.resolve(DEFAULT_FORMAT_OPTION_FILE).toString();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath, StandardCharsets.UTF_8));){
            writer.write(content);
        }
        catch (IOException e) {
            throw new FormatterException("failed to write format configuration cache file");
        }
    }

    public static Map<String, Object> parseConfigurationToml(TomlDocument document) throws FormatterException {
        TomlValidator formatTomlValidator;
        Toml toml = document.toml();
        if (toml.rootNode().entries().isEmpty()) {
            return new HashMap<String, Object>();
        }
        try {
            formatTomlValidator = new TomlValidator(Schema.from((String)FileUtils.readFileAsString((String)FORMAT_TOML_SCHEMA)));
        }
        catch (IOException e) {
            throw new ProjectException("Failed to read the Format.toml validator schema file.");
        }
        formatTomlValidator.validate(toml);
        List diagnostics = toml.diagnostics();
        ArrayList<String> errMessages = new ArrayList<String>();
        for (Diagnostic diagnostic : diagnostics) {
            if (!diagnostic.diagnosticInfo().severity().equals((Object)DiagnosticSeverity.ERROR)) continue;
            errMessages.add(diagnostic.message());
        }
        if (!errMessages.isEmpty()) {
            throw new FormatterException("invalid formatting configuration file" + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), errMessages));
        }
        return toml.toMap();
    }

    static boolean isInlineRange(Node node, LineRange lineRange) {
        if (lineRange == null) {
            return true;
        }
        int nodeStartLine = node.lineRange().startLine().line();
        int nodeStartColumn = node.lineRange().startLine().offset();
        int nodeEndLine = node.lineRange().endLine().line();
        int nodeEndColumn = node.lineRange().endLine().offset();
        int rangeStartLine = lineRange.startLine().line();
        int rangeStartColumn = lineRange.startLine().offset();
        int rangeEndLine = lineRange.endLine().line();
        int rangeEndColumn = lineRange.endLine().offset();
        if (nodeEndLine < rangeStartLine) {
            return false;
        }
        if (nodeEndLine == rangeStartLine) {
            return nodeEndColumn > rangeStartColumn;
        }
        if (nodeStartLine > rangeEndLine) {
            return false;
        }
        if (nodeStartLine == rangeEndLine) {
            return nodeStartColumn < rangeEndColumn;
        }
        return true;
    }

    static void sortImportDeclarations(List<ImportDeclarationNode> importDeclarationNodes) {
        importDeclarationNodes.sort((node1, node2) -> new CompareToBuilder().append((Object)(node1.orgName().isPresent() ? ((ImportOrgNameNode)node1.orgName().get()).orgName().text() : ""), (Object)(node2.orgName().isPresent() ? ((ImportOrgNameNode)node2.orgName().get()).orgName().text() : "")).append((Object)node1.moduleName().stream().map(node -> node.toString().trim()).collect(Collectors.joining()), (Object)node2.moduleName().stream().map(node -> node.toString().trim()).collect(Collectors.joining())).toComparison());
    }

    static void swapLeadingMinutiae(ImportDeclarationNode firstImportNode, List<ImportDeclarationNode> importNodes) {
        int prevFirstImportIndex = -1;
        String firstImportOrgName = firstImportNode.orgName().map(Node::toSourceCode).orElse("");
        String firstImportModuleName = FormatterUtils.getImportModuleName(firstImportNode);
        for (int i = 0; i < importNodes.size(); ++i) {
            if (!FormatterUtils.doesImportMatch(firstImportOrgName, firstImportModuleName, importNodes.get(i))) continue;
            prevFirstImportIndex = i;
            break;
        }
        if (prevFirstImportIndex == 0) {
            return;
        }
        ImportDeclarationNode prevFirstImportNode = importNodes.get(prevFirstImportIndex);
        MinutiaeList prevFirstLeadingMinutiae = prevFirstImportNode.leadingMinutiae();
        MinutiaeList prevFirstNewLeadingMinutiae = NodeFactory.createEmptyMinutiaeList();
        Minutiae prevFirstMinutiae = prevFirstLeadingMinutiae.get(0);
        if (prevFirstMinutiae.kind() == SyntaxKind.END_OF_LINE_MINUTIAE) {
            prevFirstNewLeadingMinutiae = prevFirstNewLeadingMinutiae.add(prevFirstMinutiae);
            prevFirstLeadingMinutiae = prevFirstLeadingMinutiae.remove(0);
        }
        importNodes.set(prevFirstImportIndex, FormatterUtils.modifyImportDeclLeadingMinutiae(prevFirstImportNode, prevFirstNewLeadingMinutiae));
        if (!FormatterUtils.hasEmptyLineAtEnd(prevFirstLeadingMinutiae)) {
            prevFirstLeadingMinutiae = prevFirstLeadingMinutiae.add(NodeFactory.createEndOfLineMinutiae((String)System.lineSeparator()));
        }
        ImportDeclarationNode newFirstImportNode = importNodes.get(0);
        MinutiaeList newFirstLeadingMinutiae = newFirstImportNode.importKeyword().leadingMinutiae();
        for (int i = 0; i < newFirstLeadingMinutiae.size(); ++i) {
            Minutiae minutiae = newFirstLeadingMinutiae.get(i);
            if (i == 0 && minutiae.kind() == SyntaxKind.END_OF_LINE_MINUTIAE) continue;
            prevFirstLeadingMinutiae = prevFirstLeadingMinutiae.add(minutiae);
        }
        importNodes.set(0, FormatterUtils.modifyImportDeclLeadingMinutiae(newFirstImportNode, prevFirstLeadingMinutiae));
    }

    private static ImportDeclarationNode modifyImportDeclLeadingMinutiae(ImportDeclarationNode importDecl, MinutiaeList leadingMinutiae) {
        Token importToken = importDecl.importKeyword();
        Token modifiedImportToken = importToken.modify(leadingMinutiae, importToken.trailingMinutiae());
        return importDecl.modify().withImportKeyword(modifiedImportToken).apply();
    }

    private static boolean doesImportMatch(String orgName, String moduleName, ImportDeclarationNode importDeclNode) {
        String importDeclOrgName = importDeclNode.orgName().map(Node::toSourceCode).orElse("");
        return orgName.equals(importDeclOrgName) && moduleName.equals(FormatterUtils.getImportModuleName(importDeclNode));
    }

    private static String getImportModuleName(ImportDeclarationNode importDeclarationNode) {
        return importDeclarationNode.moduleName().stream().map(Node::toSourceCode).collect(Collectors.joining("."));
    }

    private static boolean hasEmptyLineAtEnd(MinutiaeList minutiaeList) {
        int size = minutiaeList.size();
        return minutiaeList.get(size - 1).kind() == SyntaxKind.END_OF_LINE_MINUTIAE && minutiaeList.get(size - 2).kind() == SyntaxKind.END_OF_LINE_MINUTIAE;
    }

    static int openBraceTrailingNLs(WrappingFormattingOptions options, Node node) {
        LineRange lineRange = node.lineRange();
        if (lineRange.startLine().line() != lineRange.endLine().line()) {
            return 1;
        }
        boolean isParentAFunction = FormatterUtils.isFunctionNode((Node)node.parent());
        if (options.isSimpleBlocksInOneLine() && !isParentAFunction) {
            return 0;
        }
        return options.isSimpleFunctionsInOneLine() && isParentAFunction ? 0 : 1;
    }

    private static boolean isFunctionNode(Node node) {
        return switch (node.kind()) {
            case SyntaxKind.FUNCTION_DEFINITION, SyntaxKind.METHOD_DECLARATION, SyntaxKind.OBJECT_METHOD_DEFINITION, SyntaxKind.RESOURCE_ACCESSOR_DEFINITION -> true;
            default -> false;
        };
    }

    static int getConstDefWidth(ConstantDeclarationNode node) {
        int size = node.visibilityQualifier().isPresent() ? ((Token)node.visibilityQualifier().get()).text().length() : 0;
        size += node.constKeyword().text().length();
        size += node.typeDescriptor().isPresent() ? ((TypeDescriptorNode)node.typeDescriptor().get()).toSourceCode().length() : 0;
        return size += node.variableName().text().length();
    }
}

