/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.cmd;

import io.ballerina.openapi.cmd.SubCmdBase;
import io.ballerina.openapi.core.generators.common.OASModifier;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import picocli.CommandLine;

@CommandLine.Command(name="align", description={"Align the OpenAPI definition by generating Ballerina friendly type schema names and Ballerina type name extensions."})
public class Align
extends SubCmdBase {
    public static final String INVALID_ALIGNMENT_OPTIONS = "ERROR: Invalid alignment type '%s' provided. The available options are: %s";
    private static final String INFO_MSG_PREFIX = "Aligned";
    public static final String NAME = "name";
    public static final String DOC = "doc";
    public static final String BASEPATH = "basepath";
    public static final List<String> DEFAULT_ALIGNMENT_TYPES = List.of("name", "doc", "basepath");
    private List<String> alignmentTypes = new ArrayList<String>(List.of("name", "doc", "basepath"));
    @CommandLine.Option(names={"--include"}, description={"Alignment types to be included. The available options are: name, doc, basepath."})
    public String includedAlignments;
    @CommandLine.Option(names={"--exclude"}, description={"Alignment types to be excluded. The available options are: name, doc, basepath."})
    public String excludedAlignments;

    public Align() {
        super(SubCmdBase.CommandType.ALIGN, INFO_MSG_PREFIX);
    }

    public Align(PrintStream errorStream, boolean exitWhenFinish) {
        super(SubCmdBase.CommandType.ALIGN, INFO_MSG_PREFIX, errorStream, exitWhenFinish);
    }

    @Override
    public void execute() {
        this.setAlignmentTypes();
        super.execute();
    }

    private void setAlignmentTypes() {
        List<String> validatedIncludedAlignments = this.getValidatedAlignmentTypes(this.includedAlignments);
        List<String> validatedExcludedAlignments = this.getValidatedAlignmentTypes(this.excludedAlignments);
        if (!validatedIncludedAlignments.isEmpty()) {
            this.alignmentTypes = validatedIncludedAlignments;
        } else if (!validatedExcludedAlignments.isEmpty()) {
            this.alignmentTypes.removeAll(validatedExcludedAlignments);
        }
    }

    private List<String> getValidatedAlignmentTypes(String alignmentTypes) {
        if (Objects.isNull(alignmentTypes) || alignmentTypes.isEmpty()) {
            return Collections.emptyList();
        }
        String[] alignmentTypesList = alignmentTypes.split(",");
        ArrayList<String> validatedAlignmentTypes = new ArrayList<String>();
        for (String alignmentType : alignmentTypesList) {
            if (DEFAULT_ALIGNMENT_TYPES.contains(alignmentType)) {
                validatedAlignmentTypes.add(alignmentType);
                continue;
            }
            this.printError(INVALID_ALIGNMENT_OPTIONS.formatted(alignmentType, DEFAULT_ALIGNMENT_TYPES));
        }
        return validatedAlignmentTypes;
    }

    @Override
    public String getDefaultFileName() {
        return "aligned_ballerina_openapi";
    }

    @Override
    public Optional<OpenAPI> generate(String openAPIFileContent) {
        Optional<OpenAPI> filteredOpenAPI = this.getFilteredOpenAPI(openAPIFileContent);
        return filteredOpenAPI.flatMap(this::alignOpenAPI);
    }

    private Optional<OpenAPI> alignOpenAPI(OpenAPI openAPI) {
        try {
            return Optional.of(new OASModifier().modify(openAPI, this.alignmentTypes));
        }
        catch (BallerinaOpenApiException exp) {
            this.printError("ERROR: %s".formatted(exp.getMessage()));
            return Optional.empty();
        }
    }
}

