/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.cmd;

import io.ballerina.openapi.cmd.SubCmdBase;
import io.ballerina.openapi.core.generators.common.OASModifier;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import picocli.CommandLine;

@CommandLine.Command(name="flatten", description={"Flatten the OpenAPI definition by moving all the inline schemas to the \"#/components/schemas\" section."})
public class Flatten
extends SubCmdBase {
    private static final String ERROR_OCCURRED_WHILE_GENERATING_SCHEMA_NAMES = "ERROR: error occurred while generating schema names";
    private static final String INFO_MSG_PREFIX = "Flattened";

    public Flatten() {
        super(SubCmdBase.CommandType.FLATTEN, INFO_MSG_PREFIX);
    }

    public Flatten(PrintStream errorStream, boolean exitWhenFinish) {
        super(SubCmdBase.CommandType.FLATTEN, INFO_MSG_PREFIX, errorStream, exitWhenFinish);
    }

    @Override
    public String getDefaultFileName() {
        return "flattened_openapi";
    }

    @Override
    public Optional<OpenAPI> generate(String openAPIFileContent) {
        Optional<OpenAPI> filteredOpenAPI = this.getFilteredOpenAPI(openAPIFileContent);
        if (filteredOpenAPI.isEmpty()) {
            return Optional.empty();
        }
        OpenAPI openAPI = filteredOpenAPI.get();
        Components components = openAPI.getComponents();
        ArrayList existingComponentNames = Objects.nonNull(components) && Objects.nonNull(components.getSchemas()) ? new ArrayList(components.getSchemas().keySet()) : new ArrayList();
        return this.getFlattenOpenAPI(openAPI).flatMap(flattenOpenAPI -> this.sanitizeGeneratedFlattenNames((OpenAPI)flattenOpenAPI, existingComponentNames));
    }

    private Optional<OpenAPI> sanitizeGeneratedFlattenNames(OpenAPI openAPI, List<String> existingComponentNames) {
        Map<String, String> proposedNameMapping = this.getProposedNameMapping(openAPI, existingComponentNames);
        if (proposedNameMapping.isEmpty()) {
            return Optional.of(openAPI);
        }
        SwaggerParseResult parserResult = OASModifier.getOASWithSchemaNameModification((OpenAPI)openAPI, proposedNameMapping);
        if (Objects.isNull(openAPI = parserResult.getOpenAPI())) {
            this.printError(ERROR_OCCURRED_WHILE_GENERATING_SCHEMA_NAMES);
            if (!parserResult.getMessages().isEmpty()) {
                this.printError("found the following parser diagnostic messages:");
                parserResult.getMessages().forEach(this::printError);
            }
            return Optional.empty();
        }
        return Optional.of(openAPI);
    }

    public Map<String, String> getProposedNameMapping(OpenAPI openapi, List<String> existingComponentNames) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        if (Objects.isNull(openapi.getComponents())) {
            return Collections.emptyMap();
        }
        Components components = openapi.getComponents();
        Map schemas = components.getSchemas();
        if (Objects.isNull(schemas)) {
            return Collections.emptyMap();
        }
        for (Map.Entry schemaEntry : schemas.entrySet()) {
            String modifiedName;
            if (existingComponentNames.contains(schemaEntry.getKey()) || (modifiedName = OASModifier.getValidNameForType((String)((String)schemaEntry.getKey()))).equals(schemaEntry.getKey())) continue;
            nameMap.put((String)schemaEntry.getKey(), modifiedName);
        }
        return OASModifier.getResolvedNameMapping(nameMap);
    }
}

