/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.openapi.cmd.Add;
import io.ballerina.openapi.cmd.Align;
import io.ballerina.openapi.cmd.BallerinaCodeGenerator;
import io.ballerina.openapi.cmd.BaseCmd;
import io.ballerina.openapi.cmd.CmdConstants;
import io.ballerina.openapi.cmd.CmdUtils;
import io.ballerina.openapi.cmd.Flatten;
import io.ballerina.openapi.cmd.OASContractGenerator;
import io.ballerina.openapi.cmd.OpenAPIDiagnostic;
import io.ballerina.openapi.core.generators.client.exception.ClientException;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.common.model.Filter;
import io.ballerina.openapi.core.generators.type.exception.OASTypeGenException;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.Project;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.toml.syntax.tree.AbstractNodeFactory;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.IdentifierToken;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeList;
import io.ballerina.toml.syntax.tree.SyntaxTree;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.validator.SampleNodeGenerator;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.ballerinalang.formatter.core.FormatterException;
import picocli.CommandLine;

@CommandLine.Command(name="openapi", description={"Generate the Ballerina sources for a given OpenAPI definition and vice versa."}, subcommands={Add.class, Flatten.class, Align.class})
public class OpenApiCmd
implements BLauncherCmd {
    private static final String CMD_NAME = "openapi";
    private PrintStream outStream;
    private Path executionPath = Paths.get(System.getProperty("user.dir"), new String[0]);
    private Path targetOutputPath;
    private boolean exitWhenFinish;
    private boolean clientResourceMode;
    private boolean statusCodeBinding;
    private Path ballerinaTomlPath;
    private CmdConstants.Mode mode = CmdConstants.Mode.BOTH_SERVICE_CLIENT;
    @CommandLine.Mixin
    private BaseCmd baseCmd = new BaseCmd();
    @CommandLine.Option(names={"-o", "--output"}, description={"Location of the generated Ballerina service, client and model files."})
    private String outputPath;
    @CommandLine.Option(names={"-s", "--service"}, description={"Service name that need to documented as openapi contract"})
    private String service;
    @CommandLine.Option(names={"--service-name"}, description={"Service name for generated files"})
    private String generatedServiceName;
    @CommandLine.Option(names={"--json"}, description={"Generate json file"})
    private boolean generatedFileType;
    @CommandLine.Option(names={"--with-tests"}, hidden=true, description={"Generate test files"})
    private boolean includeTestFiles;
    @CommandLine.Option(names={"--with-service-type"}, hidden=true, description={"Generate service type"})
    private boolean generateServiceType;
    @CommandLine.Option(names={"--with-service-contract"}, hidden=true, description={"Generate service contract"})
    private boolean generateServiceContract;
    @CommandLine.Option(names={"--without-data-binding"}, hidden=true, description={"Generate service without data binding"})
    private boolean generateWithoutDataBinding;
    @CommandLine.Option(names={"--with-bal-ext"}, hidden=true, description={"Generate ballerina type extensions"})
    private boolean addBallerinaExtension;
    @CommandLine.Parameters
    private List<String> argList;

    public OpenApiCmd() {
        this.outStream = System.err;
        this.executionPath = Paths.get(System.getProperty("user.dir"), new String[0]);
        this.exitWhenFinish = true;
    }

    private String getVersion() throws IOException {
        String string;
        block8: {
            InputStream inputStream = OpenApiCmd.class.getClassLoader().getResourceAsStream("openapi-client-native-version.properties");
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                string = properties.getProperty("version");
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new IOException("error occurred while reading version from version.properties: " + exception.getMessage());
                }
            }
            inputStream.close();
        }
        return string;
    }

    public OpenApiCmd(PrintStream outStream, Path executionDir) {
        new OpenApiCmd(outStream, executionDir, true);
    }

    public OpenApiCmd(PrintStream outStream, Path executionDir, boolean exitWhenFinish) {
        this.outStream = outStream;
        this.executionPath = executionDir;
        this.exitWhenFinish = exitWhenFinish;
    }

    public void execute() {
        String fileName;
        if (this.isHelp()) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)this.getName());
            this.outStream.println(commandUsageInfo);
            return;
        }
        if (this.baseCmd.inputPath == null || this.baseCmd.inputPath.isBlank()) {
            this.outStream.println("An OpenAPI definition path is required to generate the service. \ne.g: bal openapi --input <OpenAPIContract> or <Ballerina file>");
            OpenApiCmd.exitError(this.exitWhenFinish);
            return;
        }
        if (this.baseCmd.mode != null) {
            this.mode = CmdUtils.searchEnum(CmdConstants.Mode.class, this.baseCmd.mode);
            if (this.mode == null) {
                this.outStream.println("ERROR:Invalid value for option '--mode': expected one of [service, client] but was '" + this.baseCmd.mode + "'");
                OpenApiCmd.exitError(this.exitWhenFinish);
            }
        }
        if ((fileName = this.baseCmd.inputPath).endsWith(".yaml") || fileName.endsWith(".json") || fileName.endsWith(".yml")) {
            ArrayList<String> tag = new ArrayList<String>();
            ArrayList operation = new ArrayList();
            if (this.baseCmd.tags != null) {
                tag.addAll(Arrays.asList(this.baseCmd.tags.split(",")));
            }
            if (this.baseCmd.operations != null) {
                String[] ids = this.baseCmd.operations.split(",");
                List normalizedOperationIds = Arrays.stream(ids).map(operationId -> GeneratorUtils.getValidName((String)operationId, (boolean)false)).collect(Collectors.toList());
                operation.addAll(normalizedOperationIds);
            }
            Filter filter = new Filter(tag, operation);
            if (!(this.baseCmd.generateClientMethods == null || this.baseCmd.generateClientMethods.isBlank() || this.baseCmd.generateClientMethods.equals("resource") || this.baseCmd.generateClientMethods.equals("remote"))) {
                this.outStream.println("'--client-methods' only supports `remote` or `resource` options.");
                OpenApiCmd.exitError(this.exitWhenFinish);
            }
            boolean bl = this.clientResourceMode = this.baseCmd.generateClientMethods == null || this.baseCmd.generateClientMethods.isBlank() || !this.baseCmd.generateClientMethods.equals("remote");
            if (!this.clientResourceMode && this.mode.equals((Object)CmdConstants.Mode.SERVICE)) {
                this.outStream.println("'--client-methods' option is only available in client generation mode.");
                OpenApiCmd.exitError(this.exitWhenFinish);
            }
            if (this.generateWithoutDataBinding && this.mode.equals((Object)CmdConstants.Mode.CLIENT)) {
                this.outStream.println("'--without-data-binding' option is only available in service generation mode.");
                OpenApiCmd.exitError(this.exitWhenFinish);
            }
            if (this.generateServiceType && this.generateServiceContract) {
                this.outStream.println("'--with-service-type' and '--with-service-contract' options cannot be used together.");
                OpenApiCmd.exitError(this.exitWhenFinish);
            }
            if (this.baseCmd.statusCodeBinding) {
                Optional<Path> ballerinaTomlPath;
                if (this.mode.equals((Object)CmdConstants.Mode.SERVICE)) {
                    this.outStream.println("the '--status-code-binding' option is only available in client generation mode.");
                    OpenApiCmd.exitError(this.exitWhenFinish);
                }
                if ((ballerinaTomlPath = CmdUtils.validateBallerinaProject(this.executionPath, this.outStream, "WARNING: invalid Ballerina package directory: %s, cannot find 'Ballerina.toml'. Since the status code binding is only supported for Ballerina packages, client generation will skip the status code binding option.", false)).isEmpty()) {
                    this.outStream.printf("WARNING: invalid Ballerina package directory: %s, cannot find 'Ballerina.toml'. Since the status code binding is only supported for Ballerina packages, client generation will skip the status code binding option.", this.executionPath.toAbsolutePath());
                } else {
                    this.statusCodeBinding = true;
                    this.ballerinaTomlPath = ballerinaTomlPath.get();
                }
            }
            if (this.addBallerinaExtension) {
                this.outStream.println("'--with-bal-ext' option is only available in OpenAPI specification generation mode.");
                OpenApiCmd.exitError(this.exitWhenFinish);
            }
            try {
                this.openApiToBallerina(fileName, filter);
            }
            catch (IOException e) {
                this.outStream.println(e.getLocalizedMessage());
                OpenApiCmd.exitError(this.exitWhenFinish);
            }
        } else if (fileName.endsWith(".bal")) {
            if (this.baseCmd.generateClientMethods != null && !this.baseCmd.generateClientMethods.isBlank()) {
                this.outStream.println("'--client-methods' option is only available in client generation mode.");
                OpenApiCmd.exitError(this.exitWhenFinish);
            }
            this.ballerinaToOpenApi(fileName);
        } else {
            this.outStream.println("An OpenAPI definition path is required to generate the service. \ne.g: bal openapi --input <OpenAPIContract> or <Ballerina file>");
            OpenApiCmd.exitError(this.exitWhenFinish);
        }
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    private boolean isHelp() {
        return this.baseCmd.helpFlag || this.argList != null && this.argList.get(0).equals("help") || this.argList == null && this.baseCmd.inputPath == null;
    }

    private void ballerinaToOpenApi(String fileName) {
        ArrayList<Object> mapperDiagnostics = new ArrayList<Object>();
        File balFile = new File(fileName);
        Path balFilePath = null;
        try {
            balFilePath = Paths.get(balFile.getCanonicalPath(), new String[0]);
        }
        catch (IOException e) {
            ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_108, new String[]{e.getLocalizedMessage()});
            mapperDiagnostics.add(error);
        }
        if (balFilePath == null || !Files.exists(balFilePath, new LinkOption[0])) {
            this.outStream.println("given Ballerina file does not exist: " + fileName);
            OpenApiCmd.exitError(this.exitWhenFinish);
        }
        this.getTargetOutputPath();
        OASContractGenerator openApiConverter = new OASContractGenerator();
        openApiConverter.setBallerinaExtension(this.addBallerinaExtension);
        openApiConverter.generateOAS3DefinitionsAllService(balFilePath, this.targetOutputPath, this.service, this.generatedFileType);
        mapperDiagnostics.addAll(openApiConverter.getDiagnostics());
        boolean exitWithError = false;
        if (mapperDiagnostics.stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.getDiagnosticSeverity()))) {
            this.outStream = System.err;
            exitWithError = true;
        }
        if (!mapperDiagnostics.isEmpty()) {
            for (OpenAPIMapperDiagnostic openAPIMapperDiagnostic : mapperDiagnostics) {
                OpenAPIDiagnostic diagnostic = CmdUtils.constructOpenAPIDiagnostic(openAPIMapperDiagnostic.getCode(), openAPIMapperDiagnostic.getMessage(), openAPIMapperDiagnostic.getDiagnosticSeverity(), openAPIMapperDiagnostic.getLocation().orElse(null), new Object[0]);
                if (exitWithError && diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
                this.outStream.println((Object)diagnostic);
            }
        }
        if (exitWithError) {
            OpenApiCmd.exitError(this.exitWhenFinish);
        }
    }

    private void openApiToBallerina(String fileName, Filter filter) throws IOException {
        boolean skipDependecyUpdate = true;
        if (this.statusCodeBinding && Objects.nonNull(this.ballerinaTomlPath)) {
            skipDependecyUpdate = this.clientNativeDependencyAlreadyExist(this.getVersion());
        }
        BallerinaCodeGenerator generator = new BallerinaCodeGenerator();
        generator.setLicenseHeader(this.setLicenseHeader());
        generator.setIncludeTestFiles(this.includeTestFiles);
        File openApiFile = new File(fileName);
        String serviceName = this.generatedServiceName != null ? this.generatedServiceName : openApiFile.getName().split("\\.")[0];
        this.getTargetOutputPath();
        Path resourcePath = Paths.get(openApiFile.getCanonicalPath(), new String[0]);
        if (this.baseCmd.nullable) {
            this.outStream.println("WARNING: All the constraints in the OpenAPI contract will be ignored when generating the Ballerina client/service with the `--nullable` option");
        }
        switch (this.mode) {
            case SERVICE: {
                this.generateServiceFile(generator, serviceName, resourcePath, filter);
                break;
            }
            case CLIENT: {
                this.generatesClientFile(generator, resourcePath, filter, this.clientResourceMode, this.statusCodeBinding);
                break;
            }
            default: {
                if (this.baseCmd.singleFile) {
                    this.outStream.println("WARNING: Generating single file for Client & Service generation mode is not supported. Defaulting to generating all files.");
                }
                this.generateBothFiles(generator, serviceName, resourcePath, filter, this.clientResourceMode, this.statusCodeBinding);
            }
        }
        if (!skipDependecyUpdate) {
            this.updateBallerinaTomlWithClientNativeDependency();
        }
    }

    public Path getRelativePath(File resourceFile, String targetOutputPath) {
        Path resourcePath = Paths.get(resourceFile.getAbsoluteFile().getParentFile().toString(), new String[0]);
        Path targetPath = Paths.get(targetOutputPath, new String[0]).toAbsolutePath();
        try {
            Path relativePath = targetPath.relativize(resourcePath);
            return relativePath.resolve(resourceFile.getName());
        }
        catch (IllegalArgumentException exception) {
            return resourcePath.resolve(resourceFile.getName());
        }
    }

    private void getTargetOutputPath() {
        this.targetOutputPath = this.executionPath;
        if (this.outputPath != null) {
            this.targetOutputPath = Paths.get(this.outputPath, new String[0]).isAbsolute() ? Paths.get(this.outputPath, new String[0]) : Paths.get(this.targetOutputPath.toString(), this.outputPath);
        }
    }

    private String setLicenseHeader() {
        Object licenseHeader = "";
        try {
            if (this.baseCmd.licenseFilePath != null && !this.baseCmd.licenseFilePath.isBlank()) {
                Path filePath = Paths.get(new File(this.baseCmd.licenseFilePath).getCanonicalPath(), new String[0]);
                licenseHeader = Files.readString(Paths.get(filePath.toString(), new String[0]));
                if (!((String)licenseHeader).endsWith("\n")) {
                    licenseHeader = (String)licenseHeader + "\n\n";
                } else if (!((String)licenseHeader).endsWith("\n\n")) {
                    licenseHeader = (String)licenseHeader + "\n";
                }
            }
        }
        catch (IOException e) {
            this.outStream.println("Invalid license file path : " + this.baseCmd.licenseFilePath + ". " + e.getMessage() + ".");
            OpenApiCmd.exitError(this.exitWhenFinish);
        }
        return licenseHeader;
    }

    private void generatesClientFile(BallerinaCodeGenerator generator, Path resourcePath, Filter filter, boolean resourceMode, boolean statusCodeBinding) {
        try {
            generator.generateClient(resourcePath.toString(), this.targetOutputPath.toString(), filter, new BallerinaCodeGenerator.ClientGeneratorOptions(this.baseCmd.nullable, resourceMode, statusCodeBinding, this.baseCmd.mock, this.baseCmd.singleFile, this.baseCmd.useSanitized));
        }
        catch (BallerinaOpenApiException | OASTypeGenException | IOException | FormatterException e) {
            if (e.getLocalizedMessage() != null) {
                this.outStream.println(e.getLocalizedMessage());
                OpenApiCmd.exitError(this.exitWhenFinish);
            }
            this.outStream.println("Error occurred when generating client for OpenAPI contract");
            OpenApiCmd.exitError(this.exitWhenFinish);
        }
    }

    private void generateServiceFile(BallerinaCodeGenerator generator, String serviceName, Path resourcePath, Filter filter) {
        try {
            assert (resourcePath != null);
            if (this.baseCmd.mock) {
                this.outStream.println("openapi: Mock server generation is currently not supported via the ballerina openapi tool.");
                OpenApiCmd.exitError(this.exitWhenFinish);
            } else {
                BallerinaCodeGenerator.ServiceGeneratorOptions options = new BallerinaCodeGenerator.ServiceGeneratorOptions(this.baseCmd.nullable, this.generateServiceType, this.generateServiceContract, this.generateWithoutDataBinding, this.baseCmd.singleFile, this.baseCmd.useSanitized);
                generator.generateService(resourcePath.toString(), serviceName, this.targetOutputPath.toString(), filter, options);
            }
        }
        catch (BallerinaOpenApiException | IOException | FormatterException e) {
            this.outStream.println("Error occurred when generating service for openAPI contract at " + this.baseCmd.inputPath + "." + e.getMessage() + ".");
            OpenApiCmd.exitError(this.exitWhenFinish);
        }
    }

    private void generateBothFiles(BallerinaCodeGenerator generator, String fileName, Path resourcePath, Filter filter, boolean generateClientResourceFunctions, boolean statusCodeBinding) {
        try {
            assert (resourcePath != null);
            BallerinaCodeGenerator.ClientServiceGeneratorOptions options = new BallerinaCodeGenerator.ClientServiceGeneratorOptions(this.baseCmd.nullable, generateClientResourceFunctions, this.generateServiceType, this.generateServiceContract, this.generateWithoutDataBinding, statusCodeBinding, this.baseCmd.mock, this.baseCmd.useSanitized);
            generator.generateClientAndService(resourcePath.toString(), fileName, this.targetOutputPath.toString(), filter, options);
        }
        catch (BallerinaOpenApiException e) {
            this.outStream.println(e.getMessage());
            OpenApiCmd.exitError(this.exitWhenFinish);
        }
        catch (ClientException | OASTypeGenException | IOException | FormatterException e) {
            this.outStream.println("Error occurred when generating service and client for openAPI contract at " + this.baseCmd.inputPath + "." + e.getMessage() + ".");
            OpenApiCmd.exitError(this.exitWhenFinish);
        }
    }

    private void updateBallerinaTomlWithClientNativeDependency() {
        try {
            String version = this.getVersion();
            TextDocument configDocument = TextDocuments.from((String)Files.readString(this.ballerinaTomlPath));
            SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)configDocument);
            DocumentNode rootNode = (DocumentNode)syntaxTree.rootNode();
            NodeList nodeList = rootNode.members();
            NodeList<DocumentMemberDeclarationNode> tomlMembers = AbstractNodeFactory.createEmptyNodeList();
            for (DocumentMemberDeclarationNode node : nodeList) {
                tomlMembers = tomlMembers.add((Node)node);
            }
            tomlMembers = CmdUtils.addNewLine((NodeList)tomlMembers, 1);
            tomlMembers = this.populateClientNativeDependency(tomlMembers, version);
            IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
            DocumentNode documentNode = NodeFactory.createDocumentNode(tomlMembers, (Token)eofToken);
            TextDocument textDocument = TextDocuments.from((String)documentNode.toSourceCode());
            String content = SyntaxTree.from((TextDocument)textDocument).toSourceCode();
            try (FileWriter writer = new FileWriter(this.ballerinaTomlPath.toString(), StandardCharsets.UTF_8);){
                writer.write(content);
                this.outStream.print("INFO: the 'Ballerina.toml' file is updated with the OpenAPI client native dependency.");
            }
        }
        catch (IOException e) {
            this.outStream.println("ERROR: error occurred when updating Ballerina.toml file. " + e.getMessage() + ".");
            OpenApiCmd.exitError(this.exitWhenFinish);
        }
    }

    private boolean clientNativeDependencyAlreadyExist(String version) {
        Project project = ProjectLoader.loadProject((Path)this.executionPath);
        Map platforms = project.currentPackage().manifest().platforms();
        if (Objects.nonNull(platforms) && platforms.containsKey("java21")) {
            Optional<Map> nativeDependency = ((PackageManifest.Platform)platforms.get("java21")).dependencies().stream().filter(dependency -> dependency.containsKey("groupId") && dependency.get("groupId").equals("io.ballerina.openapi") && dependency.containsKey("artifactId") && dependency.get("artifactId").equals("client-native")).findFirst();
            if (nativeDependency.isEmpty()) {
                return false;
            }
            if (nativeDependency.get().containsKey("version") && nativeDependency.get().get("version").equals(version)) {
                this.outStream.println("INFO: the 'Ballerina.toml' file is already updated with the OpenAPI client native dependency.");
            } else {
                this.outStream.println("ERROR: the 'Ballerina.toml' file is already updated with the OpenAPI client native dependency but the version is different from the current version. Please remove the existing dependency and try again.");
                OpenApiCmd.exitError(this.exitWhenFinish);
            }
            return true;
        }
        return false;
    }

    private NodeList<DocumentMemberDeclarationNode> populateClientNativeDependency(NodeList<DocumentMemberDeclarationNode> tomlMembers, String version) {
        String desc = "This dependency is added automatically by the OpenAPI tool. DO NOT REMOVE UNLESS REQUIRED";
        tomlMembers = tomlMembers.add((Node)SampleNodeGenerator.createTableArray((String)"platform.java21.dependency", (String)desc));
        tomlMembers = tomlMembers.add((Node)SampleNodeGenerator.createStringKV((String)"groupId", (String)"io.ballerina.openapi", null));
        tomlMembers = tomlMembers.add((Node)SampleNodeGenerator.createStringKV((String)"artifactId", (String)"client-native", null));
        tomlMembers = tomlMembers.add((Node)SampleNodeGenerator.createStringKV((String)"version", (String)version, null));
        tomlMembers = tomlMembers.add((Node)SampleNodeGenerator.createBooleanKV((String)"graalvmCompatible", (Boolean)true, null));
        return tomlMembers;
    }

    public String getName() {
        return CMD_NAME;
    }

    public void printLongDesc(StringBuilder out) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("cli-help/ballerina-openapi.help");
        try (InputStreamReader inputStreamREader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(inputStreamREader);){
            String content = br.readLine();
            out.append(content);
            while ((content = br.readLine()) != null) {
                out.append('\n').append(content);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printUsage(StringBuilder stringBuilder) {
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private static void exitError(boolean exit) {
        if (exit) {
            Runtime.getRuntime().exit(1);
        }
    }
}

