/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.openapi.core.generators.common.InlineModelResolver;
import io.ballerina.openapi.core.generators.common.model.Filter;
import io.ballerina.openapi.service.mapper.utils.CodegenUtils;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import picocli.CommandLine;

public abstract class SubCmdBase
implements BLauncherCmd {
    private static final String JSON = "json";
    private static final String YAML = "yaml";
    public static final String X_ORIGINAL_SWAGGER_VERSION = "x-original-swagger-version";
    public static final String V2 = "2.0";
    private static final String COMMAND_IDENTIFIER = "openapi-%s";
    protected static final String COMMA = ",";
    private static final String INFO_OUTPUT_WRITTEN_MSG = "INFO: %s OpenAPI definition file was successfully written to: %s%n";
    private static final String WARNING_INVALID_OUTPUT_FORMAT = "WARNING: invalid output format. The output format should be either \"json\" or \"yaml\".Defaulting to format of the input file";
    private static final String ERROR_INPUT_PATH_IS_REQUIRED = "ERROR: an OpenAPI definition path is required to %s the OpenAPI definition%n";
    private static final String ERROR_INVALID_INPUT_FILE_EXTENSION = "ERROR: invalid input OpenAPI definition file extension. The OpenAPI definition file should be in YAML or JSON format";
    private static final String ERROR_OCCURRED_WHILE_READING_THE_INPUT_FILE = "ERROR: error occurred while reading the OpenAPI definition file";
    private static final String ERROR_UNSUPPORTED_OPENAPI_VERSION = "ERROR: provided OpenAPI contract version is not supported in the tool. Use OpenAPI specification version 2 or higher";
    private static final String ERROR_OCCURRED_WHILE_PARSING_THE_INPUT_OPENAPI_FILE = "ERROR: error occurred while parsing the OpenAPI definition file";
    protected static final String FOUND_PARSER_DIAGNOSTICS = "found the following parser diagnostic messages:";
    private static final String ERROR_OCCURRED_WHILE_WRITING_THE_OUTPUT_OPENAPI_FILE = "ERROR: error occurred while writing the %s OpenAPI definition file%n";
    private static final String WARNING_SWAGGER_V2_FOUND = "WARNING: Swagger version 2.0 found in the OpenAPI definition. The generated OpenAPI definition will be in OpenAPI version 3.0.x";
    private static final PrintStream infoStream = System.out;
    private PrintStream errorStream = System.err;
    private Path targetPath = Paths.get(System.getProperty("user.dir"), new String[0]);
    private boolean exitWhenFinish = true;
    private final CommandType cmdType;
    private final String infoMsgPrefix;
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    public boolean helpFlag;
    @CommandLine.Option(names={"-i", "--input"}, description={"OpenAPI definition file path."})
    public String inputPath;
    @CommandLine.Option(names={"-o", "--output"}, description={"Location of the aligned OpenAPI definition."})
    private String outputPath;
    @CommandLine.Option(names={"-n", "--name"}, description={"Name of the aligned OpenAPI definition file."})
    private String fileName;
    @CommandLine.Option(names={"-f", "--format"}, description={"Output format of the aligned OpenAPI definition."})
    private String format;
    @CommandLine.Option(names={"-t", "--tags"}, description={"Tags that need to be considered when sanitizing."})
    public String tags;
    @CommandLine.Option(names={"--operations"}, description={"Operations that need to be included when sanitizing."})
    public String operations;

    protected SubCmdBase(CommandType cmdType, String infoMsgPrefix) {
        this.cmdType = cmdType;
        this.infoMsgPrefix = infoMsgPrefix;
    }

    protected SubCmdBase(CommandType cmdType, String infoMsgPrefix, PrintStream errorStream, boolean exitWhenFinish) {
        this.cmdType = cmdType;
        this.errorStream = errorStream;
        this.exitWhenFinish = exitWhenFinish;
        this.infoMsgPrefix = infoMsgPrefix;
    }

    public void printHelpText() {
        String commandIdentifier = String.format(COMMAND_IDENTIFIER, this.cmdType.getName());
        String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)commandIdentifier);
        infoStream.println(commandUsageInfo);
    }

    public void execute() {
        if (this.helpFlag) {
            this.printHelpText();
            return;
        }
        if (Objects.isNull(this.inputPath) || this.inputPath.isBlank()) {
            this.errorStream.printf(ERROR_INPUT_PATH_IS_REQUIRED, this.cmdType.getName());
            this.exitError();
            return;
        }
        if (this.inputPath.endsWith(".yaml") || this.inputPath.endsWith(".json") || this.inputPath.endsWith(".yml")) {
            this.populateInputOptions();
            this.generateOpenAPI();
            return;
        }
        this.errorStream.println(ERROR_INVALID_INPUT_FILE_EXTENSION);
        this.exitError();
    }

    public void printError(String message) {
        this.errorStream.println(message);
    }

    private void generateOpenAPI() {
        String openAPIFileContent;
        try {
            openAPIFileContent = Files.readString(Path.of(this.inputPath, new String[0]));
        }
        catch (Exception e) {
            this.errorStream.println(ERROR_OCCURRED_WHILE_READING_THE_INPUT_FILE);
            this.exitError();
            return;
        }
        Optional<OpenAPI> openAPIOptional = this.generate(openAPIFileContent);
        if (openAPIOptional.isEmpty()) {
            this.exitError();
            return;
        }
        this.writeGeneratedOpenAPIFile(openAPIOptional.get());
    }

    public abstract Optional<OpenAPI> generate(String var1);

    public abstract String getDefaultFileName();

    public Optional<OpenAPI> getFlattenOpenAPI(OpenAPI openAPI) {
        InlineModelResolver inlineModelResolver = new InlineModelResolver(true, false);
        inlineModelResolver.flatten(openAPI);
        return Optional.of(openAPI);
    }

    public Optional<OpenAPI> getFilteredOpenAPI(String openAPIFileContent) {
        ParseOptions parseOptions = new ParseOptions();
        SwaggerParseResult parserResult = new OpenAPIParser().readContents(openAPIFileContent, null, parseOptions);
        if (!parserResult.getMessages().isEmpty() && parserResult.getMessages().contains("attribute swaggerVersion is unexpected")) {
            this.errorStream.println(ERROR_UNSUPPORTED_OPENAPI_VERSION);
            return Optional.empty();
        }
        OpenAPI openAPI = parserResult.getOpenAPI();
        if (Objects.isNull(openAPI)) {
            this.errorStream.println(ERROR_OCCURRED_WHILE_PARSING_THE_INPUT_OPENAPI_FILE);
            if (!parserResult.getMessages().isEmpty()) {
                this.errorStream.println(FOUND_PARSER_DIAGNOSTICS);
                parserResult.getMessages().forEach(this.errorStream::println);
            }
            return Optional.empty();
        }
        if (Objects.nonNull(openAPI.getExtensions()) && SubCmdBase.isSwaggerV2(openAPI)) {
            this.errorStream.println(WARNING_SWAGGER_V2_FOUND);
        }
        this.filterOpenAPIOperations(openAPI);
        SubCmdBase.removeDefaultServers(openAPI);
        return Optional.of(openAPI);
    }

    private static boolean isSwaggerV2(OpenAPI openAPI) {
        return openAPI.getExtensions().containsKey(X_ORIGINAL_SWAGGER_VERSION) && openAPI.getExtensions().get(X_ORIGINAL_SWAGGER_VERSION).toString().trim().equals(V2);
    }

    public String getName() {
        return this.cmdType.getName();
    }

    public void printLongDesc(StringBuilder stringBuilder) {
    }

    public void printUsage(StringBuilder stringBuilder) {
    }

    public void setParentCmdParser(CommandLine commandLine) {
    }

    private void populateInputOptions() {
        if (Objects.nonNull(this.format)) {
            if (!this.format.equalsIgnoreCase(JSON) && !this.format.equalsIgnoreCase(YAML)) {
                this.setDefaultFormat();
                this.errorStream.println(WARNING_INVALID_OUTPUT_FORMAT);
            }
        } else {
            this.setDefaultFormat();
        }
        if (Objects.isNull(this.fileName)) {
            this.fileName = String.format(this.getDefaultFileName(), this.cmdType.getName());
        }
        if (Objects.nonNull(this.outputPath)) {
            this.targetPath = Paths.get(this.outputPath, new String[0]).isAbsolute() ? Paths.get(this.outputPath, new String[0]) : Paths.get(this.targetPath.toString(), this.outputPath);
        }
    }

    private void setDefaultFormat() {
        this.format = this.inputPath.endsWith(".json") ? JSON : YAML;
    }

    private void exitError() {
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(1);
        }
    }

    private void writeGeneratedOpenAPIFile(OpenAPI openAPI) {
        String outputFileNameWithExt = this.getOutputFileName();
        try {
            CodegenUtils.writeFile((Path)this.targetPath.resolve(outputFileNameWithExt), (String)(outputFileNameWithExt.endsWith(".json") ? Json.pretty((Object)openAPI) : Yaml.pretty((Object)openAPI)));
            infoStream.printf(INFO_OUTPUT_WRITTEN_MSG, this.infoMsgPrefix, this.targetPath.resolve(outputFileNameWithExt));
        }
        catch (IOException exception) {
            this.errorStream.printf(ERROR_OCCURRED_WHILE_WRITING_THE_OUTPUT_OPENAPI_FILE, this.infoMsgPrefix);
            this.exitError();
        }
    }

    private String getOutputFileName() {
        return CodegenUtils.resolveContractFileName((Path)this.targetPath, (String)(this.fileName + this.getFileExtension()), (Boolean)this.format.equals(JSON));
    }

    private String getFileExtension() {
        return Objects.nonNull(this.format) && this.format.equals(JSON) ? ".json" : ".yaml";
    }

    private Filter getFilter() {
        ArrayList<String> tagList = new ArrayList<String>();
        ArrayList<String> operationList = new ArrayList<String>();
        if (Objects.nonNull(this.tags) && !this.tags.isEmpty()) {
            tagList.addAll(Arrays.asList(this.tags.split(COMMA)));
        }
        if (Objects.nonNull(this.operations) && !this.operations.isEmpty()) {
            operationList.addAll(Arrays.asList(this.operations.split(COMMA)));
        }
        return new Filter(tagList, operationList);
    }

    private void filterOpenAPIOperations(OpenAPI openAPI) {
        Filter filter = this.getFilter();
        if (filter.getOperations().isEmpty() && filter.getTags().isEmpty()) {
            return;
        }
        openAPI.getPaths().forEach((path, pathItem) -> pathItem.readOperationsMap().forEach((httpMethod, operation) -> {
            if (!filter.getOperations().contains(operation.getOperationId())) {
                if (operation.getTags().stream().noneMatch(filter.getTags()::contains)) {
                    pathItem.operation(httpMethod, null);
                }
            }
        }));
        ArrayList pathsToRemove = new ArrayList();
        openAPI.getPaths().forEach((path, pathItem) -> {
            if (pathItem.readOperationsMap().isEmpty()) {
                pathsToRemove.add(path);
            }
        });
        pathsToRemove.forEach(arg_0 -> openAPI.getPaths().remove(arg_0));
    }

    private static void removeDefaultServers(OpenAPI openAPI) {
        List servers = openAPI.getServers();
        if (Objects.nonNull(servers) && servers.size() == 1 && ((Server)servers.getFirst()).equals((Object)new Server().url("/"))) {
            openAPI.setServers(null);
        }
    }

    public static enum CommandType {
        FLATTEN("flatten"),
        ALIGN("align");

        private final String name;

        private CommandType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

