/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.values.BError;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ModuleUtils {
    private static Module websocketModule;
    private static String packageIdentifier;

    private ModuleUtils() {
    }

    public static void setModule(Environment env) {
        websocketModule = env.getCurrentModule();
        packageIdentifier = "ballerina/websocket:" + websocketModule.getMajorVersion();
    }

    public static Module getWebsocketModule() {
        return websocketModule;
    }

    public static String getPackageIdentifier() {
        return packageIdentifier;
    }

    public static Map<String, Object> getProperties(String resourceName) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("moduleOrg", "ballerina");
        properties.put("moduleName", "websocket");
        properties.put("moduleVersion", ModuleUtils.getWebsocketModule().getMajorVersion());
        properties.put("parentFunctionName", resourceName);
        return properties;
    }

    public static Object getResult(CompletableFuture<Object> balFuture) {
        try {
            return balFuture.get();
        }
        catch (BError error) {
            throw error;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ErrorCreator.createError((Throwable)e);
        }
        catch (Throwable throwable) {
            throw ErrorCreator.createError((Throwable)throwable);
        }
    }
}

