/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket;

import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnection;
import io.ballerina.stdlib.websocket.Handler;
import io.ballerina.stdlib.websocket.ModuleUtils;
import io.ballerina.stdlib.websocket.ReturnStreamUnitCallBack;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketResourceDispatcher;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.actions.websocketconnector.WebSocketConnector;
import io.ballerina.stdlib.websocket.observability.WebSocketObservabilityUtil;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionInfo;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.nio.ByteBuffer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebSocketResourceCallback
implements Handler {
    private final WebSocketConnection webSocketConnection;
    private final WebSocketConnectionInfo connectionInfo;
    private final String resource;
    private final Runtime runtime;
    private static final Logger log = LoggerFactory.getLogger(WebSocketResourceCallback.class);

    WebSocketResourceCallback(WebSocketConnectionInfo webSocketConnectionInfo, String resource, Runtime runtime) throws IllegalAccessException {
        this.runtime = runtime;
        this.connectionInfo = webSocketConnectionInfo;
        this.webSocketConnection = this.connectionInfo.getWebSocketConnection();
        this.resource = resource;
    }

    @Override
    public void notifySuccess(Object result) {
        PromiseCombiner promiseCombiner = new PromiseCombiner((EventExecutor)ImmediateEventExecutor.INSTANCE);
        if (result instanceof BError) {
            ((BError)((Object)result)).printStackTrace();
        } else if (result instanceof BArray && this.resource.equals("onPing")) {
            this.sendPong((BArray)result, promiseCombiner);
        } else if (result instanceof BString) {
            this.sendTextMessage((BString)result, promiseCombiner);
        } else if (result instanceof BArray) {
            this.sendBinaryMessage((BArray)result, promiseCombiner);
        } else if (result instanceof BStream) {
            BObject bObject = ((BStream)result).getIteratorObj();
            ReturnStreamUnitCallBack returnStreamUnitCallBack = new ReturnStreamUnitCallBack(bObject, this.runtime, this.connectionInfo, this.webSocketConnection);
            Thread.startVirtualThread(() -> {
                Map<String, Object> properties = ModuleUtils.getProperties("next");
                StrandMetadata strandMetadata = new StrandMetadata(true, properties);
                try {
                    Object res = this.runtime.callMethod(bObject, "next", strandMetadata, new Object[0]);
                    returnStreamUnitCallBack.notifySuccess(res);
                }
                catch (BError bError) {
                    returnStreamUnitCallBack.notifyFailure(bError);
                }
            });
        } else if (result == null) {
            this.webSocketConnection.readNextFrame();
        } else if (!(this.resource.equals("onPong") || this.resource.equals("onClose") || this.resource.equals("onError") || this.resource.equals("onIdleTimeout"))) {
            this.sendTextMessage(StringUtils.fromString((String)result.toString()), promiseCombiner);
        } else {
            log.error("invalid return type");
        }
    }

    private void sendPong(BArray result, PromiseCombiner promiseCombiner) {
        try {
            ChannelFuture webSocketChannelFuture = this.connectionInfo.getWebSocketConnection().pong(ByteBuffer.wrap(result.getBytes()));
            promiseCombiner.add((Future)webSocketChannelFuture);
            promiseCombiner.finish((Promise)this.connectionInfo.getWebSocketConnection().getChannel().newPromise().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    this.webSocketConnection.readNextFrame();
                } else {
                    WebSocketResourceDispatcher.dispatchOnError(this.connectionInfo, future.cause(), this.connectionInfo.getWebSocketEndpoint().get(WebSocketConstants.INITIALIZED_BY_SERVICE).equals(true));
                }
            })));
        }
        catch (Exception e) {
            log.error("Error occurred when pinging", (Throwable)e);
            WebSocketResourceDispatcher.dispatchOnError(this.connectionInfo, e, this.connectionInfo.getWebSocketEndpoint().get(WebSocketConstants.INITIALIZED_BY_SERVICE).equals(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBinaryMessage(BArray result, PromiseCombiner promiseCombiner) {
        ByteBuf byteBuf = null;
        ByteBuf lastSlice = null;
        try {
            int index;
            byteBuf = WebSocketConnector.fromByteArray(ByteBuffer.wrap(result.getBytes()));
            int noBytes = byteBuf.readableBytes();
            int size = (Integer)this.connectionInfo.getWebSocketEndpoint().getNativeData("MAX_FRAME_SIZE");
            for (index = 0; index < noBytes - size; index += size) {
                ByteBuf slice = null;
                try {
                    slice = byteBuf.retainedSlice(index, size);
                    byte[] chunk = WebSocketConnector.getByteChunk(size, slice);
                    ChannelFuture future2 = this.connectionInfo.getWebSocketConnection().pushBinary(ByteBuffer.wrap(chunk), false);
                    promiseCombiner.add((Future)future2);
                }
                catch (Throwable throwable) {
                    WebSocketConnector.release(slice);
                    throw throwable;
                }
                WebSocketConnector.release(slice);
            }
            lastSlice = byteBuf.retainedSlice(index, noBytes - index);
            byte[] finalChunk = WebSocketConnector.getByteChunk(noBytes - index, lastSlice);
            ChannelFuture webSocketChannelFuture = this.connectionInfo.getWebSocketConnection().pushBinary(ByteBuffer.wrap(finalChunk), true);
            promiseCombiner.add((Future)webSocketChannelFuture);
            promiseCombiner.finish((Promise)this.connectionInfo.getWebSocketConnection().getChannel().newPromise().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    WebSocketObservabilityUtil.observeSend("binary", this.connectionInfo);
                    this.webSocketConnection.readNextFrame();
                } else {
                    WebSocketResourceDispatcher.dispatchOnError(this.connectionInfo, future.cause(), true);
                }
            })));
        }
        catch (IllegalAccessException | IllegalStateException e) {
            try {
                log.error("Error occurred when pushing binary data", (Throwable)e);
                WebSocketResourceDispatcher.dispatchOnError(this.connectionInfo, e, true);
            }
            catch (Throwable throwable) {
                WebSocketConnector.release(byteBuf);
                WebSocketConnector.release(lastSlice);
                throw throwable;
            }
            WebSocketConnector.release(byteBuf);
            WebSocketConnector.release(lastSlice);
        }
        WebSocketConnector.release(byteBuf);
        WebSocketConnector.release(lastSlice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTextMessage(BString result, PromiseCombiner promiseCombiner) {
        block8: {
            ByteBuf byteBuf = null;
            ByteBuf lastSlice = null;
            try {
                int index;
                byteBuf = WebSocketConnector.fromText(result.getValue());
                int noBytes = byteBuf.readableBytes();
                int size = (Integer)this.connectionInfo.getWebSocketEndpoint().getNativeData("MAX_FRAME_SIZE");
                for (index = 0; index < noBytes - size; index += size) {
                    ByteBuf slice = null;
                    try {
                        slice = byteBuf.retainedSlice(index, size);
                        String chunk = slice.toString(CharsetUtil.UTF_8);
                        ChannelFuture future = this.connectionInfo.getWebSocketConnection().pushText(chunk, false);
                        promiseCombiner.add((Future)future);
                    }
                    catch (Throwable throwable) {
                        WebSocketConnector.release(slice);
                        throw throwable;
                    }
                    WebSocketConnector.release(slice);
                }
                lastSlice = byteBuf.retainedSlice(index, noBytes - index);
                String chunk = lastSlice.toString(CharsetUtil.UTF_8);
                ChannelFuture future = this.connectionInfo.getWebSocketConnection().pushText(chunk, true);
                promiseCombiner.add((Future)future);
                promiseCombiner.finish((Promise)this.connectionInfo.getWebSocketConnection().getChannel().newPromise().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                    if (channelFuture.isSuccess()) {
                        WebSocketObservabilityUtil.observeSend("text", this.connectionInfo);
                        this.webSocketConnection.readNextFrame();
                    } else {
                        WebSocketResourceDispatcher.dispatchOnError(this.connectionInfo, future.cause(), true);
                    }
                })));
                WebSocketConnector.release(byteBuf);
            }
            catch (IllegalAccessException | IllegalStateException e) {
                log.error("Error occurred when pushing text data", (Throwable)e);
                WebSocketResourceDispatcher.dispatchOnError(this.connectionInfo, e, true);
                break block8;
            }
            finally {
                WebSocketConnector.release(byteBuf);
                WebSocketConnector.release(lastSlice);
            }
            WebSocketConnector.release(lastSlice);
        }
    }

    @Override
    public void notifyFailure(BError error) {
        error.printStackTrace();
        WebSocketUtil.closeDuringUnexpectedCondition(this.webSocketConnection);
        WebSocketObservabilityUtil.observeError(this.connectionInfo, "resource_invocation", this.resource, error.getMessage());
        System.exit(1);
    }
}

