/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.actions.websocketconnector;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketWriteTimeOutListener;
import io.ballerina.stdlib.websocket.ModuleUtils;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.actions.websocketconnector.WriteTimeOutListener;
import io.ballerina.stdlib.websocket.observability.WebSocketObservabilityUtil;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnector {
    private static final Logger log = LoggerFactory.getLogger(WebSocketConnector.class);

    public static Object writeTextMessage(Environment env, BObject wsConnection, BString text) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            AtomicBoolean textCallbackCompleted = new AtomicBoolean(false);
            PromiseCombiner promiseCombiner = new PromiseCombiner((EventExecutor)ImmediateEventExecutor.INSTANCE);
            WebSocketConnectionInfo connectionInfo = (WebSocketConnectionInfo)wsConnection.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO");
            WebSocketObservabilityUtil.observeResourceInvocation(env, connectionInfo, "writeTextMessage");
            ByteBuf byteBuf = null;
            ByteBuf lastSlice = null;
            try {
                int index;
                WebSocketConnector.setWriteTimeoutHandler(wsConnection, balFuture, textCallbackCompleted, connectionInfo);
                byteBuf = WebSocketConnector.fromText(text.getValue());
                int noBytes = byteBuf.readableBytes();
                int size = (Integer)connectionInfo.getWebSocketEndpoint().getNativeData("MAX_FRAME_SIZE");
                for (index = 0; index < noBytes - size; index += size) {
                    ByteBuf slice = null;
                    try {
                        slice = byteBuf.retainedSlice(index, size);
                        String chunk = slice.toString(CharsetUtil.UTF_8);
                        ChannelFuture future = connectionInfo.getWebSocketConnection().pushText(chunk, false);
                        promiseCombiner.add((Future)future);
                    }
                    catch (Throwable throwable) {
                        WebSocketConnector.release(slice);
                        throw throwable;
                    }
                    WebSocketConnector.release(slice);
                }
                lastSlice = byteBuf.retainedSlice(index, noBytes - index);
                String chunk = lastSlice.toString(CharsetUtil.UTF_8);
                ChannelFuture future = connectionInfo.getWebSocketConnection().pushText(chunk, true);
                promiseCombiner.add((Future)future);
                promiseCombiner.finish((Promise)connectionInfo.getWebSocketConnection().getChannel().newPromise().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                    WebSocketConnector.removeWriteTimeoutHandler(wsConnection, connectionInfo);
                    if (channelFuture.isSuccess()) {
                        WebSocketUtil.handleWebSocketCallback(balFuture, channelFuture, log, connectionInfo, textCallbackCompleted);
                        WebSocketObservabilityUtil.observeSend("text", connectionInfo);
                    } else if (WebSocketUtil.hasRetryConfig(wsConnection) && !textCallbackCompleted.get()) {
                        WebSocketUtil.reconnectForWrite(connectionInfo, balFuture, textCallbackCompleted, text.getValue(), null);
                    } else if (!textCallbackCompleted.get()) {
                        WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, balFuture, future.cause(), textCallbackCompleted);
                    }
                })));
            }
            catch (IllegalAccessException | IllegalStateException e) {
                try {
                    log.error("Error occurred when pushing text data", (Throwable)e);
                    WebSocketObservabilityUtil.observeError(WebSocketObservabilityUtil.getConnectionInfo(wsConnection), "message_sent", "text", e.getMessage());
                    WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, balFuture, e, textCallbackCompleted);
                }
                catch (Throwable throwable) {
                    WebSocketConnector.release(byteBuf);
                    WebSocketConnector.release(lastSlice);
                    throw throwable;
                }
                WebSocketConnector.release(byteBuf);
                WebSocketConnector.release(lastSlice);
            }
            WebSocketConnector.release(byteBuf);
            WebSocketConnector.release(lastSlice);
            return ModuleUtils.getResult(balFuture);
        });
    }

    public static void setWriteTimeoutHandler(BObject wsConnection, CompletableFuture<Object> balFuture, AtomicBoolean textCallbackCompleted, WebSocketConnectionInfo connectionInfo) throws IllegalAccessException {
        long writeTimeoutInSeconds;
        if (TypeUtils.getType((Object)wsConnection).getName().equals("Client") && (writeTimeoutInSeconds = (long)WebSocketUtil.findTimeoutInSeconds((BMap<BString, Object>)connectionInfo.getWebSocketEndpoint().getMapValue(WebSocketConstants.CLIENT_ENDPOINT_CONFIG), WebSocketConstants.CLIENT_WRITE_TIMEOUT, 0)) > 0L) {
            WriteTimeOutListener writeTimeOutListener = new WriteTimeOutListener(balFuture, textCallbackCompleted);
            connectionInfo.getWebSocketConnection().addWriteIdleStateHandler((WebSocketWriteTimeOutListener)writeTimeOutListener, writeTimeoutInSeconds);
        }
    }

    public static void release(ByteBuf byteBuf) {
        if (byteBuf != null) {
            byteBuf.release();
        }
    }

    public static ByteBuf fromText(String text) {
        if (text == null || text.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        return Unpooled.copiedBuffer((CharSequence)text, (Charset)CharsetUtil.UTF_8);
    }

    public static ByteBuf fromByteArray(ByteBuffer buffer) {
        return Unpooled.wrappedBuffer((ByteBuffer)buffer);
    }

    public static Object writeBinaryMessage(Environment env, BObject wsConnection, BArray binaryData) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            WebSocketConnectionInfo connectionInfo = (WebSocketConnectionInfo)wsConnection.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO");
            AtomicBoolean binaryCallbackCompleted = new AtomicBoolean(false);
            PromiseCombiner promiseCombiner = new PromiseCombiner((EventExecutor)ImmediateEventExecutor.INSTANCE);
            WebSocketObservabilityUtil.observeResourceInvocation(env, connectionInfo, "writeBinaryMessage");
            ByteBuf byteBuf = null;
            ByteBuf lastSlice = null;
            try {
                int index;
                WebSocketConnector.setWriteTimeoutHandler(wsConnection, balFuture, binaryCallbackCompleted, connectionInfo);
                byteBuf = WebSocketConnector.fromByteArray(ByteBuffer.wrap(binaryData.getBytes()));
                int noBytes = byteBuf.readableBytes();
                int size = (Integer)connectionInfo.getWebSocketEndpoint().getNativeData("MAX_FRAME_SIZE");
                for (index = 0; index < noBytes - size; index += size) {
                    ByteBuf slice = null;
                    try {
                        slice = byteBuf.retainedSlice(index, size);
                        byte[] chunk = WebSocketConnector.getByteChunk(size, slice);
                        ChannelFuture future2 = connectionInfo.getWebSocketConnection().pushBinary(ByteBuffer.wrap(chunk), false);
                        promiseCombiner.add((Future)future2);
                    }
                    catch (Throwable throwable) {
                        WebSocketConnector.release(slice);
                        throw throwable;
                    }
                    WebSocketConnector.release(slice);
                }
                lastSlice = byteBuf.retainedSlice(index, noBytes - index);
                byte[] finalChunk = WebSocketConnector.getByteChunk(noBytes - index, lastSlice);
                ChannelFuture webSocketChannelFuture = connectionInfo.getWebSocketConnection().pushBinary(ByteBuffer.wrap(finalChunk), true);
                promiseCombiner.add((Future)webSocketChannelFuture);
                promiseCombiner.finish((Promise)connectionInfo.getWebSocketConnection().getChannel().newPromise().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                    WebSocketConnector.removeWriteTimeoutHandler(wsConnection, connectionInfo);
                    if (future.isSuccess()) {
                        WebSocketUtil.handleWebSocketCallback(balFuture, future, log, connectionInfo, binaryCallbackCompleted);
                        WebSocketObservabilityUtil.observeSend("binary", connectionInfo);
                    } else if (WebSocketUtil.hasRetryConfig(wsConnection) && !binaryCallbackCompleted.get()) {
                        WebSocketUtil.reconnectForWrite(connectionInfo, balFuture, binaryCallbackCompleted, null, binaryData);
                    } else if (!binaryCallbackCompleted.get()) {
                        WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, balFuture, future.cause(), binaryCallbackCompleted);
                    }
                })));
            }
            catch (IllegalAccessException | IllegalStateException e) {
                try {
                    log.error("Error occurred when pushing binary data", (Throwable)e);
                    WebSocketObservabilityUtil.observeError(WebSocketObservabilityUtil.getConnectionInfo(wsConnection), "message_sent", "binary", e.getMessage());
                    WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, balFuture, e, binaryCallbackCompleted);
                }
                catch (Throwable throwable) {
                    WebSocketConnector.release(byteBuf);
                    WebSocketConnector.release(lastSlice);
                    throw throwable;
                }
                WebSocketConnector.release(byteBuf);
                WebSocketConnector.release(lastSlice);
            }
            WebSocketConnector.release(byteBuf);
            WebSocketConnector.release(lastSlice);
            return ModuleUtils.getResult(balFuture);
        });
    }

    public static void removeWriteTimeoutHandler(BObject wsConnection, WebSocketConnectionInfo connectionInfo) throws IllegalAccessException {
        if (TypeUtils.getType((Object)wsConnection).getName().equals("Client")) {
            connectionInfo.getWebSocketConnection().removeWriteIdleStateHandler();
        }
    }

    public static byte[] getByteChunk(int size, ByteBuf slice) {
        byte[] chunk = new byte[size];
        slice.getBytes(0, chunk);
        return chunk;
    }

    public static Object ping(Environment env, BObject wsConnection, BArray binaryData) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            WebSocketConnectionInfo connectionInfo = (WebSocketConnectionInfo)wsConnection.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO");
            AtomicBoolean pingCallbackCompleted = new AtomicBoolean(false);
            WebSocketObservabilityUtil.observeResourceInvocation(env, connectionInfo, "ping");
            try {
                ChannelFuture future = connectionInfo.getWebSocketConnection().ping(ByteBuffer.wrap(binaryData.getBytes()));
                WebSocketUtil.handlePingWebSocketCallback(balFuture, future, log, connectionInfo, pingCallbackCompleted);
                WebSocketObservabilityUtil.observeSend("ping", connectionInfo);
            }
            catch (Exception e) {
                log.error("Error occurred when pinging", (Throwable)e);
                WebSocketObservabilityUtil.observeError(WebSocketObservabilityUtil.getConnectionInfo(wsConnection), "message_sent", "ping", e.getMessage());
                WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, balFuture, e, pingCallbackCompleted);
            }
            return ModuleUtils.getResult(balFuture);
        });
    }

    public static Object pong(Environment env, BObject wsConnection, BArray binaryData) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            WebSocketConnectionInfo connectionInfo = (WebSocketConnectionInfo)wsConnection.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO");
            AtomicBoolean pongCallbackCompleted = new AtomicBoolean(false);
            WebSocketObservabilityUtil.observeResourceInvocation(env, connectionInfo, "pong");
            try {
                ChannelFuture future = connectionInfo.getWebSocketConnection().pong(ByteBuffer.wrap(binaryData.getBytes()));
                WebSocketUtil.handleWebSocketCallback(balFuture, future, log, connectionInfo, pongCallbackCompleted);
                WebSocketObservabilityUtil.observeSend("pong", connectionInfo);
            }
            catch (Exception e) {
                log.error("Error occurred when ponging", (Throwable)e);
                WebSocketObservabilityUtil.observeError(WebSocketObservabilityUtil.getConnectionInfo(wsConnection), "message_sent", "pong", e.getMessage());
                WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, balFuture, e, pongCallbackCompleted);
            }
            return ModuleUtils.getResult(balFuture);
        });
    }

    private WebSocketConnector() {
    }
}

