/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.actions.websocketconnector;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.websocket.ModuleUtils;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.client.listener.SyncClientConnectorListener;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionInfo;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class WebSocketSyncConnector {
    public static Object readTextMessage(Environment env, BObject wsConnection) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> callback = new CompletableFuture<Object>();
            try {
                WebSocketSyncConnector.readContentFromConnection(wsConnection, callback, new BTypedesc[0]);
                return ModuleUtils.getResult(callback);
            }
            catch (IllegalAccessException e) {
                return WebSocketUtil.createWebsocketError(e.getMessage(), WebSocketConstants.ErrorCode.ConnectionClosureError);
            }
        });
    }

    private static void readContentFromConnection(BObject wsConnection, CompletableFuture<Object> callback, BTypedesc ... targetType) throws IllegalAccessException {
        WebSocketConnectionInfo connectionInfo = (WebSocketConnectionInfo)wsConnection.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO");
        connectionInfo.addCallback(callback);
        if (!connectionInfo.getWebSocketConnection().isOpen()) {
            callback.complete((Object)WebSocketUtil.createWebsocketError("Connection already closed", WebSocketConstants.ErrorCode.ConnectionClosureError));
            return;
        }
        SyncClientConnectorListener connectorListener = (SyncClientConnectorListener)wsConnection.getNativeData("clientListener");
        long readTimeoutInSeconds = WebSocketUtil.findTimeoutInSeconds((BMap<BString, Object>)connectionInfo.getWebSocketEndpoint().getMapValue(WebSocketConstants.CLIENT_ENDPOINT_CONFIG), WebSocketConstants.ANNOTATION_ATTR_READ_IDLE_TIMEOUT, 0);
        connectionInfo.getWebSocketConnection().addReadIdleStateHandler(readTimeoutInSeconds);
        connectorListener.setCallback(callback);
        if (targetType.length > 0) {
            connectorListener.setTargetType(targetType[0]);
        }
        connectorListener.setFutureCompleted(new AtomicBoolean(false));
        connectionInfo.getWebSocketConnection().readNextFrame();
    }

    public static Object readBinaryMessage(Environment env, BObject wsConnection) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> callback = new CompletableFuture<Object>();
            try {
                WebSocketSyncConnector.readContentFromConnection(wsConnection, callback, new BTypedesc[0]);
                return ModuleUtils.getResult(callback);
            }
            catch (IllegalAccessException e) {
                return WebSocketUtil.createWebsocketError(e.getMessage(), WebSocketConstants.ErrorCode.ConnectionClosureError);
            }
        });
    }

    public static Object readMessage(Environment env, BObject wsConnection, BTypedesc targetType) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> callback = new CompletableFuture<Object>();
            try {
                WebSocketSyncConnector.readContentFromConnection(wsConnection, callback, targetType);
                return ModuleUtils.getResult(callback);
            }
            catch (IllegalAccessException e) {
                return WebSocketUtil.createWebsocketError(e.getMessage(), WebSocketConstants.ErrorCode.ConnectionClosureError);
            }
        });
    }

    private WebSocketSyncConnector() {
    }
}

