/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.client;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.contract.HttpWsConnectorFactory;
import io.ballerina.stdlib.http.transport.contract.config.SslConfiguration;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketClientConnector;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketClientConnectorConfig;
import io.ballerina.stdlib.websocket.ModuleUtils;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketService;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.client.RetryContext;
import io.ballerina.stdlib.websocket.client.listener.SyncClientConnectorListener;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class SyncInitEndpoint {
    private static final String INTERVAL = "interval";
    private static final String MAX_WAIT_INTERVAL = "maxWaitInterval";
    private static final String MAX_COUNT = "maxCount";
    private static final String BACK_OF_FACTOR = "backOffFactor";

    public static Object initEndpoint(Environment env, BObject wsSyncClient) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture;
            block6: {
                balFuture = new CompletableFuture<Object>();
                AtomicBoolean callbackCompleted = new AtomicBoolean(false);
                try {
                    BMap clientEndpointConfig = wsSyncClient.getMapValue(WebSocketConstants.CLIENT_ENDPOINT_CONFIG);
                    String remoteUrl = wsSyncClient.getStringValue(WebSocketConstants.CLIENT_URL_CONFIG).getValue();
                    BObject callbackService = wsSyncClient.getObjectValue(WebSocketConstants.SYNC_CLIENT_SERVICE_CONFIG);
                    WebSocketService wsService = WebSocketUtil.validateAndCreateWebSocketService(env.getRuntime(), callbackService);
                    HttpWsConnectorFactory connectorFactory = HttpUtil.createHttpWsConnectionFactory();
                    WebSocketClientConnectorConfig clientConnectorConfig = new WebSocketClientConnectorConfig(remoteUrl);
                    String scheme = URI.create(remoteUrl).getScheme();
                    if (scheme == null) {
                        balFuture.complete((Object)WebSocketUtil.getWebSocketError("Malformed URL: " + remoteUrl, null, WebSocketConstants.ErrorCode.Error.errorCode(), null));
                        callbackCompleted.set(true);
                        return ModuleUtils.getResult(balFuture);
                    }
                    SyncInitEndpoint.populateSyncClientConnectorConfig((BMap<BString, Object>)clientEndpointConfig, clientConnectorConfig, scheme);
                    if (WebSocketUtil.hasRetryConfig(wsSyncClient)) {
                        BMap retryConfig = clientEndpointConfig.getMapValue(WebSocketConstants.RETRY_CONFIG);
                        RetryContext retryConnectorConfig = new RetryContext();
                        SyncInitEndpoint.populateRetryConnectorConfig((BMap<BString, Object>)retryConfig, retryConnectorConfig);
                        wsSyncClient.addNativeData(WebSocketConstants.RETRY_CONFIG.toString(), (Object)retryConnectorConfig);
                    }
                    WebSocketClientConnector clientConnector = connectorFactory.createWsClientConnectorWithSSL(clientConnectorConfig);
                    wsSyncClient.addNativeData("connectorFactory", (Object)connectorFactory);
                    wsSyncClient.addNativeData("clientConnector", (Object)clientConnector);
                    wsSyncClient.addNativeData("callbackService", (Object)wsService);
                    wsSyncClient.addNativeData("MAX_FRAME_SIZE", (Object)clientConnectorConfig.getMaxFrameSize());
                    SyncClientConnectorListener syncClientConnectorListener = new SyncClientConnectorListener();
                    wsSyncClient.addNativeData("clientListener", (Object)syncClientConnectorListener);
                    WebSocketUtil.establishWebSocketConnection(wsSyncClient, wsService, balFuture, callbackCompleted);
                }
                catch (Exception e) {
                    if (e instanceof BError) {
                        if (!callbackCompleted.get()) {
                            balFuture.complete(e);
                            callbackCompleted.set(true);
                        }
                    }
                    if (callbackCompleted.get()) break block6;
                    balFuture.complete((Object)WebSocketUtil.getWebSocketError(e.getMessage(), null, WebSocketConstants.ErrorCode.Error.errorCode(), null));
                    callbackCompleted.set(true);
                }
            }
            return ModuleUtils.getResult(balFuture);
        });
    }

    private static void populateSyncClientConnectorConfig(BMap<BString, Object> clientEndpointConfig, WebSocketClientConnectorConfig clientConnectorConfig, String scheme) {
        clientConnectorConfig.setAutoRead(false);
        clientConnectorConfig.setSubProtocols(WebSocketUtil.findNegotiableSubProtocols(clientEndpointConfig));
        long handshakeTimeoutInSeconds = WebSocketUtil.findTimeoutInSeconds(clientEndpointConfig, WebSocketConstants.CLIENT_HANDSHAKE_TIMEOUT, 300);
        clientConnectorConfig.setIdleTimeoutInMillis(Math.toIntExact(handshakeTimeoutInSeconds) * 1000);
        BMap headerValues = clientEndpointConfig.getMapValue(WebSocketConstants.CUSTOM_HEADERS);
        if (headerValues != null) {
            clientConnectorConfig.addHeaders(WebSocketUtil.getCustomHeaders((BMap<BString, Object>)headerValues));
        }
        clientConnectorConfig.setMaxFrameSize(WebSocketUtil.findMaxFrameSize(clientEndpointConfig));
        BMap secureSocket = clientEndpointConfig.getMapValue(WebSocketConstants.ENDPOINT_CONFIG_SECURE_SOCKET);
        if (secureSocket != null) {
            HttpUtil.populateSSLConfiguration((SslConfiguration)clientConnectorConfig, (BMap)secureSocket);
        } else if (scheme.equals("wss")) {
            clientConnectorConfig.useJavaDefaults();
        }
        clientConnectorConfig.setWebSocketCompressionEnabled(clientEndpointConfig.getBooleanValue(WebSocketConstants.COMPRESSION_ENABLED_CONFIG).booleanValue());
    }

    public static Object getHttpResponse(Environment env, BObject wsSyncClient) {
        return wsSyncClient.getNativeData("response");
    }

    private static void populateRetryConnectorConfig(BMap<BString, Object> retryConfig, RetryContext retryConnectorConfig) {
        retryConnectorConfig.setInterval(WebSocketUtil.findTimeoutInSeconds(retryConfig, StringUtils.fromString((String)INTERVAL), 1));
        retryConnectorConfig.setBackOfFactor(SyncInitEndpoint.getDoubleValue(retryConfig));
        retryConnectorConfig.setMaxInterval(WebSocketUtil.findTimeoutInSeconds(retryConfig, StringUtils.fromString((String)MAX_WAIT_INTERVAL), 30));
        retryConnectorConfig.setMaxAttempts(SyncInitEndpoint.getIntValue(retryConfig, MAX_COUNT, 0));
    }

    private static int getIntValue(BMap<BString, Object> configs, String key, int defaultValue) {
        int value = Math.toIntExact(configs.getIntValue(StringUtils.fromString((String)key)));
        if (value < 0) {
            value = defaultValue;
        }
        return value;
    }

    private static Double getDoubleValue(BMap<BString, Object> configs) {
        double value = Math.toRadians(configs.getFloatValue(StringUtils.fromString((String)BACK_OF_FACTOR)));
        if (value < 1.0) {
            value = 1.0;
        }
        return value;
    }

    private SyncInitEndpoint() {
    }
}

