/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.observability;

import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.websocket.observability.WebSocketObservabilityUtil;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionInfo;

public class WebSocketObserverContext
extends ObserverContext {
    private static final String PROTOCOL = "ws";
    private String connectionId = "unknown";
    private String servicePathOrClientUrl = "unknown";

    WebSocketObserverContext() {
        this.setObjectName(PROTOCOL);
    }

    public WebSocketObserverContext(WebSocketConnectionInfo connectionInfo) {
        this();
        this.connectionId = WebSocketObservabilityUtil.getConnectionId(connectionInfo);
        this.servicePathOrClientUrl = WebSocketObservabilityUtil.getServicePathOrClientUrl(connectionInfo);
        this.setTags(connectionInfo);
    }

    public void setTags(WebSocketConnectionInfo connectionInfo) {
        String clientOrServerContext = WebSocketObservabilityUtil.getClientOrServerContext(connectionInfo);
        this.addTag("client_or_server", clientOrServerContext);
        this.addTag("service", this.servicePathOrClientUrl);
        this.addTag("protocol", PROTOCOL);
    }

    String getConnectionId() {
        return this.connectionId;
    }

    String getServicePathOrClientUrl() {
        return this.servicePathOrClientUrl;
    }
}

