/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.observability;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.websocket.observability.WebSocketObservabilityUtil;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionInfo;

public class WebSocketTracingUtil {
    static void traceResourceInvocation(Environment environment, WebSocketConnectionInfo connectionInfo) {
        if (!ObserveUtils.isTracingEnabled()) {
            return;
        }
        ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Environment)environment);
        if (observerContext != null) {
            WebSocketTracingUtil.setTags(observerContext, connectionInfo);
            return;
        }
        observerContext = new ObserverContext();
        ObserveUtils.setObserverContextToCurrentFrame((Environment)environment, (ObserverContext)observerContext);
        WebSocketTracingUtil.setTags(observerContext, connectionInfo);
    }

    private static void setTags(ObserverContext observerContext, WebSocketConnectionInfo connectionInfo) {
        observerContext.addTag("client_or_server", WebSocketObservabilityUtil.getClientOrServerContext(connectionInfo));
        observerContext.addTag("service", WebSocketObservabilityUtil.getServicePathOrClientUrl(connectionInfo));
    }

    private WebSocketTracingUtil() {
    }
}

