/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.server;

import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.websocket.ModuleUtils;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketService;
import io.ballerina.stdlib.websocket.WebSocketUtil;

public class WebSocketServerService
extends WebSocketService {
    private String[] negotiableSubProtocols = null;
    private String basePath;
    private int maxFrameSize = 65536;
    private int idleTimeoutInSeconds = 0;
    private boolean enableValidation = true;
    private String dispatchingKey = null;

    public WebSocketServerService(BObject service, Runtime runtime, String basePath) {
        super(service, runtime);
        this.populateConfigs(basePath);
    }

    private void populateConfigs(String basePath) {
        BMap<BString, Object> configAnnotation = this.getServiceConfigAnnotation();
        if (configAnnotation != null) {
            this.negotiableSubProtocols = WebSocketUtil.findNegotiableSubProtocols(configAnnotation);
            this.idleTimeoutInSeconds = WebSocketUtil.findTimeoutInSeconds(configAnnotation, WebSocketConstants.ANNOTATION_ATTR_IDLE_TIMEOUT, 0);
            this.maxFrameSize = WebSocketUtil.findMaxFrameSize(configAnnotation);
            this.enableValidation = configAnnotation.getBooleanValue(WebSocketConstants.ANNOTATION_ATTR_VALIDATION_ENABLED);
            if (configAnnotation.getStringValue(WebSocketConstants.ANNOTATION_ATTR_DISPATCHER_KEY) != null) {
                this.dispatchingKey = configAnnotation.getStringValue(WebSocketConstants.ANNOTATION_ATTR_DISPATCHER_KEY).getValue();
            }
        }
        this.service.addNativeData(WebSocketConstants.ANNOTATION_ATTR_MAX_FRAME_SIZE.toString(), (Object)this.maxFrameSize);
        this.service.addNativeData(WebSocketConstants.ANNOTATION_ATTR_VALIDATION_ENABLED.toString(), (Object)this.enableValidation);
        this.setBasePathToServiceObj(basePath);
    }

    private BMap<BString, Object> getServiceConfigAnnotation() {
        ObjectType serviceType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)this.service));
        return (BMap)serviceType.getAnnotation(StringUtils.fromString((String)(ModuleUtils.getPackageIdentifier() + ":ServiceConfig")));
    }

    public String[] getNegotiableSubProtocols() {
        if (this.negotiableSubProtocols == null) {
            return new String[0];
        }
        return (String[])this.negotiableSubProtocols.clone();
    }

    public int getIdleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setBasePathToServiceObj(String basePath) {
        this.service.addNativeData("BASE_PATH", (Object)basePath);
        this.basePath = basePath;
    }

    public String getDispatchingKey() {
        return this.dispatchingKey;
    }

    public String getBasePath() {
        return this.basePath;
    }
}

