/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.validators;

import io.ballerina.stdlib.constraint.ConstraintErrorInfo;
import io.ballerina.stdlib.constraint.validators.NumberConstraintValidator;
import java.util.List;

public class IntConstraintValidator
extends NumberConstraintValidator {
    public IntConstraintValidator(List<ConstraintErrorInfo> failedConstraintsInfo) {
        super(failedConstraintsInfo);
    }

    @Override
    public boolean validateMinValue(Object fieldValue, Object constraintValue) {
        return ((Number)fieldValue).longValue() >= (Long)constraintValue;
    }

    @Override
    public boolean validateMaxValue(Object fieldValue, Object constraintValue) {
        return ((Number)fieldValue).longValue() <= (Long)constraintValue;
    }

    @Override
    public boolean validateMinValueExclusive(Object fieldValue, Object constraintValue) {
        return ((Number)fieldValue).longValue() > (Long)constraintValue;
    }

    @Override
    public boolean validateMaxValueExclusive(Object fieldValue, Object constraintValue) {
        return ((Number)fieldValue).longValue() < (Long)constraintValue;
    }

    @Override
    public boolean validateMaxDigits(Object fieldValue, Object constraintValue) {
        long fieldNumericValue = ((Number)fieldValue).longValue();
        String numericString = Long.toString(fieldNumericValue);
        int length = fieldNumericValue < 0L ? numericString.length() - 1 : numericString.length();
        return (long)length <= (Long)constraintValue;
    }

    @Override
    public boolean validateMaxIntegerDigits(Object fieldValue, Object constraintValue) {
        return true;
    }

    @Override
    public boolean validateMaxFractionDigits(Object fieldValue, Object constraintValue) {
        return true;
    }
}

