/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.runtime.engine;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.FiniteType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.constraint.Constraints;
import io.ballerina.stdlib.graphql.runtime.engine.EngineUtils;
import io.ballerina.stdlib.graphql.runtime.exception.ConstraintValidationException;
import io.ballerina.stdlib.graphql.runtime.utils.Utils;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class ArgumentHandler {
    private final BMap<BString, Object> argumentsMap;
    private final MethodType method;
    private final BMap<BString, Object> fileInfo;
    private final BObject context;
    private final BObject field;
    private final BObject responseGenerator;
    private final boolean validation;
    private static final String REPRESENTATION_TYPENAME = "Representation";
    private static final String ADD_CONSTRAINT_ERRORS_METHOD = "addConstraintValidationErrors";
    private static final String CONSTRAINT_ERROR_MESSAGE = "Constraint validation errors found.";
    private static final BString KIND_FIELD = StringUtils.fromString((String)"kind");
    private static final int T_STRING = 2;
    private static final int T_INT = 3;
    private static final int T_FLOAT = 4;
    private static final int T_BOOLEAN = 5;
    private static final int T_INPUT_OBJECT = 22;
    private static final int T_LIST = 23;
    private static final ArrayList<String> idsList = new ArrayList();
    private static final String ID_ANNOTATION = "ID";
    private static final String PACKAGE_NAME = "ballerina/graphql";
    private static final String RETURN_TYPE_PARAM = "$returns$";
    private static final String ARGUMENT_TYPE_PARAM = "$param$";

    public ArgumentHandler(MethodType method, BObject context, BObject field, BObject responseGenerator, boolean validation) {
        this.method = method;
        this.fileInfo = (BMap)context.getNativeData("graphql.context.fileInfo");
        this.context = context;
        this.field = field;
        this.populateIdTypeArguments((BMap<BString, Object>)method.getAnnotations());
        this.argumentsMap = ValueCreator.createMapValue();
        this.responseGenerator = responseGenerator;
        this.validation = validation;
        BObject fieldNode = this.field.getObjectValue(Utils.INTERNAL_NODE);
        this.populateArgumentsMap(fieldNode);
    }

    private void populateIdTypeArguments(BMap<BString, Object> annotations) {
        int i = 0;
        for (Object annotation : annotations.values().toArray()) {
            BMap annotationMap = (BMap)annotation;
            for (Object annotationKey : annotationMap.getKeys()) {
                if (!this.isIdAnnotation(annotationKey) || ((BString[])annotations.getKeys())[i].getValue().equals(RETURN_TYPE_PARAM)) continue;
                String[] annotationValue = ((BString[])annotations.getKeys())[i].getValue().split("\\.");
                if (annotationValue.length == 2 && annotationValue[0].equals(ARGUMENT_TYPE_PARAM)) {
                    idsList.add(annotationValue[1]);
                }
                ++i;
            }
        }
    }

    private boolean isIdAnnotation(Object annotationKey) {
        String[] fullTypeName = annotationKey.toString().replaceAll("\\d", "").split("::");
        return fullTypeName[0].equals(PACKAGE_NAME) && fullTypeName[1].equals(ID_ANNOTATION);
    }

    public Object[] getArguments() {
        return this.getArgumentsForMethod();
    }

    public void validateInputConstraint(Environment environment) throws ConstraintValidationException {
        if (this.validation) {
            BArray errors = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_ERROR));
            BObject fieldNode = this.field.getObjectValue(Utils.INTERNAL_NODE);
            BArray argumentArray = fieldNode.getArrayValue(EngineUtils.ARGUMENTS_FIELD);
            for (int i = 0; i < argumentArray.size(); ++i) {
                BTypedesc bTypedesc;
                BObject argumentNode = (BObject)argumentArray.get((long)i);
                BString argumentName = argumentNode.getStringValue(EngineUtils.NAME_FIELD);
                Parameter parameter = Objects.requireNonNull(this.getParameterForArgumentNode(argumentName));
                Object argumentValue = this.argumentsMap.get((Object)argumentName);
                Object validationResult = Constraints.validate((Object)argumentValue, (BTypedesc)(bTypedesc = ArgumentHandler.getTypeDescFromParameter(parameter)));
                if (!(validationResult instanceof BError)) continue;
                errors.append(validationResult);
            }
            if (!errors.isEmpty()) {
                this.addConstraintValidationErrors(environment, errors);
                throw new ConstraintValidationException(CONSTRAINT_ERROR_MESSAGE);
            }
        }
    }

    private void populateArgumentsMap(BObject fieldNode) {
        BArray argumentArray = fieldNode.getArrayValue(EngineUtils.ARGUMENTS_FIELD);
        for (int i = 0; i < argumentArray.size(); ++i) {
            BObject argumentNode = (BObject)argumentArray.get((long)i);
            BString argumentName = argumentNode.getStringValue(EngineUtils.NAME_FIELD);
            Parameter parameter = Objects.requireNonNull(this.getParameterForArgumentNode(argumentName));
            Object argumentValue = this.getArgumentValue(argumentNode, parameter.type);
            this.argumentsMap.put((Object)argumentName, argumentValue);
        }
    }

    private Object getArgumentValue(BObject argumentNode, Type parameterType) {
        if (idsList.contains(argumentNode.getStringValue(EngineUtils.NAME_FIELD).getValue())) {
            return this.getIdArgumentValue(argumentNode, parameterType);
        }
        if (Utils.isFileUpload(parameterType)) {
            return this.getFileUploadParameter(argumentNode, parameterType);
        }
        if (this.isRepresentationArgument(parameterType)) {
            Object jsonRepresentation = this.getJsonArgument(argumentNode);
            return this.getRepresentationArgument(jsonRepresentation, parameterType);
        }
        if (parameterType.getTag() == 24) {
            return this.getInputObjectArgument(argumentNode, (RecordType)parameterType);
        }
        if (parameterType.getTag() == 34) {
            return this.getIntersectionTypeArgument(argumentNode, (IntersectionType)parameterType);
        }
        if (parameterType.getTag() == 32) {
            return this.getArrayTypeArgument(argumentNode, (ArrayType)parameterType);
        }
        if (parameterType.getTag() == 33) {
            return this.getUnionTypeArgument(argumentNode, (UnionType)parameterType);
        }
        if (parameterType.getTag() == 53) {
            return this.getArgumentValue(argumentNode, TypeUtils.getReferredType((Type)parameterType));
        }
        return this.getScalarArgumentValue(argumentNode);
    }

    private Object getIdArgumentValue(BObject argumentNode, Type parameterType) {
        if (argumentNode.get(EngineUtils.VALUE_FIELD) instanceof BString) {
            String obj = ((BString)argumentNode.get(EngineUtils.VALUE_FIELD)).getValue();
            return this.getIdValueFromString(obj, parameterType, argumentNode);
        }
        if (argumentNode.get(EngineUtils.VALUE_FIELD) instanceof BArray) {
            return this.getIdValueFromBArray(argumentNode, parameterType, (BArray)argumentNode.get(EngineUtils.VALUE_FIELD));
        }
        if (argumentNode.get(StringUtils.fromString((String)"variableValue")) instanceof BArray) {
            return this.getIdValueFromBArray(argumentNode, parameterType, (BArray)argumentNode.get(StringUtils.fromString((String)"variableValue")));
        }
        return argumentNode.get(EngineUtils.VALUE_FIELD);
    }

    private Object getIdValueFromBArray(BObject argumentNode, Type parameterType, BArray bArray) {
        if (parameterType.getTag() == 33) {
            for (Type memberType : ((UnionType)parameterType).getMemberTypes()) {
                if (memberType.getTag() != 32) continue;
                return this.getIdValueFromBArray(argumentNode, memberType, bArray);
            }
        }
        if (((ArrayType)parameterType).getElementType().getTag() == 1) {
            int i = 0;
            long[] longArray = new long[bArray.size()];
            for (Object obj : bArray.getValues()) {
                BObject bObject = (BObject)obj;
                longArray[i] = bObject.getIntValue(EngineUtils.VALUE_FIELD);
                ++i;
            }
            return ValueCreator.createArrayValue((long[])longArray);
        }
        String[] stringArray = new String[bArray.size()];
        int i = 0;
        for (Object obj : bArray.getValues()) {
            if (obj instanceof BString) {
                stringArray[i] = ((BString)obj).getValue();
            } else {
                BObject bObject = (BObject)obj;
                stringArray[i] = bObject.getStringValue(EngineUtils.VALUE_FIELD).getValue();
            }
            ++i;
        }
        return this.getArrayTypeIdValue(parameterType, stringArray);
    }

    private Object getIdValueFromString(String obj, Type parameterType, BObject argumentNode) {
        if (parameterType.getTag() == 5) {
            return StringUtils.fromString((String)obj);
        }
        if (parameterType.getTag() == 1) {
            return Integer.parseInt(obj);
        }
        if (parameterType.getTag() == 3) {
            return ValueUtils.convert((Object)JsonUtils.parse((String)obj), (Type)parameterType);
        }
        if (parameterType.getTag() == 4) {
            return ValueUtils.convert((Object)JsonUtils.parse((String)obj), (Type)parameterType);
        }
        if (parameterType.getTag() == 53) {
            return ValueCreator.createRecordValue((Module)parameterType.getPackage(), (String)parameterType.getName(), (BMap)((BMap)JsonUtils.parse((String)obj.replaceAll("\\\\", ""))));
        }
        if (parameterType.getTag() == 33) {
            return this.getUnionTypeIdValue(parameterType, argumentNode);
        }
        return argumentNode.get(EngineUtils.VALUE_FIELD);
    }

    private Object getUnionTypeIdValue(Type parameterType, BObject argumentNode) {
        List members = ((UnionType)parameterType).getMemberTypes();
        for (Type member : members) {
            if (member.getTag() == 14 || member.getTag() == 42) continue;
            return this.getIdArgumentValue(argumentNode, member);
        }
        return null;
    }

    private Object getArrayTypeIdValue(Type parameterType, String[] stringArray) {
        Type memberType = ((ArrayType)parameterType).getElementType();
        if (memberType.getTag() == 1) {
            return ValueCreator.createArrayValue((long[])this.getIntArrayTypeIdValue(stringArray));
        }
        if (memberType.getTag() == 3) {
            return ValueCreator.createArrayValue((byte[])Arrays.toString(this.getFloatArrayTypeIdValue(stringArray)).getBytes(StandardCharsets.UTF_8));
        }
        if (memberType.getTag() == 4) {
            return ValueCreator.createArrayValue((byte[])Arrays.toString(this.getDecimalArrayTypeIdValue(stringArray)).getBytes(StandardCharsets.UTF_8));
        }
        if (memberType.getTag() == 5) {
            return ValueCreator.createArrayValue((BString[])this.getStringArrayTypeIdValue(stringArray));
        }
        if (memberType.getTag() == 53) {
            return ValueCreator.createArrayValue((Object[])this.getTypeRefArrayTypeIdValue(stringArray, parameterType), (ArrayType)((ArrayType)parameterType));
        }
        return null;
    }

    private BMap<BString, Object>[] getTypeRefArrayTypeIdValue(String[] stringValues, Type parameterType) {
        BMap[] uuidArray = new BMap[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            uuidArray[i] = ValueCreator.createRecordValue((Module)((ArrayType)parameterType).getElementType().getPackage(), (String)((ArrayType)parameterType).getElementType().getName(), (BMap)((BMap)JsonUtils.parse((String)stringValues[i].replaceAll("\\\\", ""))));
        }
        return uuidArray;
    }

    private BString[] getStringArrayTypeIdValue(String[] stringValues) {
        BString[] bStringArray = new BString[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            bStringArray[i] = StringUtils.fromString((String)stringValues[i]);
        }
        return bStringArray;
    }

    private BigDecimal[] getDecimalArrayTypeIdValue(String[] stringArray) {
        BigDecimal[] values = new BigDecimal[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            values[i] = new BigDecimal(stringArray[i]);
        }
        return values;
    }

    private float[] getFloatArrayTypeIdValue(String[] stringArray) {
        float[] values = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            values[i] = Float.parseFloat(stringArray[i]);
        }
        return values;
    }

    private long[] getIntArrayTypeIdValue(String[] stringArray) {
        long[] values = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("")) continue;
            values[i] = Integer.parseInt(stringArray[i]);
        }
        return values;
    }

    private BMap<BString, Object> getRepresentationArgument(Object jsonRepresentation, Type parameterType) {
        BMap map = JsonUtils.convertJSONToMap((Object)jsonRepresentation, (MapType)PredefinedTypes.TYPE_MAP);
        return ValueCreator.createRecordValue((Module)parameterType.getPackage(), (String)parameterType.getName(), (BMap)map);
    }

    private Object getFileUploadParameter(BObject argumentNode, Type parameterType) {
        if (parameterType.getTag() == 32) {
            return this.fileInfo.getArrayValue(argumentNode.getStringValue(EngineUtils.VARIABLE_NAME_FIELD));
        }
        return this.fileInfo.getMapValue(argumentNode.getStringValue(EngineUtils.VARIABLE_NAME_FIELD));
    }

    private BMap<BString, Object> getInputObjectArgument(BObject argumentNode, RecordType recordType) {
        BMap recordValue = (BMap)recordType.getZeroValue();
        if (argumentNode.getBooleanValue(EngineUtils.VARIABLE_DEFINITION)) {
            BMap variablesMap = argumentNode.getMapValue(EngineUtils.VARIABLE_VALUE_FIELD);
            return ValueCreator.createRecordValue((Module)recordType.getPackage(), (String)recordType.getName(), (BMap)variablesMap);
        }
        BArray inputObjectFields = argumentNode.getArrayValue(EngineUtils.VALUE_FIELD);
        for (int i = 0; i < inputObjectFields.size(); ++i) {
            BObject inputObjectField = (BObject)inputObjectFields.get((long)i);
            BString inputObjectFieldName = inputObjectField.getStringValue(EngineUtils.NAME_FIELD);
            Field field = (Field)recordType.getFields().get(inputObjectFieldName.getValue());
            Object fieldValue = this.getArgumentValue(inputObjectField, field.getFieldType());
            recordValue.put((Object)inputObjectFieldName, fieldValue);
        }
        return recordValue;
    }

    private Object getJsonArgument(BObject argumentNode) {
        int kind = (int)argumentNode.getIntValue(KIND_FIELD);
        Object valueField = argumentNode.get(EngineUtils.VALUE_FIELD);
        switch (kind) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return JsonUtils.convertToJson((Object)valueField);
            }
            case 22: {
                return this.getJsonObject(argumentNode);
            }
            case 23: {
                return this.getJsonList(argumentNode);
            }
        }
        return null;
    }

    private Object getJsonList(BObject argumentNode) {
        BArray valueArray = ValueCreator.createArrayValue((ArrayType)PredefinedTypes.TYPE_JSON_ARRAY);
        BArray argumentArray = argumentNode.getArrayValue(EngineUtils.VALUE_FIELD);
        for (int i = 0; i < argumentArray.size(); ++i) {
            BObject argumentElementNode = (BObject)argumentArray.get((long)i);
            Object elementValue = this.getJsonArgument(argumentElementNode);
            valueArray.append(elementValue);
        }
        return JsonUtils.convertToJson((Object)valueArray);
    }

    private Object getJsonObject(BObject argumentNode) {
        BMap mapValue = ValueCreator.createMapValue();
        BArray inputObjectFields = argumentNode.getArrayValue(EngineUtils.VALUE_FIELD);
        for (int i = 0; i < inputObjectFields.size(); ++i) {
            BObject inputObjectField = (BObject)inputObjectFields.get((long)i);
            BString inputObjectFieldName = inputObjectField.getStringValue(EngineUtils.NAME_FIELD);
            Object fieldValue = this.getJsonArgument(inputObjectField);
            mapValue.put((Object)inputObjectFieldName, fieldValue);
        }
        return JsonUtils.convertToJson((Object)mapValue);
    }

    private Object getIntersectionTypeArgument(BObject argumentNode, IntersectionType intersectionType) {
        Type effectiveType = TypeUtils.getReferredType((Type)ArgumentHandler.getEffectiveType(intersectionType));
        if (effectiveType.getTag() == 32) {
            BArray valueArray = this.getArrayTypeArgument(argumentNode, (ArrayType)effectiveType);
            valueArray.freezeDirect();
            return valueArray;
        }
        BMap<BString, Object> argumentValue = this.getInputObjectArgument(argumentNode, (RecordType)effectiveType);
        argumentValue.freezeDirect();
        return argumentValue;
    }

    private BArray getArrayTypeArgument(BObject argumentNode, ArrayType arrayType) {
        BArray valueArray = ValueCreator.createArrayValue((ArrayType)arrayType);
        if (argumentNode.getBooleanValue(EngineUtils.VARIABLE_DEFINITION)) {
            BArray argumentsArray = argumentNode.getArrayValue(EngineUtils.VARIABLE_VALUE_FIELD);
            if (this.isRepresentationArgument(arrayType.getElementType())) {
                Object[] representations = argumentsArray.getValues();
                Object[] representationRecords = Arrays.stream(representations).map(entity -> this.getRepresentationArgument(entity, arrayType.getElementType())).toArray();
                return ValueCreator.createArrayValue((Object[])representationRecords, (ArrayType)arrayType);
            }
            return (BArray)JsonUtils.convertJSON((Object)argumentsArray, (Type)arrayType);
        }
        BArray argumentArray = argumentNode.getArrayValue(EngineUtils.VALUE_FIELD);
        for (int i = 0; i < argumentArray.size(); ++i) {
            BObject argumentElementNode = (BObject)argumentArray.get((long)i);
            Object elementValue = this.getArgumentValue(argumentElementNode, arrayType.getElementType());
            valueArray.append(elementValue);
        }
        return valueArray;
    }

    private Object getUnionTypeArgument(BObject argumentNode, UnionType unionType) {
        if (EngineUtils.isEnum(unionType)) {
            return this.getEnumTypeArgument(argumentNode, unionType);
        }
        if (unionType.isNilable()) {
            if (argumentNode.getBooleanValue(EngineUtils.VARIABLE_DEFINITION) && argumentNode.get(EngineUtils.VARIABLE_VALUE_FIELD) == null) {
                return null;
            }
            if (!argumentNode.getBooleanValue(EngineUtils.VARIABLE_DEFINITION) && argumentNode.get(EngineUtils.VALUE_FIELD) == null) {
                return null;
            }
        }
        Type effectiveType = ArgumentHandler.getEffectiveType(unionType);
        return this.getArgumentValue(argumentNode, effectiveType);
    }

    private Object getEnumTypeArgument(BObject argumentNode, UnionType enumType) {
        BString enumName = argumentNode.getBooleanValue(EngineUtils.VARIABLE_DEFINITION) ? argumentNode.getStringValue(EngineUtils.VARIABLE_VALUE_FIELD) : argumentNode.getStringValue(EngineUtils.VALUE_FIELD);
        Object result = enumName;
        for (Type memberType : enumType.getMemberTypes()) {
            if (memberType.getTag() != 46) continue;
            FiniteType finiteType = (FiniteType)memberType;
            if (!enumName.getValue().equals(finiteType.getName())) continue;
            result = finiteType.getZeroValue();
        }
        return result;
    }

    private Object getScalarArgumentValue(BObject argumentNode) {
        if (argumentNode.getBooleanValue(EngineUtils.VARIABLE_DEFINITION)) {
            return argumentNode.get(EngineUtils.VARIABLE_VALUE_FIELD);
        }
        return argumentNode.get(EngineUtils.VALUE_FIELD);
    }

    private Parameter getParameterForArgumentNode(BString paramName) {
        for (Parameter parameter : this.method.getParameters()) {
            if (!parameter.name.equals(paramName.getValue())) continue;
            return parameter;
        }
        return null;
    }

    private Object[] getArgumentsForMethod() {
        Parameter[] parameters = this.method.getParameters();
        Object[] result = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            result[i] = Utils.isContext(parameters[i].type) ? this.context : (Utils.isField(parameters[i].type) ? this.field : (this.argumentsMap.get((Object)StringUtils.fromString((String)parameters[i].name)) == null ? parameters[i].type.getZeroValue() : this.argumentsMap.get((Object)StringUtils.fromString((String)parameters[i].name))));
        }
        return result;
    }

    static Type getEffectiveType(IntersectionType intersectionType) {
        for (Type constituentType : intersectionType.getConstituentTypes()) {
            if (constituentType.getTag() == 51) continue;
            return constituentType;
        }
        return intersectionType;
    }

    private static Type getEffectiveType(UnionType unionType) {
        for (Type memberType : unionType.getOriginalMemberTypes()) {
            if (EngineUtils.isIgnoreType(memberType)) continue;
            return memberType;
        }
        return unionType;
    }

    private boolean isRepresentationArgument(Type type) {
        return TypeUtils.getReferredType((Type)type).getTag() == 24 && Utils.isSubgraphModule(type) && type.getName().equals(REPRESENTATION_TYPENAME);
    }

    private void addConstraintValidationErrors(Environment environment, BArray errors) {
        environment.yieldAndRun(() -> {
            BObject fieldNode = this.field.getObjectValue(Utils.INTERNAL_NODE);
            Object[] arguments = new Object[]{errors, fieldNode};
            try {
                return environment.getRuntime().callMethod(this.responseGenerator, ADD_CONSTRAINT_ERRORS_METHOD, null, arguments);
            }
            catch (BError bError) {
                Utils.handleFailureAndExit(bError);
                return null;
            }
        });
    }

    private static BTypedesc getTypeDescFromParameter(Parameter parameter) {
        BTypedesc bTypedesc = ValueCreator.createTypedescValue((Type)parameter.type);
        if (bTypedesc.getDescribingType().getTag() == 34) {
            Type type = ArgumentHandler.getEffectiveType((IntersectionType)bTypedesc.getDescribingType());
            return ValueCreator.createTypedescValue((Type)type);
        }
        return bTypedesc;
    }
}

