/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.runtime.engine;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.graphql.runtime.observability.GraphqlObserverContext;
import io.ballerina.stdlib.graphql.runtime.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class ListenerUtils {
    private static final String HTTP_SERVICE = "graphql.http.service";
    private static final String WS_SERVICE = "graphql.websocket.service";
    private static final String GRAPHIQL_SERVICE = "graphql.graphiql.service";
    private static final String SAMPLE_URL = "http://localhost:9000/";
    public static final String GRAPHIQL_RESOURCE = "graphiql.html";
    private static final String REGEX_URL = "${url}";
    private static final String SUBSCRIPTION_URL = "${subscriptionUrl}";
    private static final String FORWARD_SLASH = "/";

    private ListenerUtils() {
    }

    public static void attachHttpServiceToGraphqlService(BObject graphqlService, BObject httpService) {
        graphqlService.addNativeData(HTTP_SERVICE, (Object)httpService);
    }

    public static void attachWebsocketServiceToGraphqlService(BObject graphqlService, BObject wsService) {
        graphqlService.addNativeData(WS_SERVICE, (Object)wsService);
    }

    public static void attachGraphiqlServiceToGraphqlService(BObject graphqlService, BObject httpService) {
        graphqlService.addNativeData(GRAPHIQL_SERVICE, (Object)httpService);
    }

    public static Object getHttpServiceFromGraphqlService(BObject graphqlService) {
        Object httpService = graphqlService.getNativeData(HTTP_SERVICE);
        if (httpService instanceof BObject) {
            return httpService;
        }
        return null;
    }

    public static Object getWebsocketServiceFromGraphqlService(BObject graphqlService) {
        Object wsService = graphqlService.getNativeData(WS_SERVICE);
        if (wsService instanceof BObject) {
            return wsService;
        }
        return null;
    }

    public static Object getGraphiqlServiceFromGraphqlService(BObject graphqlService) {
        Object graphiqlService = graphqlService.getNativeData(GRAPHIQL_SERVICE);
        if (graphiqlService instanceof BObject) {
            return graphiqlService;
        }
        return null;
    }

    public static Object validateGraphiqlPath(BString path) {
        String uri = SAMPLE_URL + String.valueOf(path);
        try {
            new URL(uri).toURI();
            return null;
        }
        catch (MalformedURLException | URISyntaxException e) {
            return Utils.createError("Invalid path provided for GraphiQL client", "Error");
        }
    }

    public static BString getBasePath(Object serviceName) {
        if (serviceName instanceof BArray) {
            List strings = Arrays.stream(((BArray)serviceName).getStringArray()).map(ListenerUtils::unescapeValue).collect(Collectors.toList());
            String basePath = String.join((CharSequence)FORWARD_SLASH, strings);
            return ListenerUtils.sanitizeBasePath(basePath);
        }
        String path = ((BString)serviceName).getValue().trim();
        if (path.startsWith(FORWARD_SLASH)) {
            path = path.substring(1);
        }
        String[] pathSplits = path.split(FORWARD_SLASH);
        List strings = Arrays.stream(pathSplits).map(ListenerUtils::unescapeValue).collect(Collectors.toList());
        String basePath = String.join((CharSequence)FORWARD_SLASH, strings);
        return ListenerUtils.sanitizeBasePath(basePath);
    }

    public static String unescapeValue(String segment) {
        if (!segment.contains("\\")) {
            return segment.trim();
        }
        return segment.replace("\\", "").trim();
    }

    public static BString sanitizeBasePath(String basePath) {
        basePath = basePath.replace("//", FORWARD_SLASH);
        return StringUtils.fromString((String)basePath.trim());
    }

    public static Object getHtmlContentFromResources(BString url, Object subscriptionUrl) {
        InputStream htmlAsStream = ClassLoader.getSystemResourceAsStream(GRAPHIQL_RESOURCE);
        try {
            byte[] bytes = htmlAsStream.readAllBytes();
            String htmlAsString = new String(bytes, StandardCharsets.UTF_8);
            String urlValue = url.getValue();
            htmlAsString = htmlAsString.replace(REGEX_URL, urlValue);
            if (subscriptionUrl != null) {
                htmlAsString = htmlAsString.replace(SUBSCRIPTION_URL, ((BString)subscriptionUrl).getValue());
            }
            return StringUtils.fromString((String)htmlAsString);
        }
        catch (IOException e) {
            return Utils.createError("Error occurred while loading the GraphiQL client", "Error");
        }
    }

    public static void createAndStartObserverContext(Environment environment, BObject context, BString serviceName, BString operationType, BString operationName, BString moduleName, BString fileName, int startLine, int startColumn) {
        GraphqlObserverContext observerContext = new GraphqlObserverContext(operationName.getValue(), serviceName.getValue());
        observerContext.setManuallyClosed(true);
        Object parentContext = context.getNativeData("__observer_context__");
        if (parentContext != null) {
            observerContext.setParent((ObserverContext)parentContext);
        } else {
            observerContext.setParent(ObserveUtils.getObserverContextOfCurrentFrame((Environment)environment));
        }
        context.addNativeData("__observer_context__", (Object)observerContext);
        environment.setStrandLocal("__observer_context__", (Object)observerContext);
        ObserveUtils.startResourceObservation((Environment)environment, (BString)moduleName, (BString)fileName, (long)startLine, (long)startColumn, (BString)serviceName, (BString)operationName, (BString)operationType, (boolean)true, (boolean)false);
    }

    public static void createObserverContext(Environment environment, BObject context, BString serviceName, BString operationType) {
        GraphqlObserverContext observerContext = new GraphqlObserverContext(operationType.getValue(), serviceName.getValue());
        observerContext.setManuallyClosed(true);
        Object parentContext = context.getNativeData("__observer_context__");
        if (parentContext != null) {
            observerContext.setParent((ObserverContext)parentContext);
        } else {
            observerContext.setParent(ObserveUtils.getObserverContextOfCurrentFrame((Environment)environment));
        }
        context.addNativeData("__observer_context__", (Object)observerContext);
        environment.setStrandLocal("__observer_context__", (Object)observerContext);
    }

    public static void stopObserverContext(Environment environment, BObject context) {
        ObserverContext observerContext = (ObserverContext)context.getNativeData("__observer_context__");
        if (observerContext != null && observerContext.isManuallyClosed()) {
            ObserverContext parentContext = observerContext.getParent();
            context.addNativeData("__observer_context__", (Object)parentContext);
            ObserveUtils.stopObservationWithContext((ObserverContext)observerContext);
            environment.setStrandLocal("__observer_context__", (Object)parentContext);
        }
    }

    public static void stopObserverContextWithError(Environment environment, BObject context, BError error) {
        ObserverContext observerContext = (ObserverContext)context.getNativeData("__observer_context__");
        if (observerContext != null && observerContext.isManuallyClosed()) {
            observerContext.addProperty("_ballerina_error_value_", (Object)error);
            ObserverContext parentContext = observerContext.getParent();
            context.addNativeData("__observer_context__", (Object)parentContext);
            ObserveUtils.stopObservationWithContext((ObserverContext)observerContext);
            environment.setStrandLocal("__observer_context__", (Object)parentContext);
        }
    }
}

