/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.io.channels;

import io.ballerina.stdlib.io.channels.FileIOChannel;
import io.ballerina.stdlib.io.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class TempFileIOChannel
extends FileIOChannel {
    private String tempFilePath;

    public TempFileIOChannel(FileChannel channel, String tempFilePath) {
        super(channel);
        this.tempFilePath = tempFilePath;
    }

    @Override
    public void close() throws IOException {
        File tempFile;
        boolean isFileDeleted;
        super.close();
        if (this.tempFilePath != null && !this.tempFilePath.isEmpty() && !(isFileDeleted = (tempFile = new File(this.tempFilePath)).delete())) {
            throw IOUtils.createError("temporary file deletion failure occurred while closing TempFileIOChannel! ");
        }
    }
}

