/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.io.nativeimpl;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.StructureType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.io.nativeimpl.ByteChannelUtils;
import io.ballerina.stdlib.io.nativeimpl.RecordChannelUtils;
import io.ballerina.stdlib.io.utils.IOUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CsvChannelUtils {
    private static final BString FIELD_SEPERATOR = StringUtils.fromString((String)",");
    private static final BString ROW_SEPERATOR = StringUtils.fromString((String)"");
    private static final BString FORMAT = StringUtils.fromString((String)"CSV");
    private static final BString ENCODING = StringUtils.fromString((String)"UTF-8");

    private CsvChannelUtils() {
    }

    public static Object fileReadCsv(BString path, int skipHeaders, BTypedesc typeDesc) {
        Object byteChannelObject = ByteChannelUtils.openReadableFile(path);
        if (byteChannelObject instanceof BError) {
            return byteChannelObject;
        }
        BObject byteChannel = (BObject)byteChannelObject;
        BObject characterChannel = ValueCreator.createObjectValue((Module)IOUtils.getIOPackage(), (String)"ReadableCharacterChannel", (Object[])new Object[]{byteChannel, ENCODING});
        BObject textRecordChannel = ValueCreator.createObjectValue((Module)IOUtils.getIOPackage(), (String)"ReadableTextRecordChannel", (Object[])new Object[]{characterChannel, FIELD_SEPERATOR, ROW_SEPERATOR, FORMAT});
        textRecordChannel.addNativeData("csv_return_type", (Object)typeDesc);
        if (RecordChannelUtils.hasNext(textRecordChannel)) {
            return RecordChannelUtils.getAllRecords(textRecordChannel, skipHeaders, typeDesc);
        }
        return null;
    }

    public static Object createCsvAsStream(BString path, BTypedesc typeDesc) {
        Type describingType = TypeUtils.getReferredType((Type)typeDesc.getDescribingType());
        Object byteChannelObject = ByteChannelUtils.openReadableFile(path);
        if (byteChannelObject instanceof BError) {
            return byteChannelObject;
        }
        BObject byteChannel = (BObject)byteChannelObject;
        BObject characterChannel = ValueCreator.createObjectValue((Module)IOUtils.getIOPackage(), (String)"ReadableCharacterChannel", (Object[])new Object[]{byteChannel, ENCODING});
        BObject textRecordChannel = ValueCreator.createObjectValue((Module)IOUtils.getIOPackage(), (String)"ReadableTextRecordChannel", (Object[])new Object[]{characterChannel, FIELD_SEPERATOR, ROW_SEPERATOR, FORMAT});
        BObject recordIterator = ValueCreator.createObjectValue((Module)IOUtils.getIOPackage(), (String)"CsvIterator", (Object[])new Object[0]);
        recordIterator.addNativeData("csv_return_type", (Object)typeDesc);
        recordIterator.addNativeData("iterator_name", (Object)textRecordChannel);
        return ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)describingType), (BObject)recordIterator);
    }

    public static Object getStruct(String[] fields, StructureType structType, ArrayList<String> headerNames) {
        Map internalStructFields = structType.getFields();
        int fieldLength = headerNames.size();
        HashMap<String, Object> struct = null;
        if (fields.length > 0) {
            struct = new HashMap<String, Object>();
            for (int i = 0; i < fieldLength; ++i) {
                List members;
                Field internalStructField = (Field)internalStructFields.get(headerNames.get(i));
                int type = TypeUtils.getReferredType((Type)internalStructField.getFieldType()).getTag();
                String fieldName = internalStructField.getFieldName();
                if (fields.length <= i) continue;
                String value = fields[i];
                if (value == null || value.isEmpty()) {
                    if (type == 33) {
                        members = ((UnionType)internalStructField.getFieldType()).getMemberTypes();
                        if (TypeUtils.getReferredType((Type)((Type)members.get(1))).getTag() == 14) {
                            struct.put(fieldName, null);
                            continue;
                        }
                        return IOUtils.createError("Unsupported nillable field : " + fieldName);
                    }
                    return IOUtils.createError("Field '" + fieldName + "' does not support nil value.");
                }
                if (type == 33) {
                    members = ((UnionType)internalStructField.getFieldType()).getMemberTypes();
                    if (TypeUtils.getReferredType((Type)((Type)members.get(1))).getTag() == 14) {
                        type = TypeUtils.getReferredType((Type)((Type)members.get(0))).getTag();
                    } else {
                        return IOUtils.createError("Unsupported nillable field : " + fieldName + " for value: " + value);
                    }
                }
                String trimmedValue = value.trim();
                try {
                    switch (type) {
                        case 1: {
                            struct.put(fieldName, Long.parseLong(trimmedValue));
                            break;
                        }
                        case 3: {
                            struct.put(fieldName, Double.parseDouble(trimmedValue));
                            break;
                        }
                        case 5: {
                            struct.put(fieldName, trimmedValue);
                            break;
                        }
                        case 4: {
                            struct.put(fieldName, ValueCreator.createDecimalValue((String)trimmedValue));
                            break;
                        }
                        case 6: {
                            struct.put(fieldName, Boolean.parseBoolean(trimmedValue));
                            break;
                        }
                        default: {
                            return IOUtils.createError("Data mapping support only for int, float, Decimal, boolean and string. Unsupported value for the struct field: " + fieldName);
                        }
                    }
                    continue;
                }
                catch (NumberFormatException e) {
                    return IOUtils.createError("Invalid value: " + trimmedValue + " for the field: '" + fieldName + "'");
                }
            }
            return struct;
        }
        return IOUtils.createError("Empty line detected");
    }
}

